/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command.claimit.claim;

import dev.itsmeow.claimit.api.claim.ClaimArea;
import dev.itsmeow.claimit.api.claim.ClaimManager;
import dev.itsmeow.claimit.api.config.ClaimItAPIConfig;
import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.util.command.CommandUtils;
import dev.itsmeow.claimit.util.text.CommandChatStyle;
import dev.itsmeow.claimit.util.text.FTC;
import dev.itsmeow.claimit.util.text.TeleportXYChatStyle;
import dev.itsmeow.claimit.util.text.TextComponentStyled;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class CommandSubClaimInfo
extends CommandCIBase {
    public String func_71517_b() {
        return "info";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/claimit claim info [name]";
    }

    @Override
    public String getHelp(ICommandSender sender) {
        return "Displays information about a claim. No arguments attempts getting claim for your location. Supplying a name as an argument will give info on that claim. " + (CommandUtils.isAdmin(sender) ? "Admins must use true names." : "");
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        ClaimArea claim;
        if (args.length == 0 && sender instanceof EntityPlayer) {
            claim = ClaimManager.getManager().getClaimAtLocation(sender.func_130014_f_(), sender.func_180425_c());
            if (claim != null) {
                CommandSubClaimInfo.outputClaimInfo(claim, (ICommandSender)((EntityPlayer)sender));
            } else {
                CommandSubClaimInfo.sendMessage(sender, TextFormatting.RED, "There is no claim here!");
            }
        }
        if (args.length == 1) {
            if (sender instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)sender;
                ClaimArea claim2 = CommandUtils.getClaimWithName(args[0], (ICommandSender)player);
                if (claim2 != null) {
                    CommandSubClaimInfo.outputClaimInfo(claim2, (ICommandSender)player);
                } else if (CommandUtils.isAdminNoded(sender, "claimit.command.claimit.claim.info.others") && (claim2 = ClaimManager.getManager().getClaimByTrueName(args[0])) != null) {
                    CommandSubClaimInfo.outputClaimInfo(claim2, (ICommandSender)player);
                } else {
                    CommandSubClaimInfo.sendMessage(sender, TextFormatting.RED, "No claim with this name" + (CommandUtils.isAdmin(sender) ? "!" : " that you own!"));
                }
            } else if (CommandUtils.isAdminNoded(sender, "claimit.command.claimit.claim.info.others")) {
                claim = ClaimManager.getManager().getClaimByTrueName(args[0]);
                if (claim != null) {
                    CommandSubClaimInfo.outputClaimInfo(claim, sender);
                } else {
                    CommandSubClaimInfo.sendBMessage(sender, "No claim with this true name found!");
                }
            }
        }
        if (args.length > 1) {
            CommandSubClaimInfo.sendMessage(sender, TextFormatting.RED, "Invalid argument count. Maximum 1 argument after \"info\". Usage: " + this.func_71518_a(sender));
        }
    }

    private static void outputClaimInfo(ClaimArea claim, ICommandSender sender) {
        World worldIn = sender.func_130014_f_();
        BlockPos[] corners = claim.getTwoMainClaimCorners();
        UUID owner = claim.getOwner();
        String ownerName = CommandUtils.getNameForUUID(owner, worldIn.func_73046_m());
        if (ownerName == null) {
            ownerName = worldIn.func_73046_m().func_152358_ax().func_152652_a(owner).getName();
        }
        int dim = claim.getDimensionID();
        CommandSubClaimInfo.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.BLUE, FTC.Form.BOLD, "Information for claim owned by "), new FTC(TextFormatting.GREEN, FTC.Form.BOLD, ownerName), new FTC(TextFormatting.BLUE, FTC.Form.BOLD, ":")});
        CommandSubClaimInfo.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.BLUE, "Claim Name: "), new FTC(TextFormatting.YELLOW, claim.getDisplayedViewName())});
        CommandSubClaimInfo.runIfAdmin(sender, () -> CommandSubClaimInfo.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.BLUE, "Claim True Name: "), new FTC(TextFormatting.YELLOW, claim.getTrueViewName())}));
        CommandSubClaimInfo.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.BLUE, "Dimension: "), new FTC(TextFormatting.DARK_PURPLE, dim + "")});
        CommandSubClaimInfo.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.BLUE, "Area: "), new FTC(TextFormatting.AQUA, claim.getSideLengthX() + 1 + ""), new FTC(TextFormatting.BLUE, "x"), new FTC(TextFormatting.AQUA, claim.getSideLengthZ() + 1 + ""), new FTC(TextFormatting.BLUE, " ("), new FTC(TextFormatting.AQUA, claim.getArea() + ""), new FTC(TextFormatting.BLUE, ")")});
        CommandSubClaimInfo.sendAdminStyleMessage(sender, TextFormatting.BLUE + "Corner 1: " + TextFormatting.DARK_PURPLE + corners[0].func_177958_n() + TextFormatting.BLUE + ", " + TextFormatting.DARK_PURPLE + corners[0].func_177952_p(), new TeleportXYChatStyle(claim.getDimensionID(), corners[0].func_177958_n(), corners[0].func_177952_p()));
        CommandSubClaimInfo.sendAdminStyleMessage(sender, TextFormatting.BLUE + "Corner 2: " + TextFormatting.DARK_PURPLE + corners[1].func_177958_n() + TextFormatting.BLUE + ", " + TextFormatting.DARK_PURPLE + corners[1].func_177952_p(), new TeleportXYChatStyle(claim.getDimensionID(), corners[1].func_177958_n(), corners[1].func_177952_p()));
        Style viewSubclaimsStyle = new CommandChatStyle("/ci subclaim list " + (CommandUtils.isAdmin(sender) ? claim.getTrueViewName() : claim.getDisplayedViewName()), true, "Click to view subclaim list").func_150238_a(TextFormatting.YELLOW).func_150228_d(Boolean.valueOf(true)).func_150217_b(Boolean.valueOf(true));
        if (CommandUtils.isAdminWithNodeOrManage(sender, claim, "claimit.command.claimit.claim.permission.list.others")) {
            TextComponentStyled viewMembers = new TextComponentStyled("View Members", new CommandChatStyle("/ci claim permission list " + (CommandUtils.isAdmin(sender) ? claim.getTrueViewName() : claim.getDisplayedViewName()), true, "Click to view claim members").func_150238_a(TextFormatting.GREEN).func_150228_d(Boolean.valueOf(true)).func_150217_b(Boolean.valueOf(true)));
            if (ClaimItAPIConfig.enable_subclaims) {
                viewMembers.func_150257_a(new TextComponentString(" ").func_150255_a(new Style().func_150228_d(Boolean.valueOf(false)))).func_150257_a((ITextComponent)new TextComponentStyled("View Subclaims", viewSubclaimsStyle));
            }
            CommandSubClaimInfo.sendMessage(sender, new ITextComponent[]{viewMembers});
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return CommandBase.func_175762_a((String[])args, CommandUtils.getOwnedClaimNames(null, sender));
        }
        return new ArrayList<String>();
    }

    @Override
    public String getPermissionString() {
        return "claimit.claim.info";
    }
}

