/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command.claimit.claim;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import dev.itsmeow.claimit.api.AdminManager;
import dev.itsmeow.claimit.api.claim.ClaimArea;
import dev.itsmeow.claimit.api.claim.ClaimManager;
import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.util.ClaimPage;
import dev.itsmeow.claimit.util.ClaimPageTracker;
import dev.itsmeow.claimit.util.command.CommandUtils;
import dev.itsmeow.claimit.util.text.ClaimInfoChatStyle;
import dev.itsmeow.claimit.util.text.FTC;
import dev.itsmeow.claimit.util.text.PageChatStyle;
import dev.itsmeow.claimit.util.text.TeleportXYChatStyle;
import dev.itsmeow.claimit.util.text.TextComponentStyled;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class CommandSubClaimList
extends CommandCIBase {
    public String func_71517_b() {
        return "list";
    }

    public String func_71518_a(ICommandSender sender) {
        return CommandUtils.isAdminNoded(sender, "claimit.command.claimit.claim.list.others") ? "/claimit claim list [username] [page]" : "/claimit claim list";
    }

    @Override
    public String getHelp(ICommandSender sender) {
        return CommandUtils.isAdminNoded(sender, "claimit.command.claimit.claim.list.others") ? "Lists all claims on the server, takes a page number (or no page for 1) as an argument, can filter to a player (first argument). Next Page is clickable." : "Lists all claims you own. Click names to view info on them.";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String pName = null;
        UUID filter = null;
        String page = null;
        int pg = 0;
        boolean error = false;
        boolean admin = CommandUtils.isAdminNoded(sender, "claimit.command.claimit.claim.list.others");
        if (args.length >= 1 && admin) {
            try {
                Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                error = true;
            }
            if (!error) {
                page = args[0];
            }
        }
        if (error && args.length >= 1 && admin) {
            pName = args[0];
            GameProfile profile = server.func_152358_ax().func_152655_a(pName);
            if (profile == null || !profile.getName().equals(pName)) {
                throw new PlayerNotFoundException("Invalid player: " + args[0]);
            }
            filter = profile.getId();
            page = args.length == 2 ? args[1] : "1";
        }
        if (args.length == 0 && admin) {
            page = "1";
        }
        if (admin) {
            try {
                pg = Integer.parseInt(page);
            }
            catch (NumberFormatException e) {
                throw new CommandException("Invalid page number \"" + page + "\"", new Object[0]);
            }
            int maxPg = ClaimPageTracker.getMaxPage(null);
            if (maxPg < 1) {
                throw new CommandException("No claims exist.", new Object[0]);
            }
        }
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            if (!admin) {
                ImmutableSet claims = ClaimManager.getManager().getClaimsOwnedByPlayer(player.func_146103_bH().getId());
                if (claims != null && claims.size() > 0) {
                    int i = 0;
                    for (ClaimArea claim : claims) {
                        if (++i == 1) {
                            CommandSubClaimList.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.DARK_BLUE, "Claim List for "), new FTC(TextFormatting.GREEN, player.func_70005_c_()), new FTC(TextFormatting.DARK_BLUE, ":")});
                        }
                        sender.func_145747_a((ITextComponent)new TextComponentStyled(TextFormatting.BLUE + "Name: " + TextFormatting.DARK_GREEN + claim.getDisplayedViewName(), new ClaimInfoChatStyle(claim.getDisplayedViewName())));
                    }
                } else {
                    CommandSubClaimList.sendMessage(sender, TextFormatting.RED, "You don't own any claims!");
                }
            } else {
                if (filter == null) {
                    // empty if block
                }
                if (ClaimManager.getManager().getClaimsList().size() == 0) {
                    throw new CommandException("No claims found.", new Object[0]);
                }
                ClaimPage cPage = ClaimPageTracker.getPage(filter, pg - 1);
                if (cPage == null || cPage.getPageSize() == 0) {
                    throw new CommandException("Empty page: " + pg, new Object[0]);
                }
                CommandSubClaimList.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.DARK_PURPLE, FTC.Form.BOLD, "-----Page " + pg + " of " + ClaimPageTracker.getMaxPage(filter) + "-----")});
                int i = (pg - 1) * 3;
                for (ClaimArea claim : cPage.getClaimsInPage()) {
                    CommandSubClaimList.sendMessage(sender, TextFormatting.DARK_RED, FTC.Form.UNDERLINE, "Claim " + (i + 1));
                    CommandSubClaimList.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.BLUE, "Owner: "), new FTC(TextFormatting.GREEN, CommandUtils.getNameForUUID(claim.getOwner(), server))});
                    sender.func_145747_a((ITextComponent)new TextComponentStyled(TextFormatting.BLUE + "Claim True Name: " + TextFormatting.YELLOW + claim.getTrueViewName(), new ClaimInfoChatStyle(claim.getTrueViewName())));
                    CommandSubClaimList.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.BLUE, "Dimension: "), new FTC(TextFormatting.DARK_PURPLE, claim.getDimensionID() + "")});
                    sender.func_145747_a((ITextComponent)new TextComponentStyled(TextFormatting.BLUE + "Location: " + TextFormatting.DARK_PURPLE + claim.getMainPosition().func_177958_n() + TextFormatting.BLUE + ", " + TextFormatting.DARK_PURPLE + claim.getMainPosition().func_177952_p(), new TeleportXYChatStyle(claim.getDimensionID(), claim.getMainPosition().func_177958_n(), claim.getMainPosition().func_177952_p())));
                    ++i;
                }
                if (ClaimPageTracker.getPage(filter, pg) != null) {
                    sender.func_145747_a((ITextComponent)new TextComponentStyled(TextFormatting.GREEN + "" + TextFormatting.ITALIC + "" + TextFormatting.UNDERLINE + "Next Page", new PageChatStyle("claimit claim list", AdminManager.isAdmin((EntityPlayer)player), String.valueOf(pg + 1), pName)));
                }
            }
        } else if (sender.func_70003_b(4, "claimit.claim.list.others")) {
            CommandSubClaimList.sendBMessage(sender, "Detected server console. Getting all claims. Specify a name to get only their claims.");
            int i = 0;
            for (ClaimArea claim : ClaimManager.getManager().getClaimsList()) {
                if (filter != null && !claim.isOwner(filter)) continue;
                CommandSubClaimList.sendBMessage(sender, "####CLAIM INFO####");
                CommandSubClaimList.sendBMessage(sender, "Claim #" + ++i + ", owned by: " + CommandUtils.getNameForUUID(claim.getOwner(), server));
                CommandSubClaimList.sendBMessage(sender, "Claim True Name: " + claim.getTrueViewName());
                CommandSubClaimList.sendBMessage(sender, "Dimension: " + claim.getDimensionID());
                CommandSubClaimList.sendBMessage(sender, "Location: " + claim.getMainPosition().func_177958_n() + ", " + claim.getMainPosition().func_177952_p());
            }
            if (i == 0) {
                CommandSubClaimList.sendBMessage(sender, "No claims found.");
            }
        }
        if (args.length > 2) {
            CommandSubClaimList.sendMessage(sender, TextFormatting.RED, "Invalid amount of arguments. Usage: " + this.func_71518_a(sender));
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (CommandUtils.isAdmin(sender)) {
            return CommandUtils.getPossiblePlayers(null, server, sender, args);
        }
        return new ArrayList<String>();
    }

    @Override
    public String getPermissionString() {
        return "claimit.claim.list";
    }
}

