/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command.claimit.claim;

import com.google.common.collect.ImmutableSet;
import dev.itsmeow.claimit.api.claim.ClaimArea;
import dev.itsmeow.claimit.api.group.GroupManager;
import dev.itsmeow.claimit.api.permission.ClaimPermissionMember;
import dev.itsmeow.claimit.api.permission.ClaimPermissionRegistry;
import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.util.command.CommandUtils;
import dev.itsmeow.claimit.util.text.ClaimInfoChatStyle;
import dev.itsmeow.claimit.util.text.CommandChatStyle;
import dev.itsmeow.claimit.util.text.FTC;
import dev.itsmeow.claimit.util.text.TextComponentStyled;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class CommandSubClaimManage
extends CommandCIBase {
    @Override
    public String getHelp(ICommandSender sender) {
        return "Provides clickable management links for a claim. Defaults to location, but accepts claim name argument.";
    }

    public String func_71517_b() {
        return "manage";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/claimit claim manage [claimname] [member] [playername]";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        ClaimArea claim;
        String cName = null;
        if (args.length == 1) {
            cName = args[0];
        }
        if ((claim = CommandUtils.getClaimWithNameOrLocation(cName, sender)) != null) {
            if (CommandUtils.isAdminWithNodeOrManage(sender, claim, "claimit.command.claimit.claim.manage.others")) {
                String fName;
                String string = fName = CommandUtils.isAdmin(sender) ? claim.getTrueViewName() : claim.getDisplayedViewName();
                if (args.length < 1) {
                    ImmutableSet groups;
                    CommandSubClaimManage.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.BLUE, FTC.Form.BOLD, "Management for "), new FTC(TextFormatting.GREEN, claim.getDisplayedViewName()), new FTC(TextFormatting.BLUE, ":")});
                    CommandSubClaimManage.sendSMessage(sender, "View Info", new ClaimInfoChatStyle(fName).func_150238_a(TextFormatting.YELLOW).func_150217_b(Boolean.valueOf(true)).func_150228_d(Boolean.valueOf(true)));
                    if (CommandUtils.isAdminWithNodeOrOwner(sender, claim, "claimit.command.claimit.claim.delete.others")) {
                        CommandSubClaimManage.sendSMessage(sender, "Delete", new CommandChatStyle("/claimit claim delete " + fName, true, "Click to delete").func_150238_a(TextFormatting.RED).func_150217_b(Boolean.valueOf(true)).func_150228_d(Boolean.valueOf(true)));
                    }
                    if (claim.getMembers().keySet().size() > 0) {
                        CommandSubClaimManage.sendMessage(sender, TextFormatting.BLUE, "Members (click to manage):");
                        claim.getMembers().keySet().forEach(uuid -> {
                            String pName = CommandUtils.getNameForUUID(uuid, server);
                            CommandSubClaimManage.sendSMessage(sender, pName, new CommandChatStyle("/claimit claim manage " + fName + " member " + pName, true, "Click to manage permissions").func_150238_a(TextFormatting.YELLOW).func_150217_b(Boolean.valueOf(true)).func_150228_d(Boolean.valueOf(true)));
                        });
                    }
                    if ((groups = GroupManager.getGroupsForClaim((ClaimArea)claim)).size() > 0) {
                        CommandSubClaimManage.sendMessage(sender, TextFormatting.BLUE, "Groups (click to remove):");
                        groups.forEach(group -> CommandSubClaimManage.sendSMessage(sender, group.getName(), new CommandChatStyle("/claimit group claim remove " + group.getName() + " " + fName, true, "Click to remove from group").func_150238_a(TextFormatting.YELLOW).func_150217_b(Boolean.valueOf(true)).func_150228_d(Boolean.valueOf(true))));
                    }
                } else if (args.length >= 3 && args[1].equals("member") && CommandUtils.getUUIDForName(args[2], server) != null) {
                    CommandSubClaimManage.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.BLUE, FTC.Form.BOLD, "Member management for "), new FTC(TextFormatting.YELLOW, args[2]), new FTC(TextFormatting.BLUE, " in "), new FTC(TextFormatting.GREEN, claim.getDisplayedViewName()), new FTC(TextFormatting.BLUE, ":")});
                    if (args.length == 3) {
                        CommandSubClaimManage.sendSMessage(sender, "Add Permission", new CommandChatStyle("/claimit claim manage " + fName + " member " + args[2] + " add", true, "Click to add permission").func_150238_a(TextFormatting.GREEN).func_150217_b(Boolean.valueOf(true)).func_150228_d(Boolean.valueOf(true)));
                        CommandSubClaimManage.sendSMessage(sender, "Remove Permission", new CommandChatStyle("/claimit claim manage " + fName + " member " + args[2] + " remove", true, "Click to remove permission").func_150238_a(TextFormatting.RED).func_150217_b(Boolean.valueOf(true)).func_150228_d(Boolean.valueOf(true)));
                    } else if (args.length == 4 && (args[3].equals("add") || args[3].equals("remove"))) {
                        CommandSubClaimManage.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.BLUE, FTC.Form.ITALIC, "Choose permission to " + args[3] + ":")});
                        UUID uuid2 = CommandUtils.getUUIDForName(args[2], server);
                        for (ClaimPermissionMember perm : ClaimPermissionRegistry.getMemberPermissions()) {
                            boolean isInList = claim.inPermissionList(perm, uuid2);
                            if ((!args[3].equals("add") || isInList) && (!args[3].equals("remove") || !isInList)) continue;
                            sender.func_145747_a(new TextComponentString(" - ").func_150255_a(new Style().func_150238_a(TextFormatting.BLUE)).func_150257_a((ITextComponent)new TextComponentStyled(perm.parsedName, new CommandChatStyle("/claimit claim permission " + args[3] + " " + perm.parsedName + " " + args[2] + " " + fName, true, "Click to " + args[3]).func_150238_a(TextFormatting.YELLOW).func_150217_b(Boolean.valueOf(true)).func_150228_d(Boolean.valueOf(true)))));
                        }
                    }
                }
            } else {
                CommandSubClaimManage.sendMessage(sender, TextFormatting.RED, "You do have permission to manage this claim!");
            }
        } else {
            CommandSubClaimManage.sendMessage(sender, TextFormatting.RED, cName == null ? "No claim at your location!" : "No claim with this name!");
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (CommandUtils.isAdmin(sender)) {
            return super.func_184883_a(server, sender, args, targetPos);
        }
        return CommandUtils.getOwnedClaimNames(null, sender);
    }

    @Override
    public String getPermissionString() {
        return "claimit.claim.manage";
    }
}

