/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command.claimit.claim;

import dev.itsmeow.claimit.api.AdminManager;
import dev.itsmeow.claimit.api.claim.ClaimArea;
import dev.itsmeow.claimit.api.claim.ClaimManager;
import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.util.command.CommandUtils;
import dev.itsmeow.claimit.util.text.FTC;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.SyntaxErrorException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class CommandSubClaimSetName
extends CommandCIBase {
    public String func_71517_b() {
        return "setname";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/claimit claim setname <name>";
    }

    @Override
    public String getHelp(ICommandSender sender) {
        return "Sets the name of the claim you are currently located in to the first argument (required).";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 1) {
            if (sender instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)sender;
                ClaimArea claim = ClaimManager.getManager().getClaimAtLocation(player.field_70170_p, player.func_180425_c());
                if (claim != null) {
                    if (CommandUtils.isAdminWithNodeOrOwner(sender, claim, "claimit.command.claimit.claim.setname.others")) {
                        boolean pass = claim.setViewName(args[0]);
                        if (pass) {
                            CommandSubClaimSetName.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.AQUA, "Set this claim's name to: "), new FTC(TextFormatting.GREEN, claim.getDisplayedViewName())});
                            if (AdminManager.isAdmin((EntityPlayer)player)) {
                                CommandSubClaimSetName.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.AQUA, "Set this claim's true name to: "), new FTC(TextFormatting.GREEN, claim.getTrueViewName())});
                            }
                        } else {
                            CommandSubClaimSetName.sendMessage(sender, TextFormatting.RED, "Failed to set name. There is another claim " + (AdminManager.isAdmin((EntityPlayer)player) ? "this player owns" : "you own") + " with this name.");
                        }
                    } else {
                        CommandSubClaimSetName.sendMessage(sender, TextFormatting.RED, "You cannot rename this claim!");
                    }
                } else {
                    CommandSubClaimSetName.sendMessage(sender, TextFormatting.RED, "No claim there or you don't own the claim!");
                }
            } else {
                CommandSubClaimSetName.sendMessage(sender, TextFormatting.RED, "You must be a player to use this command!");
            }
        } else {
            throw new SyntaxErrorException("Specify a name with no spaces. Usage: " + this.func_71518_a(sender), new Object[0]);
        }
    }

    @Override
    public String getPermissionString() {
        return "claimit.claim.setname";
    }
}

