/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command.claimit.claim.permission;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import dev.itsmeow.claimit.api.claim.ClaimArea;
import dev.itsmeow.claimit.api.claim.ClaimManager;
import dev.itsmeow.claimit.api.group.Group;
import dev.itsmeow.claimit.api.group.GroupManager;
import dev.itsmeow.claimit.api.permission.ClaimPermissionMember;
import dev.itsmeow.claimit.api.permission.ClaimPermissionRegistry;
import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.util.command.CommandUtils;
import dev.itsmeow.claimit.util.text.FTC;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class CommandSubClaimPermissionList
extends CommandCIBase {
    public String func_71517_b() {
        return "list";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/claimit claim permission list [claimname]";
    }

    @Override
    public String getHelp(ICommandSender sender) {
        return "Lists member permissions within a claim. Argument one is optional claim name. Defaults to location.";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        ClaimManager m = ClaimManager.getManager();
        if (args.length == 0) {
            if (!(sender instanceof EntityPlayer)) throw new CommandException("Must specify name as non-player.", new Object[0]);
            ClaimArea claim = m.getClaimAtLocation(sender.func_130014_f_(), sender.func_180425_c());
            if (claim == null) throw new CommandException("There is no claim here! Specify a name. Usage: " + this.func_71518_a(sender), new Object[0]);
            CommandSubClaimPermissionList.outputMembers(claim, sender);
            return;
        } else {
            if (args.length != 1) throw new CommandException("Too many arguments! Usage: " + this.func_71518_a(sender), new Object[0]);
            ClaimArea claim = CommandUtils.getClaimWithName(args[0], sender);
            if (claim == null) throw new CommandException("There is no claim with this name" + (CommandUtils.isAdmin(sender) ? "!" : " that you own!"), new Object[0]);
            CommandSubClaimPermissionList.outputMembers(claim, sender);
        }
    }

    private static void outputMembers(ClaimArea claim, ICommandSender sender) throws CommandException {
        ImmutableSetMultimap permMap = claim.getMembers();
        ImmutableSet groups = GroupManager.getGroupsForClaim((ClaimArea)claim);
        if (!CommandUtils.isAdminWithNodeOrManage(sender, claim, "claimit.claim.permission.list.others")) {
            throw new CommandException("You cannot view the members of this claim!", new Object[0]);
        }
        if (permMap == null || permMap.isEmpty()) {
            CommandSubClaimPermissionList.sendMessage(sender, TextFormatting.RED, "This claim has no members.");
        } else {
            for (UUID uuid2 : permMap.keySet()) {
                CommandSubClaimPermissionList.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.YELLOW, CommandUtils.getNameForUUID(uuid2, sender.func_130014_f_().func_73046_m())), new FTC(TextFormatting.BLUE, " - "), new FTC(TextFormatting.GREEN, CommandSubClaimPermissionList.getMemberLine(uuid2, (Set<ClaimPermissionMember>)permMap.get((Object)uuid2)))});
            }
        }
        if (groups != null && groups.size() > 0) {
            for (Group group : groups) {
                SetMultimap singletonMap = MultimapBuilder.hashKeys().hashSetValues().build();
                singletonMap.putAll((Object)group.getOwner(), (Iterable)ClaimPermissionRegistry.getMemberPermissions());
                singletonMap.putAll((Multimap)group.getMembers());
                ImmutableSetMultimap groupPermMap = ImmutableSetMultimap.copyOf((Multimap)singletonMap);
                if (groupPermMap.size() > 0) {
                    CommandSubClaimPermissionList.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.YELLOW, FTC.Form.BOLD, "Members from: "), new FTC(TextFormatting.GREEN, group.getName())});
                    groupPermMap.keySet().forEach(uuid -> CommandSubClaimPermissionList.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.YELLOW, " -- " + CommandUtils.getNameForUUID(uuid, sender.func_130014_f_().func_73046_m())), new FTC(TextFormatting.BLUE, " - "), new FTC(TextFormatting.GREEN, CommandSubClaimPermissionList.getMemberLine(uuid, (Set<ClaimPermissionMember>)groupPermMap.get(uuid)))}));
                    continue;
                }
                CommandSubClaimPermissionList.sendMessage(sender, FTC.Form.BOLD, "This is a bad, bad bug. Report this. A group is marked for this claim, but it does contain any members");
            }
        } else {
            CommandSubClaimPermissionList.sendMessage(sender, TextFormatting.RED, "This claim has no group members.");
        }
    }

    private static String getMemberLine(UUID member, Set<ClaimPermissionMember> permSet) {
        String permString = "";
        for (ClaimPermissionMember p : permSet) {
            permString = permString + p.parsedName + TextFormatting.BLUE + ", " + TextFormatting.GREEN;
        }
        int end = permString.lastIndexOf(44);
        return permString.substring(0, end);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return CommandBase.func_175762_a((String[])args, CommandUtils.getOwnedClaimNames(null, sender));
        }
        return new ArrayList<String>();
    }

    @Override
    public String getPermissionString() {
        return "claimit.claim.permission.list";
    }
}

