/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command.claimit.claimblocks;

import dev.itsmeow.claimit.command.CommandCIBaseAdminOnly;
import dev.itsmeow.claimit.util.UserClaimBlocks;
import dev.itsmeow.claimit.util.command.CommandUtils;
import dev.itsmeow.claimit.util.text.FTC;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class CommandSubClaimBlocksAddAllowed
extends CommandCIBaseAdminOnly {
    public String func_71517_b() {
        return "addallowed";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/claimit claimblocks addallowed <player> <amount>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 2) {
            throw new CommandException("Invalid argument count! Usage: " + this.func_71518_a(sender), new Object[0]);
        }
        UUID uuid = CommandUtils.getUUIDForName(args[0], server);
        int oldAllowed = UserClaimBlocks.getClaimBlocksAllowed(uuid);
        int amount = CommandBase.func_175755_a((String)args[1]);
        if (UserClaimBlocks.getClaimBlocksRemaining(uuid) + amount < 0) {
            throw new CommandException("Adding this amount would make the remaining amount less than 0!", new Object[0]);
        }
        if (uuid == null) {
            throw new PlayerNotFoundException("Invalid player: " + args[0]);
        }
        UserClaimBlocks.setAllowedClaimBlocks(uuid, oldAllowed + amount);
        CommandSubClaimBlocksAddAllowed.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.GREEN, "Added " + amount + " to "), new FTC(TextFormatting.YELLOW, args[0]), new FTC(TextFormatting.GREEN, "'s allowed claim blocks. They are now allowed " + (oldAllowed + amount) + " claim blocks. They now have "), new FTC(TextFormatting.AQUA, UserClaimBlocks.getClaimBlocksRemaining(uuid) + ""), new FTC(TextFormatting.GREEN, " blocks remaining.")});
    }

    @Override
    public String getPermissionString() {
        return "claimit.claimblocks.addallowed";
    }

    @Override
    public String getAdminHelp(ICommandSender sender) {
        return "Adds to allowed claim blocks for a user. First argument name, second amount of blocks to add.";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return CommandBase.func_175762_a((String[])args, CommandUtils.getPossiblePlayers(null, server, sender, args));
        }
        return new ArrayList<String>();
    }
}

