/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command.claimit.group;

import dev.itsmeow.claimit.api.claim.ClaimArea;
import dev.itsmeow.claimit.api.group.Group;
import dev.itsmeow.claimit.api.group.GroupManager;
import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.util.command.CommandUtils;
import dev.itsmeow.claimit.util.text.FTC;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class CommandSubGroupClaim
extends CommandCIBase {
    public String func_71517_b() {
        return "claim";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/claimit group claim <add/remove> <groupname> [claimname]";
    }

    @Override
    public String getHelp(ICommandSender sender) {
        return "Adds a claim to a group. You must own the claim. First argument is add or remove, second is groupname. Third, optional, claim name. Otherwise uses location. Adding a claim gives members their group permissions in that claim.";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length > 3 || args.length < 2) {
            throw new WrongUsageException("Improper argument count! Usage: " + this.func_71518_a(sender), new Object[0]);
        }
        String action = args[0].toLowerCase();
        String groupName = args[1];
        String claimName = null;
        if (args.length == 3) {
            claimName = args[2];
        }
        if (!action.equalsIgnoreCase("add") && !action.equalsIgnoreCase("remove")) {
            throw new WrongUsageException("Invalid action! Specify add or remove. Usage: " + this.func_71518_a(sender), new Object[0]);
        }
        Group group = GroupManager.getGroup((String)groupName);
        if (group != null) {
            ClaimArea claim = CommandUtils.getClaimWithNameOrLocation(claimName, sender);
            if (claim != null) {
                if (action.equals("add")) {
                    if (!group.hasClaim(claim)) {
                        if (CommandUtils.isAdminWithNodeOrOwner(sender, claim, "claimit.claim.manage.others")) {
                            if (CommandUtils.isAdminNoded(sender, "claimit.command.claimit.group.claim.others") || sender instanceof EntityPlayer && (group.getMembers().containsKey((Object)((EntityPlayer)sender).func_146103_bH().getId()) || group.isOwner((EntityPlayer)sender))) {
                                group.addClaim(claim);
                                CommandSubGroupClaim.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.GREEN, "Successfully added claim "), new FTC(TextFormatting.YELLOW, claim.getDisplayedViewName()), new FTC(TextFormatting.GREEN, " to group "), new FTC(TextFormatting.DARK_GREEN, groupName)});
                                CommandSubGroupClaim.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.YELLOW, "Please make sure you trust " + CommandUtils.getNameForUUID(group.getOwner(), server) + " and the people they trust, as they will have full permission in this claim, as well as the ability to add more people!")});
                                return;
                            } else {
                                CommandSubGroupClaim.sendMessage(sender, TextFormatting.RED, "You cannot add claims to a group you are not a member of!");
                            }
                            return;
                        } else {
                            CommandSubGroupClaim.sendMessage(sender, TextFormatting.RED, "You do not own this claim!");
                        }
                        return;
                    } else {
                        CommandSubGroupClaim.sendMessage(sender, TextFormatting.YELLOW, "This claim is already present!");
                    }
                    return;
                } else {
                    if (!action.equals("remove")) throw new WrongUsageException("Invalid action! Specify add or remove. Usage: " + this.func_71518_a(sender), new Object[0]);
                    if (group.hasClaim(claim)) {
                        if (CommandUtils.isAdminWithNodeOrOwner(sender, claim, "claimit.command.claimit.group.claim.others")) {
                            group.removeClaim(claim);
                            CommandSubGroupClaim.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.GREEN, "Successfully removed claim "), new FTC(TextFormatting.YELLOW, claim.getDisplayedViewName()), new FTC(TextFormatting.GREEN, " from group "), new FTC(TextFormatting.DARK_GREEN, groupName)});
                            return;
                        } else {
                            CommandSubGroupClaim.sendMessage(sender, TextFormatting.RED, "You do not own this claim!");
                        }
                        return;
                    } else {
                        CommandSubGroupClaim.sendMessage(sender, TextFormatting.YELLOW, "This claim is not in this group!");
                    }
                }
                return;
            } else {
                CommandSubGroupClaim.sendMessage(sender, TextFormatting.RED, "No claim " + (args.length == 3 ? "with this name that you own found!" : "at your location!"));
            }
            return;
        } else {
            CommandSubGroupClaim.sendMessage(sender, TextFormatting.RED, "No such group: " + groupName);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"add", "remove"});
        }
        if (args.length == 2) {
            return CommandBase.func_175762_a((String[])args, CommandUtils.getRelevantGroupNames(sender));
        }
        if (args.length == 3) {
            return CommandBase.func_175762_a((String[])args, CommandUtils.getOwnedClaimNames(null, sender));
        }
        return new ArrayList<String>();
    }

    @Override
    public String getPermissionString() {
        return "claimit.group.claim";
    }
}

