/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command.claimit.group;

import dev.itsmeow.claimit.api.group.Group;
import dev.itsmeow.claimit.api.group.GroupManager;
import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.util.command.CommandUtils;
import dev.itsmeow.claimit.util.text.FTC;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.SyntaxErrorException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class CommandSubGroupDelete
extends CommandCIBase {
    public String func_71517_b() {
        return "delete";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/claimit group delete <groupname>";
    }

    @Override
    public String getHelp(ICommandSender sender) {
        return "Deletes a group. Removes all member's permissions within claims in the group.";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 1) {
            String groupname = args[0];
            Group group = GroupManager.getGroup((String)groupname);
            if (group != null) {
                if (CommandUtils.isAdminNoded(sender, "claimit.command.claimit.group.delete.others") || sender instanceof EntityPlayer && group.isOwner((EntityPlayer)sender)) {
                    GroupManager.removeGroup((Group)group);
                    CommandSubGroupDelete.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.AQUA, "Deleted group: "), new FTC(TextFormatting.GREEN, groupname)});
                } else {
                    CommandSubGroupDelete.sendMessage(sender, TextFormatting.RED, "You do not own this group!");
                }
            } else {
                CommandSubGroupDelete.sendMessage(sender, TextFormatting.RED, "No such group: " + groupname);
            }
        } else {
            throw new SyntaxErrorException("Invalid syntax. Usage: " + this.func_71518_a(sender), new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return CommandBase.func_175762_a((String[])args, CommandUtils.getRelevantGroupNames(sender));
        }
        return new ArrayList<String>();
    }

    @Override
    public String getPermissionString() {
        return "claimit.group.delete";
    }
}

