/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command.claimit.group;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import dev.itsmeow.claimit.api.claim.ClaimArea;
import dev.itsmeow.claimit.api.group.Group;
import dev.itsmeow.claimit.api.group.GroupManager;
import dev.itsmeow.claimit.api.permission.ClaimPermissionMember;
import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.util.command.CommandUtils;
import dev.itsmeow.claimit.util.text.ColorUtil;
import dev.itsmeow.claimit.util.text.FTC;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class CommandSubGroupInfo
extends CommandCIBase {
    public String func_71517_b() {
        return "info";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/claimit group info <groupname>";
    }

    @Override
    public String getHelp(ICommandSender sender) {
        return "Provides information on a group. First argument is group name.";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 1) {
            CommandSubGroupInfo.sendMessage(sender, TextFormatting.RED, "Invalid argument count. Specify a group name. Usage: " + this.func_71518_a(sender));
        }
        if (args.length == 1 && sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            Group group = GroupManager.getGroup((String)args[0]);
            if (group != null) {
                CommandSubGroupInfo.outputGroupInfo(group, player);
            } else {
                CommandSubGroupInfo.sendMessage(sender, TextFormatting.RED, "No group with this name!");
            }
        }
    }

    private static void outputGroupInfo(Group group, EntityPlayer player) throws CommandException {
        World world = player.func_130014_f_();
        String ownerName = CommandUtils.getNameForUUID(group.getOwner(), world.func_73046_m());
        CommandSubGroupInfo.sendMessage((ICommandSender)player, new ITextComponent[]{new FTC(TextFormatting.BLUE, FTC.Form.BOLD, "Information for group owned by "), new FTC(TextFormatting.GREEN, FTC.Form.BOLD, ownerName), new FTC(TextFormatting.BLUE, FTC.Form.BOLD, ":")});
        CommandSubGroupInfo.sendMessage((ICommandSender)player, new ITextComponent[]{new FTC(TextFormatting.BLUE, "Group Name: "), new FTC(TextFormatting.DARK_GREEN, group.getName())});
        CommandSubGroupInfo.sendMessage((ICommandSender)player, new ITextComponent[]{new FTC(TextFormatting.BLUE, "Group Tag: "), ColorUtil.getGroupTagComponent(group)});
        ImmutableSetMultimap permMap = group.getMembers();
        if (permMap == null || permMap.isEmpty()) {
            CommandSubGroupInfo.sendMessage((ICommandSender)player, TextFormatting.YELLOW, "No members.");
        } else {
            CommandSubGroupInfo.sendMessage((ICommandSender)player, TextFormatting.YELLOW, FTC.Form.BOLD, "Members:");
            for (UUID member : permMap.keySet()) {
                String permString = "";
                ImmutableSet permSet = permMap.get((Object)member);
                for (ClaimPermissionMember p : permSet) {
                    permString = permString + p.parsedName + ", ";
                }
                int end = permString.lastIndexOf(44);
                permString = permString.substring(0, end);
                CommandSubGroupInfo.sendMessage((ICommandSender)player, new ITextComponent[]{new FTC(TextFormatting.YELLOW, CommandUtils.getNameForUUID(member, player.func_130014_f_().func_73046_m())), new FTC(TextFormatting.BLUE, ": "), new FTC(TextFormatting.GREEN, permString)});
            }
        }
        if (group.getClaims().size() == 0 || group.getClaims().isEmpty()) {
            CommandSubGroupInfo.sendMessage((ICommandSender)player, TextFormatting.YELLOW, "No claims.");
        } else {
            CommandSubGroupInfo.sendMessage((ICommandSender)player, TextFormatting.YELLOW, FTC.Form.BOLD, "Claims:");
            for (ClaimArea claim : group.getClaims()) {
                CommandSubGroupInfo.sendMessage((ICommandSender)player, new ITextComponent[]{new FTC(TextFormatting.BLUE, " + "), new FTC(TextFormatting.YELLOW, claim.getDisplayedViewName()), new FTC(TextFormatting.BLUE, " of "), new FTC(TextFormatting.GREEN, CommandUtils.getNameForUUID(claim.getOwner(), world.func_73046_m()))});
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return CommandBase.func_175762_a((String[])args, CommandUtils.getRelevantGroupNames(sender));
        }
        return new ArrayList<String>();
    }

    @Override
    public String getPermissionString() {
        return "claimit.group.info";
    }
}

