/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command.claimit.group;

import dev.itsmeow.claimit.api.group.Group;
import dev.itsmeow.claimit.api.group.GroupManager;
import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.util.command.CommandUtils;
import dev.itsmeow.claimit.util.text.CommandChatStyle;
import dev.itsmeow.claimit.util.text.FTC;
import dev.itsmeow.claimit.util.text.TextComponentStyled;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class CommandSubGroupList
extends CommandCIBase {
    @Override
    public String getHelp(ICommandSender sender) {
        return CommandUtils.isAdminNoded(sender, "claimit.command.group.list.others") ? "Lists all groups on the server. Optional username argument." : "Lists all groups you are in. Takes no arguments.";
    }

    public String func_71517_b() {
        return "list";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/claimit group list" + (CommandUtils.isAdminNoded(sender, "claimit.command.claimit.group.list.others") ? " [username]" : "");
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        boolean admin = CommandUtils.isAdminNoded(sender, "claimit.command.claimit.group.list.others");
        if (args.length > 0 && !admin) {
            throw new CommandException("Invalid argument count! Usage: " + this.func_71518_a(sender), new Object[0]);
        }
        String name = null;
        if (args.length == 1 && admin) {
            name = args[0];
        }
        if (!admin && name == null) {
            name = sender.func_70005_c_();
        }
        UUID uuid = CommandUtils.getUUIDForName(name, server);
        Group[] groups = (Group[])GroupManager.getGroups().stream().filter(g -> admin && uuid == null || uuid != null && (g.getMembers().keySet().contains((Object)uuid) || g.isOwner(uuid))).toArray(Group[]::new);
        if (groups.length > 0) {
            CommandSubGroupList.sendMessage(sender, TextFormatting.DARK_BLUE, FTC.Form.BOLD, "Group List:");
            for (Group group : groups) {
                sender.func_145747_a((ITextComponent)new TextComponentStyled(TextFormatting.BLUE + "Group: " + TextFormatting.DARK_GREEN + group.getName(), new CommandChatStyle("/ci group info " + group.getName(), true, "Click for info")));
            }
        } else {
            CommandSubGroupList.sendMessage(sender, TextFormatting.RED, "No groups found!");
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (CommandUtils.isAdmin(sender)) {
            return CommandUtils.getPossiblePlayers(null, server, sender, args);
        }
        return new ArrayList<String>();
    }

    @Override
    public String getPermissionString() {
        return "claimit.group.list";
    }
}

