/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command.claimit.group;

import dev.itsmeow.claimit.api.group.Group;
import dev.itsmeow.claimit.api.group.GroupManager;
import dev.itsmeow.claimit.api.permission.ClaimPermissionMember;
import dev.itsmeow.claimit.api.permission.ClaimPermissionRegistry;
import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.util.command.CommandUtils;
import dev.itsmeow.claimit.util.text.FTC;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class CommandSubGroupPermission
extends CommandCIBase {
    public String func_71517_b() {
        return "permission";
    }

    public List<String> func_71514_a() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("perm");
        list.add("player");
        return list;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/claimit group permission <add/remove> <permission> <username> <groupname>";
    }

    @Override
    public String getHelp(ICommandSender sender) {
        return "Adds or removes a permission from a member within the group, and by extension their permissions in the group's claims. First argument is add or remove. Second argument is a member permission. Third argument is username. Fourth argument is group name.";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 4) {
            throw new WrongUsageException("Improper argument count! Usage: " + this.func_71518_a(sender), new Object[0]);
        }
        String action = args[0].toLowerCase();
        String permissionStr = args[1];
        String username = args[2];
        String groupname = args[3];
        if (!action.equalsIgnoreCase("add") && !action.equalsIgnoreCase("remove")) {
            throw new WrongUsageException("Invalid action! Specify add or remove. Usage: " + this.func_71518_a(sender), new Object[0]);
        }
        Set<ClaimPermissionMember> permissions = CommandUtils.getMemberPermissionsForArgument((Set<ClaimPermissionMember>)ClaimPermissionRegistry.getMemberPermissions(), this.func_71518_a(sender), permissionStr, sender, server);
        Group group = GroupManager.getGroup((String)groupname);
        if (group != null) {
            if (CommandUtils.isAdminNoded(sender, "claimit.command.claimit.group.permission.others") || sender instanceof EntityPlayer && group.isOwner((EntityPlayer)sender)) {
                Object wildcard = group.getMembers().keySet();
                wildcard = new HashSet(wildcard);
                wildcard.remove(group.getOwner());
                Set<UUID> ids = CommandUtils.getUUIDsForArgument((Set<UUID>)wildcard, username, sender, server);
                if (ids.size() == 0) {
                    CommandSubGroupPermission.sendMessage(sender, TextFormatting.RED, "No members to " + action.toLowerCase() + "!");
                }
                for (UUID id : ids) {
                    username = CommandUtils.getNameForUUID(id, server);
                    if (action.equals("add")) {
                        for (ClaimPermissionMember permission : permissions) {
                            if (!group.isOwner(id)) {
                                if (!group.inPermissionList(permission, id)) {
                                    group.addMember(id, permission);
                                    CommandSubGroupPermission.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.GREEN, "Successfully added "), new FTC(TextFormatting.YELLOW, username), new FTC(TextFormatting.GREEN, " to group "), new FTC(TextFormatting.DARK_GREEN, groupname), new FTC(TextFormatting.GREEN, " with permission "), new FTC(TextFormatting.AQUA, permission.parsedName)});
                                    continue;
                                }
                                if (permissions.size() != 1) continue;
                                CommandSubGroupPermission.sendMessage(sender, TextFormatting.YELLOW, "This player already has that permission!");
                                continue;
                            }
                            CommandSubGroupPermission.sendMessage(sender, TextFormatting.YELLOW, "Cannot add owner as member!");
                        }
                        continue;
                    }
                    if (action.equals("remove")) {
                        for (ClaimPermissionMember permission : permissions) {
                            if (!group.isOwner(id)) {
                                if (group.inPermissionList(permission, id)) {
                                    group.removeMember(id, permission);
                                    CommandSubGroupPermission.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.GREEN, "Successfully removed permission "), new FTC(TextFormatting.AQUA, permission.parsedName), new FTC(TextFormatting.GREEN, " from user "), new FTC(TextFormatting.YELLOW, username), new FTC(TextFormatting.GREEN, " in group "), new FTC(TextFormatting.DARK_GREEN, groupname)});
                                    continue;
                                }
                                if (permissions.size() != 1) continue;
                                CommandSubGroupPermission.sendMessage(sender, TextFormatting.YELLOW, "This player does not have that permission!");
                                continue;
                            }
                            CommandSubGroupPermission.sendMessage(sender, TextFormatting.YELLOW, "Cannot add owner as member!");
                        }
                        continue;
                    }
                    throw new WrongUsageException("Invalid action! Specify add or remove. Usage: " + this.func_71518_a(sender), new Object[0]);
                }
            } else {
                CommandSubGroupPermission.sendMessage(sender, TextFormatting.RED, "You do not own this group!");
            }
        } else {
            CommandSubGroupPermission.sendMessage(sender, TextFormatting.RED, "No such group: " + groupname);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"add", "remove"});
        }
        if (args.length == 2) {
            return CommandBase.func_175762_a((String[])args, CommandUtils.getMemberPermissionsAndWildcard(list));
        }
        if (args.length == 3) {
            return CommandBase.func_175762_a((String[])args, CommandUtils.getPossiblePlayers(list, server, sender, args));
        }
        if (args.length == 4) {
            return CommandBase.func_175762_a((String[])args, CommandUtils.getRelevantGroupNames(sender));
        }
        return list;
    }

    @Override
    public String getPermissionString() {
        return "claimit.group.permission";
    }
}

