/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command.claimit.group;

import dev.itsmeow.claimit.api.group.Group;
import dev.itsmeow.claimit.api.group.GroupManager;
import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.util.command.CommandUtils;
import dev.itsmeow.claimit.util.text.FTC;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.SyntaxErrorException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class CommandSubGroupSetName
extends CommandCIBase {
    public String func_71517_b() {
        return "setname";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/claimit group setname <groupname> <newname>";
    }

    @Override
    public String getHelp(ICommandSender sender) {
        return "Renames or sets the name of a group from its old name. Only group owner may rename. First argument is the group's current name. Second argument is the new name.";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 2) {
            String groupname = args[0];
            String name = args[1];
            Group group = GroupManager.getGroup((String)groupname);
            if (group != null) {
                if (CommandUtils.isAdminNoded(sender, "claimit.command.claimit.group.setname.others") || sender instanceof EntityPlayer && group.isOwner((EntityPlayer)sender)) {
                    boolean pass = GroupManager.renameGroup((String)groupname, (String)name);
                    if (pass) {
                        CommandSubGroupSetName.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.AQUA, "Set this group's name to: "), new FTC(TextFormatting.GREEN, group.getName())});
                    } else {
                        CommandSubGroupSetName.sendMessage(sender, TextFormatting.RED, "Failed to set name. There is another group with this name.");
                    }
                } else {
                    CommandSubGroupSetName.sendMessage(sender, TextFormatting.RED, "You do not own this group!");
                }
            } else {
                CommandSubGroupSetName.sendMessage(sender, TextFormatting.RED, "There is no group with this name!");
            }
        } else {
            throw new SyntaxErrorException("Invalid syntax. Usage: " + this.func_71518_a(sender), new Object[0]);
        }
    }

    @Override
    public String getPermissionString() {
        return "claimit.group.setname";
    }
}

