/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command.claimit.group;

import dev.itsmeow.claimit.api.group.Group;
import dev.itsmeow.claimit.api.group.GroupManager;
import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.serialization.ClaimItGlobalDataSerializer;
import java.util.UUID;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.SyntaxErrorException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextFormatting;

public class CommandSubGroupSetPrimary
extends CommandCIBase {
    public String func_71517_b() {
        return "setprimary";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/claimit group setprimary <groupname>";
    }

    @Override
    public String getHelp(ICommandSender sender) {
        return "Sets a primary group. This group determines your tag.";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 1) {
            if (!(sender instanceof EntityPlayer)) {
                throw new CommandException("You must be a player to set a primary group!", new Object[0]);
            }
            Group group = GroupManager.getGroup((String)args[0]);
            if (group != null) {
                UUID uuid = ((EntityPlayer)sender).func_146103_bH().getId();
                if (group.getMembers().keySet().contains((Object)uuid) || group.isOwner(uuid)) {
                    NBTTagCompound data = ClaimItGlobalDataSerializer.get().data;
                    NBTTagCompound tag = !data.func_150297_b("PRIMARY_GROUPS", 10) ? new NBTTagCompound() : data.func_74775_l("PRIMARY_GROUPS");
                    tag.func_74778_a(uuid.toString(), group.getName());
                    data.func_74782_a("PRIMARY_GROUPS", (NBTBase)tag);
                    CommandSubGroupSetPrimary.sendMessage(sender, TextFormatting.GREEN, "Set primary group to: " + TextFormatting.YELLOW + group.getName());
                } else {
                    CommandSubGroupSetPrimary.sendMessage(sender, TextFormatting.RED, "You are not part of this group!");
                }
            } else {
                CommandSubGroupSetPrimary.sendMessage(sender, TextFormatting.RED, "There is no group with this name!");
            }
        } else {
            throw new SyntaxErrorException("Invalid syntax. Usage: " + this.func_71518_a(sender), new Object[0]);
        }
    }

    @Override
    public String getPermissionString() {
        return "claimit.group.settag";
    }
}

