/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command.claimit.help;

import dev.itsmeow.claimit.api.permission.ClaimPermissionMember;
import dev.itsmeow.claimit.api.permission.ClaimPermissionRegistry;
import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.util.text.CommandChatStyle;
import dev.itsmeow.claimit.util.text.FTC;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class CommandSubHelpPermission
extends CommandCIBase {
    @Override
    public String getHelp(ICommandSender sender) {
        return "Base help command for permissions (member and toggle). Really, stop asking for help on help. Just follow the instructions.";
    }

    public String func_71517_b() {
        return "permission";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/claimit help permission <member/toggle> [permission name]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            CommandSubHelpPermission.sendMessage(sender, new ITextComponent[]{new FTC("Available choices: ", TextFormatting.GOLD, FTC.Form.UNDERLINE), new FTC("/claimit help permission <choice>", TextFormatting.YELLOW)});
            CommandSubHelpPermission.sendSMessage(sender, TextFormatting.GREEN + "member", new CommandChatStyle("/claimit help permission member", true, "Click for option"));
            CommandSubHelpPermission.sendSMessage(sender, TextFormatting.GREEN + "toggle", new CommandChatStyle("/claimit help permission toggle", true, "Click for option"));
            return;
        } else {
            ClaimPermissionMember perm;
            if ((args.length < 1 || !args[0].equalsIgnoreCase("member")) && !args[0].equalsIgnoreCase("toggle")) throw new CommandException("Invalid type! Specify member or toggle. Usage: " + this.func_71518_a(sender), new Object[0]);
            if (args[0].equalsIgnoreCase("member")) {
                if (args.length == 1) {
                    CommandSubHelpPermission.sendMessage(sender, new ITextComponent[]{new FTC("Member Permissions:", TextFormatting.GOLD, FTC.Form.UNDERLINE)});
                    for (ClaimPermissionMember perm2 : ClaimPermissionRegistry.getMemberPermissions()) {
                        CommandSubHelpPermission.sendMessage(sender, new ITextComponent[]{new FTC(perm2.parsedName + ": ", TextFormatting.GREEN), new FTC(perm2.helpInfo, TextFormatting.YELLOW)});
                    }
                } else {
                    if (args.length != 2) throw new CommandException("Too many arguments! Usage: " + this.func_71518_a(sender), new Object[0]);
                    perm = ClaimPermissionRegistry.getPermissionMember((String)args[1]);
                    if (perm == null) throw new CommandException("No such permission \"" + args[1] + "\"", new Object[0]);
                    CommandSubHelpPermission.sendMessage(sender, new ITextComponent[]{new FTC(perm.parsedName + ": ", TextFormatting.GREEN), new FTC(perm.helpInfo, TextFormatting.YELLOW)});
                }
            }
            if (!args[0].equalsIgnoreCase("toggle")) return;
            if (args.length == 1) {
                CommandSubHelpPermission.sendMessage(sender, new ITextComponent[]{new FTC("Toggle Permissions:", TextFormatting.GOLD, FTC.Form.UNDERLINE)});
                for (ClaimPermissionMember perm2 : ClaimPermissionRegistry.getTogglePermissions()) {
                    CommandSubHelpPermission.sendMessage(sender, new ITextComponent[]{new FTC(perm2.parsedName + ": ", TextFormatting.GREEN), new FTC(perm2.helpInfo, TextFormatting.YELLOW), new FTC(" (Default: " + perm2.getDefault() + ")", TextFormatting.BLUE)});
                }
                return;
            } else {
                if (args.length != 2) throw new CommandException("Too many arguments! Usage: " + this.func_71518_a(sender), new Object[0]);
                perm = ClaimPermissionRegistry.getPermissionToggle((String)args[1]);
                if (perm == null) throw new CommandException("No such permission \"" + args[1] + "\"", new Object[0]);
                CommandSubHelpPermission.sendMessage(sender, new ITextComponent[]{new FTC(perm.parsedName + ": ", TextFormatting.GREEN), new FTC(perm.helpInfo, TextFormatting.YELLOW)});
            }
        }
    }

    @Override
    public String getPermissionString() {
        return "claimit.help.permission";
    }
}

