/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command.claimit.help;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.util.text.CommandChatStyle;
import dev.itsmeow.claimit.util.text.FTC;
import java.util.List;
import java.util.Set;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class CommandSubHelpTopic
extends CommandCIBase {
    @Override
    public String getHelp(ICommandSender sender) {
        return "Gives information on various topics. Running with no args will give choices.";
    }

    public String func_71517_b() {
        return "topic";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/claimit help topic <topic>";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            CommandSubHelpTopic.sendMessage(sender, new ITextComponent[]{new FTC("Available choices:", TextFormatting.GOLD, FTC.Form.UNDERLINE), new FTC(" /claimit help topic <choice>", TextFormatting.YELLOW, FTC.Form.UNDERLINE)});
            for (String topic : TopicHelpRegistry.getTopics()) {
                CommandSubHelpTopic.sendSMessage(sender, topic, new CommandChatStyle("/claimit help topic " + topic, true, "Click to view info").func_150238_a(TextFormatting.YELLOW));
            }
            return;
        } else {
            if (args.length != 1) throw new CommandException("Too many arguments! Usage: " + this.func_71518_a(sender), new Object[0]);
            String topicName = args[0];
            if (TopicHelpRegistry.getInfo(topicName).size() <= 0) throw new CommandException("No such topic!", new Object[0]);
            CommandSubHelpTopic.sendMessage(sender, new ITextComponent[]{new FTC("Info for " + topicName, TextFormatting.GOLD, FTC.Form.UNDERLINE)});
            for (FTC[] line : TopicHelpRegistry.getInfo(topicName)) {
                CommandSubHelpTopic.sendMessage(sender, (ITextComponent[])line);
            }
        }
    }

    @Override
    public String getPermissionString() {
        return "claimit.help.topic";
    }

    static {
        TopicHelpRegistry.add("userconfigs", {new FTC("User configs are configurable named values that are saved per-player. They can control anything and everything. They have types (boolean, number, string, etc).", TextFormatting.YELLOW)}, {new FTC("For more information: ", TextFormatting.YELLOW), new FTC("/claimit help userconfig", TextFormatting.GREEN)});
        TopicHelpRegistry.add("memberperms", {new FTC("Member permissions are a subclass of permission that can be assigned to a player in a group or claim. Different member perms grant different permissions and abilities.", TextFormatting.YELLOW)}, {new FTC("For more information: ", TextFormatting.YELLOW), new FTC("/claimit help permission member", TextFormatting.GREEN)});
        TopicHelpRegistry.add("toggleperms", {new FTC("Toggle permissions are a subclass of permission that can be enabled or disabled per claim, and are stored per claim. There can also be toggle perms sharing names with member perms.", TextFormatting.YELLOW)}, {new FTC("Toggling these on makes that member permission publicly available. E.g. toggling the modify toggle will allow anyone to place things.", TextFormatting.YELLOW)}, {new FTC("For more information: ", TextFormatting.YELLOW), new FTC("/claimit help permission toggle", TextFormatting.GREEN)});
        TopicHelpRegistry.add("claiming", {new FTC("Claiming is a fairly simple process.", TextFormatting.YELLOW)}, {new FTC("First, retrieve shears or whatever the server has configured to be the claim tool", TextFormatting.YELLOW)}, {new FTC("Next, put it in your hand and find the two corners between which you want to claim.", TextFormatting.YELLOW)}, {new FTC("Now, right click the block at your first corner. If the first corner works it should say so in chat.", TextFormatting.YELLOW)}, {new FTC("Finally, right click the second corner. If you were allowed to make a claim and it was not overlapping, then it should say the claim was created!", TextFormatting.YELLOW)}, {new FTC("Use '", TextFormatting.YELLOW), new FTC("/claimit claim info", TextFormatting.GREEN), new FTC("' for more info! You can set your claim name with '", TextFormatting.YELLOW), new FTC("/ci claim setname <name>", TextFormatting.GREEN), new FTC("' while standing in your claim", TextFormatting.YELLOW)});
        TopicHelpRegistry.add("permissions", {new FTC("You've heard what the permissions are, (", TextFormatting.YELLOW), new FTC("/claimit help permission", TextFormatting.GREEN), new FTC("), and what they do (see memberperms and toggleperms topics!), but how do I let my friends place things and open doors?", TextFormatting.YELLOW)}, {new FTC("Well, you've come to the right place!", TextFormatting.YELLOW)}, {new FTC("The first thing to do is identify the name of or move to the claim you wish to add a user to.", TextFormatting.YELLOW)}, {new FTC("Now, identify what permissions you want to add (modify for place/break, entity for livestock and mobs, use for doors and chests)", TextFormatting.YELLOW)}, {new FTC("Finally, mix all this info together and run a command (hint: hit tab for autocomplete): ", TextFormatting.YELLOW), new FTC("/claimit claim permission add <permission> <playername> [claimname]", TextFormatting.GREEN)}, {new FTC("Now your friends should have permissions! You can use the same command but with 'remove' instead of 'add' to remove troublemakers.", TextFormatting.YELLOW)});
        TopicHelpRegistry.add("groups", {new FTC("Do you have a lot of friends? Tired of spamming the add command? Want people to be able to add others while gone?", TextFormatting.YELLOW)}, {new FTC("Even if you haven't got a ton a friends, I've got the thing for you! Groups! With groups you can manage a user's permissions in multiple claims as well as share claims via groups.", TextFormatting.YELLOW)}, {new FTC("The idea is you add members to a group first. Give them member permissions that you want them to have in ALL claims that are eventually added to the group.", TextFormatting.YELLOW)}, {new FTC("Now that you have your members, add a claim to the group. This will give members their permissions in this claim. Keep in mind those with manage_perms will be able to meddle with claims, so be careful.", TextFormatting.YELLOW)}, {new FTC("Also, you have to directly own a claim to add it to a group, since the owner automatically gets all permissions. Claims can be removed by the owner at any time.", TextFormatting.YELLOW)});
    }

    public static class TopicHelpRegistry {
        private static final ListMultimap<String, FTC[]> lines = MultimapBuilder.hashKeys().arrayListValues().build();

        public static void add(String topicName, FTC[] ... infoLines) {
            lines.removeAll((Object)topicName);
            for (FTC[] str : infoLines) {
                lines.put((Object)topicName, (Object)str);
            }
        }

        public static List<FTC[]> getInfo(String topicName) {
            return lines.get((Object)topicName);
        }

        public static Set<String> getTopics() {
            return lines.keySet();
        }
    }
}

