/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command.claimit.help;

import dev.itsmeow.claimit.api.userconfig.UserConfigType;
import dev.itsmeow.claimit.api.userconfig.UserConfigTypeRegistry;
import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.util.text.FTC;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class CommandSubHelpUserConfig
extends CommandCIBase {
    @Override
    public String getHelp(ICommandSender sender) {
        return "Gives information on registered user configs.";
    }

    public String func_71517_b() {
        return "userconfig";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/claimit help userconfig [configname]";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            CommandSubHelpUserConfig.sendMessage(sender, TextFormatting.GOLD, FTC.Form.UNDERLINE, "User Configs:");
            for (Class clazz : UserConfigTypeRegistry.getRegistries().keySet()) {
                UserConfigType type = (UserConfigType)UserConfigTypeRegistry.getRegistries().get((Object)clazz);
                for (UserConfigType.UserConfig config : type.getConfigs().values()) {
                    CommandSubHelpUserConfig.sendMessage(sender, new ITextComponent[]{new FTC(config.parsedName, TextFormatting.GREEN), new FTC(" - (Default " + config.defaultValue.toString() + ") - ", TextFormatting.BLUE), new FTC(config.helpInfo, TextFormatting.YELLOW)});
                }
            }
        } else if (args.length == 1) {
            String cfgName = args[0];
            boolean hit = false;
            for (Class clazz : UserConfigTypeRegistry.getRegistries().keySet()) {
                UserConfigType type = (UserConfigType)UserConfigTypeRegistry.getRegistries().get((Object)clazz);
                UserConfigType.UserConfig config = type.getConfig(cfgName);
                if (config == null) continue;
                CommandSubHelpUserConfig.sendMessage(sender, new ITextComponent[]{new FTC(config.parsedName, TextFormatting.GREEN), new FTC(" - (Default " + config.defaultValue.toString() + ") - ", TextFormatting.BLUE), new FTC(config.helpInfo, TextFormatting.YELLOW)});
                hit = true;
            }
            if (!hit) {
                throw new CommandException("No config with that name found!", new Object[0]);
            }
        } else {
            throw new CommandException("Too many arguments! Usage: " + this.func_71518_a(sender), new Object[0]);
        }
    }

    @Override
    public String getPermissionString() {
        return "claimit.help.userconfig";
    }
}

