/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command.claimit.subclaim;

import dev.itsmeow.claimit.api.claim.ClaimArea;
import dev.itsmeow.claimit.api.claim.ClaimManager;
import dev.itsmeow.claimit.api.claim.SubClaimArea;
import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.util.command.CommandUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class CommandSubSubClaimDelete
extends CommandCIBase {
    public String func_71517_b() {
        return "delete";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/claimit subclaim delete [claimname) (subclaimname]";
    }

    @Override
    public String getHelp(ICommandSender sender) {
        return "Deletes a subclaim. With no arguments, attempts subclaim at your location. Specify a subclaim name as an argument to delete that subclaim within current claim. Specify both to delete in another claim" + (CommandUtils.isAdmin(sender) ? "Admins must specify a true claim name if using arguments." : "");
    }

    @Override
    public String getPermissionString() {
        return "claimit.subclaim.delete";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        SubClaimArea subClaim = CommandUtils.getSubClaimWithNamesOrLocation(0, args, sender);
        ClaimArea claim = subClaim.getParent();
        if (!CommandUtils.isAdminWithNodeOrManage(sender, claim, "claimit.command.claimit.subclaim.delete.others")) {
            throw new CommandException("You do not have permission to delete this subclaim!", new Object[0]);
        }
        boolean success = claim.removeSubClaim(subClaim);
        CommandSubSubClaimDelete.sendMessage(sender, TextFormatting.YELLOW, success ? "Subclaim deleted." : "Subclaim was not deleted, something canceled it.");
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            if (!ClaimManager.getManager().isBlockInAnyClaim(sender.func_130014_f_(), sender.func_180425_c())) {
                return CommandBase.func_175762_a((String[])args, CommandUtils.getOwnedClaimNames(null, sender));
            }
            return CommandBase.func_175762_a((String[])args, CommandUtils.getSubclaimNames(null, sender, ClaimManager.getManager().getClaimAtLocation(sender.func_130014_f_(), sender.func_180425_c())));
        }
        if (args.length == 2) {
            ClaimArea claim = CommandUtils.getClaimWithName(args[0], sender);
            if (claim != null) {
                return CommandBase.func_175762_a((String[])args, CommandUtils.getSubclaimNames(null, sender, claim));
            }
            return new ArrayList<String>();
        }
        return new ArrayList<String>();
    }
}

