/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command.claimit.subclaim;

import com.google.common.collect.ImmutableSet;
import dev.itsmeow.claimit.api.claim.ClaimArea;
import dev.itsmeow.claimit.api.claim.ClaimManager;
import dev.itsmeow.claimit.api.claim.SubClaimArea;
import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.util.command.CommandUtils;
import dev.itsmeow.claimit.util.command.ConfirmationManager;
import dev.itsmeow.claimit.util.command.IConfirmable;
import dev.itsmeow.claimit.util.text.FTC;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class CommandSubSubClaimDeleteAll
extends CommandCIBase
implements IConfirmable {
    public String func_71517_b() {
        return "deleteall";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/claimit subclaim deleteall [claimname]";
    }

    @Override
    public String getHelp(ICommandSender sender) {
        return "Deletes all subclaims in specified claim. Must be confirmed via '/claimit confirm'. Can be canceled via '/claimit cancel'";
    }

    @Override
    public String getPermissionString() {
        return "claimit.subclaim.deleteall";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String claimname = null;
        if (args.length == 1) {
            claimname = args[0];
        } else if (args.length > 1) {
            throw new CommandException("Too many arguments! Usage: " + this.func_71518_a(sender), new Object[0]);
        }
        ClaimArea claim = CommandUtils.getClaimWithNameOrLocation(claimname, sender);
        if (claim == null) throw new CommandException("Could not get claim!", new Object[0]);
        if (!CommandUtils.isAdminWithNodeOrOwner(sender, claim, "claimit.command.claimit.subclaim.deleteall.others")) throw new CommandException("You do not have permission to delete this claim's subclaims!", new Object[0]);
        if (!ConfirmationManager.getManager().needsConfirm(sender)) {
            ConfirmationManager.getManager().addConfirm(sender, this, new String[]{claim.getTrueViewName()});
            CommandSubSubClaimDeleteAll.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.DARK_RED, "This will delete ALL subclaims in this claim! Are you sure you want to do this? Run "), new FTC(TextFormatting.AQUA, "'/claimit confirm'"), new FTC(TextFormatting.DARK_RED, " to confirm. If you do not want to do this, run "), new FTC(TextFormatting.AQUA, "'/claimit cancel'"), new FTC(TextFormatting.DARK_RED, ".")});
            return;
        } else {
            CommandSubSubClaimDeleteAll.sendMessage(sender, TextFormatting.RED, "Canceling preexisting action. Run this command again to delete all subclaims.");
            ConfirmationManager.getManager().removeConfirm(sender);
        }
    }

    @Override
    public String getConfirmName() {
        return "subclaim-deleteall";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doAction(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        boolean failed;
        if (args.length != 1) throw new RuntimeException("A subclaim deletion was confirmed, but no claim was supplied! What did you do!?!?");
        String claimName = args[0];
        ClaimArea claim = ClaimManager.getManager().getClaimByTrueName(claimName);
        if (claim != null) {
            if (!CommandUtils.isAdminWithNodeOrOwner(sender, claim, "claimit.command.claimit.subclaim.deleteall.others")) {
                ConfirmationManager.getManager().removeConfirm(sender);
                throw new CommandException("You do not have permission to delete this claim's subclaims!", new Object[0]);
            }
            ImmutableSet subclaims = claim.getSubClaims();
            if (subclaims == null || subclaims.size() == 0) {
                ConfirmationManager.getManager().removeConfirm(sender);
                throw new CommandException("No subclaims were found.", new Object[0]);
            }
            failed = false;
            for (SubClaimArea subclaim : subclaims) {
                boolean s = claim.removeSubClaim(subclaim);
                if (s) continue;
                failed = true;
            }
        } else {
            ConfirmationManager.getManager().removeConfirm(sender);
            throw new CommandException("A subclaim deletion was confirmed, but the claim supplied was deleted! Action failed.", new Object[0]);
        }
        CommandSubSubClaimDeleteAll.sendBMessage(sender, "Removed all subclaims." + (failed ? " Something prevented some subclaims from being removed." : ""));
        ConfirmationManager.getManager().removeConfirm(sender);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return CommandBase.func_175762_a((String[])args, CommandUtils.getOwnedClaimNames(null, sender));
        }
        return new ArrayList<String>();
    }
}

