/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command.claimit.subclaim;

import dev.itsmeow.claimit.api.claim.ClaimArea;
import dev.itsmeow.claimit.api.claim.SubClaimArea;
import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.util.command.CommandUtils;
import dev.itsmeow.claimit.util.text.ClaimInfoText;
import dev.itsmeow.claimit.util.text.CommandChatStyle;
import dev.itsmeow.claimit.util.text.FTC;
import dev.itsmeow.claimit.util.text.TeleportXYChatStyle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class CommandSubSubClaimInfo
extends CommandCIBase {
    public String func_71517_b() {
        return "info";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/claimit subclaim info [claimname) (subclaimname]";
    }

    @Override
    public String getHelp(ICommandSender sender) {
        return "Displays information about a subclaim. No arguments attempts getting subclaim for your location. Arguments one and two are used for claim/subclaim names" + (CommandUtils.isAdmin(sender) ? "Admins must use true names." : "");
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length > 2) {
            CommandSubSubClaimInfo.sendMessage(sender, TextFormatting.RED, "Invalid argument count. Usage: " + this.func_71518_a(sender));
        }
        SubClaimArea subClaim = CommandUtils.getSubClaimWithNamesOrLocation(0, args, sender);
        CommandSubSubClaimInfo.outputClaimInfo(subClaim, sender);
    }

    private static void outputClaimInfo(SubClaimArea subClaim, ICommandSender sender) {
        BlockPos[] corners = subClaim.getTwoMainClaimCorners();
        CommandSubSubClaimInfo.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.BLUE, FTC.Form.BOLD, "Information for subclaim of claim "), new ClaimInfoText(subClaim.getParent(), TextFormatting.GREEN, FTC.Form.BOLD_UNDERLINE), new FTC(TextFormatting.BLUE, FTC.Form.BOLD, ":")});
        CommandSubSubClaimInfo.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.BLUE, "Subclaim Name: "), new FTC(TextFormatting.YELLOW, subClaim.getDisplayedViewName())});
        CommandSubSubClaimInfo.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.BLUE, "Area: "), new FTC(TextFormatting.AQUA, subClaim.getSideLengthX() + 1 + ""), new FTC(TextFormatting.BLUE, "x"), new FTC(TextFormatting.AQUA, subClaim.getSideLengthZ() + 1 + ""), new FTC(TextFormatting.BLUE, " ("), new FTC(TextFormatting.AQUA, subClaim.getArea() + ""), new FTC(TextFormatting.BLUE, ")")});
        CommandSubSubClaimInfo.sendAdminStyleMessage(sender, TextFormatting.BLUE + "Corner 1: " + TextFormatting.DARK_PURPLE + corners[0].func_177958_n() + TextFormatting.BLUE + ", " + TextFormatting.DARK_PURPLE + corners[0].func_177952_p(), new TeleportXYChatStyle(subClaim.getDimensionID(), corners[0].func_177958_n(), corners[0].func_177952_p()));
        CommandSubSubClaimInfo.sendAdminStyleMessage(sender, TextFormatting.BLUE + "Corner 2: " + TextFormatting.DARK_PURPLE + corners[1].func_177958_n() + TextFormatting.BLUE + ", " + TextFormatting.DARK_PURPLE + corners[1].func_177952_p(), new TeleportXYChatStyle(subClaim.getDimensionID(), corners[1].func_177958_n(), corners[1].func_177952_p()));
        if (CommandUtils.isAdminWithNodeOrManage(sender, (ClaimArea)subClaim, "claimit.subclaim.permission.list.others")) {
            CommandSubSubClaimInfo.sendSMessage(sender, "View Members", new CommandChatStyle("/ci subclaim permission list " + (CommandUtils.isAdmin(sender) ? subClaim.getParent().getTrueViewName() : subClaim.getParent().getDisplayedViewName()) + " " + subClaim.getDisplayedViewName(), true, "Click to view subclaim members").func_150238_a(TextFormatting.GREEN).func_150228_d(Boolean.valueOf(true)).func_150217_b(Boolean.valueOf(true)));
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1 || args.length == 2) {
            return CommandUtils.getSubclaimCompletions(null, 0, args, sender);
        }
        return new ArrayList<String>();
    }

    @Override
    public String getPermissionString() {
        return "claimit.subclaim.info";
    }
}

