/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command.claimit.subclaim;

import dev.itsmeow.claimit.api.claim.ClaimArea;
import dev.itsmeow.claimit.api.claim.SubClaimArea;
import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.util.command.CommandUtils;
import dev.itsmeow.claimit.util.text.ClaimInfoText;
import dev.itsmeow.claimit.util.text.FTC;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class CommandSubSubClaimList
extends CommandCIBase {
    public String func_71517_b() {
        return "list";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/claimit subclaim list [claimname]";
    }

    @Override
    public String getHelp(ICommandSender sender) {
        return "Lists all subclaims in specified claim. Click names to view info on them.";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String claimname = null;
        if (args.length == 1) {
            claimname = args[0];
        } else if (args.length > 1) {
            throw new CommandException("Too many arguments! Usage: " + this.func_71518_a(sender), new Object[0]);
        }
        ClaimArea claim = CommandUtils.getClaimWithNameOrLocation(claimname, sender);
        if (claim == null) {
            throw new CommandException("No claim found!", new Object[0]);
        }
        if (claim.getSubClaims().size() > 0) {
            int i = 0;
            for (SubClaimArea subclaim : claim.getSubClaims()) {
                if (++i == 1) {
                    CommandSubSubClaimList.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.BLUE, "Subclaim list for claim "), new ClaimInfoText(claim, TextFormatting.GREEN, FTC.Form.BOLD_UNDERLINE), new FTC(TextFormatting.DARK_BLUE, ":")});
                }
                CommandSubSubClaimList.sendMessage(sender, new ITextComponent[]{new FTC("Name: ", TextFormatting.BLUE), new ClaimInfoText((ClaimArea)subclaim, TextFormatting.DARK_GREEN)});
            }
        } else {
            CommandSubSubClaimList.sendMessage(sender, TextFormatting.RED, "There are no subclaims in this claim!");
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return CommandBase.func_175762_a((String[])args, CommandUtils.getOwnedClaimNames(null, sender));
        }
        return new ArrayList<String>();
    }

    @Override
    public String getPermissionString() {
        return "claimit.subclaim.list";
    }
}

