/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command.claimit.subclaim;

import dev.itsmeow.claimit.api.claim.ClaimArea;
import dev.itsmeow.claimit.api.claim.SubClaimArea;
import dev.itsmeow.claimit.api.permission.ClaimPermissionMember;
import dev.itsmeow.claimit.api.permission.ClaimPermissionRegistry;
import dev.itsmeow.claimit.command.CommandCITreeBase;
import dev.itsmeow.claimit.command.claimit.subclaim.permission.CommandSubSubClaimPermissionList;
import dev.itsmeow.claimit.util.command.CommandUtils;
import dev.itsmeow.claimit.util.text.FTC;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class CommandSubSubClaimPermission
extends CommandCITreeBase {
    public CommandSubSubClaimPermission() {
        super(new CommandSubSubClaimPermissionList());
    }

    public String func_71517_b() {
        return "permission";
    }

    public List<String> func_71514_a() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("perm");
        list.add("player");
        return list;
    }

    @Override
    public String getHelp(ICommandSender sender) {
        return "Both a tree command and a command. Add or remove members from a claim. Subcommand 'list' exists. First required argument is add or remove. Second is a member permission. Third is a username. Fourth and fifth, optional arguments are a claim name and subclaim name- claim name not required if within a claim. Otherwise, your current location is used.";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/claimit claim permission <add/remove> <permission> <username> [claimname) (subclaimname]";
    }

    @Override
    public void executeBaseCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 3 || args.length > 5) {
            throw new CommandException("Improper argument count! Usage: \n" + TextFormatting.YELLOW + this.func_71518_a(sender), new Object[0]);
        }
        String action = args[0].toLowerCase();
        String permissionStr = args[1];
        String username = args[2];
        SubClaimArea subClaim = CommandUtils.getSubClaimWithNamesOrLocation(3, args, sender);
        if (!action.equalsIgnoreCase("add") && !action.equalsIgnoreCase("remove")) {
            throw new CommandException("Invalid action! Specify add or remove. Usage: \n" + TextFormatting.YELLOW + this.func_71518_a(sender), new Object[0]);
        }
        if (!CommandUtils.isAdminWithNodeOrManage(sender, (ClaimArea)subClaim, "claimit.command.claimit.subclaim.permission.others")) {
            throw new CommandException("You cannot modify members of this subclaim!", new Object[0]);
        }
        Set<ClaimPermissionMember> permissions = CommandUtils.getMemberPermissionsForArgument((Set<ClaimPermissionMember>)ClaimPermissionRegistry.getMemberPermissions(), this.func_71518_a(sender), permissionStr, sender, server);
        Object wildcard = subClaim.getMembers().keySet();
        wildcard = new HashSet(wildcard);
        wildcard.remove(subClaim.getOwner());
        Set<UUID> ids = CommandUtils.getUUIDsForArgument((Set<UUID>)wildcard, username, sender, server);
        if (ids.size() == 0) {
            CommandSubSubClaimPermission.sendMessage(sender, TextFormatting.RED, "No members to " + action.toLowerCase() + "!");
        }
        if (action.equals("add")) {
            for (UUID id : ids) {
                username = CommandUtils.getNameForUUID(id, server);
                for (ClaimPermissionMember permission : permissions) {
                    if (subClaim.addMember(id, permission)) {
                        CommandSubSubClaimPermission.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.GREEN, "Successfully added "), new FTC(TextFormatting.YELLOW, username), new FTC(TextFormatting.GREEN, " to subclaim "), new FTC(TextFormatting.DARK_GREEN, subClaim.getDisplayedViewName()), new FTC(TextFormatting.GREEN, " with permission "), new FTC(TextFormatting.AQUA, permission.parsedName)});
                        continue;
                    }
                    if (permissions.size() != 1) continue;
                    CommandSubSubClaimPermission.sendMessage(sender, TextFormatting.YELLOW, "This player already has that permission!");
                }
            }
        } else if (action.equals("remove")) {
            for (UUID id : ids) {
                username = CommandUtils.getNameForUUID(id, server);
                for (ClaimPermissionMember permission : permissions) {
                    if (subClaim.removeMember(id, permission)) {
                        CommandSubSubClaimPermission.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.GREEN, "Successfully removed permission "), new FTC(TextFormatting.AQUA, permission.parsedName), new FTC(TextFormatting.GREEN, " from user "), new FTC(TextFormatting.YELLOW, username), new FTC(TextFormatting.GREEN, " in subclaim "), new FTC(TextFormatting.DARK_GREEN, subClaim.getDisplayedViewName())});
                        continue;
                    }
                    if (permissions.size() != 1) continue;
                    CommandSubSubClaimPermission.sendMessage(sender, TextFormatting.YELLOW, "This player does not have that permission!");
                }
            }
        } else {
            throw new CommandException("Invalid action! Specify add or remove. Usage: \n" + TextFormatting.YELLOW + this.func_71518_a(sender), new Object[0]);
        }
    }

    @Override
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1) {
            list.add("add");
            list.add("remove");
            list.add("list");
            return CommandBase.func_175762_a((String[])args, list);
        }
        if (args.length == 2) {
            return CommandBase.func_175762_a((String[])args, CommandUtils.getMemberPermissionsAndWildcard(list));
        }
        if (args.length == 3) {
            return CommandBase.func_175762_a((String[])args, CommandUtils.getPossiblePlayers(list, server, sender, args));
        }
        if (args.length == 4 || args.length == 5) {
            return CommandUtils.getSubclaimCompletions(list, 3, args, sender);
        }
        return list;
    }

    @Override
    public String getPermissionString() {
        return "claimit.subclaim.permission";
    }
}

