/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command.claimit.subclaim;

import dev.itsmeow.claimit.api.claim.ClaimArea;
import dev.itsmeow.claimit.api.claim.SubClaimArea;
import dev.itsmeow.claimit.api.permission.ClaimPermissionRegistry;
import dev.itsmeow.claimit.api.permission.ClaimPermissionToggle;
import dev.itsmeow.claimit.api.permission.ClaimPermissions;
import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.util.command.CommandUtils;
import dev.itsmeow.claimit.util.text.CommandChatStyle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class CommandSubSubClaimToggle
extends CommandCIBase {
    public String func_71517_b() {
        return "toggle";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/claimit subclaim toggle [toggle name] [claim name) (subclaim name]";
    }

    @Override
    public String getHelp(ICommandSender sender) {
        return "Controls toggle permissions. Given no arguments, will display all toggles and values. Given only a toggle as an argument, it will switch it on or off. Optional second and third claim/subclaim name argument, defaults to location.";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        SubClaimArea claim = CommandUtils.getSubClaimWithNamesOrLocation(1, args, sender);
        if (args.length == 0 || args.length == 1 && args[0].equals("list")) {
            if (CommandUtils.canManagePerms(sender, (ClaimArea)claim)) {
                for (ClaimPermissionToggle toggle : ClaimPermissionRegistry.getTogglePermissions()) {
                    boolean toggled = claim.isPermissionToggled(toggle);
                    String toggledStr = toggled ? "ON" : "OFF";
                    toggledStr = toggle.getDefault() == toggled ? TextFormatting.GREEN + toggledStr : TextFormatting.RED + toggledStr;
                    CommandSubSubClaimToggle.sendSMessage(sender, TextFormatting.YELLOW + toggle.parsedName + TextFormatting.BLUE + ": " + toggledStr, new CommandChatStyle("/claimit subclaim toggle " + toggle.parsedName, true, CommandSubSubClaimToggle.getHoverFor(toggle, (ClaimArea)claim)));
                }
                return;
            }
            throw new CommandException("You cannot modify toggles of this subclaim!", new Object[0]);
        }
        if (args.length > 3 || args.length < 1) {
            throw new WrongUsageException(this.func_71518_a(sender) + "\n Invalid argument count!", new Object[0]);
        }
        ClaimPermissionToggle perm = CommandUtils.getPermissionToggle(args[0], this.func_71518_a(sender));
        if (!CommandUtils.isAdminNoded(sender, "claimit.command.claimit.subclaim.toggle.others") && sender instanceof EntityPlayer && !claim.isOwner((EntityPlayer)sender) && !claim.inPermissionList(ClaimPermissions.MANAGE_PERMS, ((EntityPlayer)sender).func_146103_bH().getId())) {
            throw new CommandException("You cannot modify toggles of this subclaim!", new Object[0]);
        }
        if (CommandUtils.canManagePerms(sender, (ClaimArea)claim)) {
            if (perm.getForceEnabled()) {
                claim.setPermissionToggle(perm, perm.getForceValue());
                throw new CommandException("This toggle cannot be modified. It has been forced to a value by the server.", new Object[0]);
            }
            claim.flipPermissionToggle(perm);
            CommandSubSubClaimToggle.sendSMessage(sender, TextFormatting.BLUE + "Set " + TextFormatting.YELLOW + perm.parsedName + TextFormatting.BLUE + " to " + CommandSubSubClaimToggle.getStringFor(perm, claim.isPermissionToggled(perm)), new CommandChatStyle("/claimit subclaim toggle " + perm.parsedName, true, CommandSubSubClaimToggle.getHoverFor(perm, (ClaimArea)claim)));
        } else {
            CommandSubSubClaimToggle.sendMessage(sender, TextFormatting.RED, "You cannot modify toggles of this subclaim!");
        }
    }

    private static String getStringFor(ClaimPermissionToggle perm, boolean toggled) {
        String toggledStr = toggled ? "ON" : "OFF";
        return perm.getDefault() == toggled ? TextFormatting.GREEN + toggledStr : TextFormatting.RED + toggledStr;
    }

    private static String getHoverFor(ClaimPermissionToggle perm, ClaimArea claim) {
        return TextFormatting.BLUE + "Click to toggle " + TextFormatting.YELLOW + perm.parsedName + TextFormatting.BLUE + " to " + CommandSubSubClaimToggle.getStringFor(perm, !claim.isPermissionToggled(perm)) + "\n" + TextFormatting.BLUE + "Help Info: " + TextFormatting.YELLOW + perm.helpInfo;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1) {
            return CommandBase.func_175762_a((String[])args, CommandUtils.getTogglePermissions(list));
        }
        if (args.length == 2 || args.length == 3) {
            return CommandUtils.getSubclaimCompletions(list, 1, args, sender);
        }
        return list;
    }

    @Override
    public String getPermissionString() {
        return "claimit.subclaim.toggle";
    }
}

