/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command.claimit.subclaim.permission;

import com.google.common.collect.ImmutableSetMultimap;
import dev.itsmeow.claimit.api.claim.ClaimArea;
import dev.itsmeow.claimit.api.claim.SubClaimArea;
import dev.itsmeow.claimit.api.permission.ClaimPermissionMember;
import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.util.command.CommandUtils;
import dev.itsmeow.claimit.util.text.FTC;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class CommandSubSubClaimPermissionList
extends CommandCIBase {
    public String func_71517_b() {
        return "list";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/claimit subclaim permission list [claimname) (subclaimname]";
    }

    @Override
    public String getHelp(ICommandSender sender) {
        return "Lists member permissions within a subclaim. Argument one and two are optional claim/subclaim name. Defaults to location.";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        SubClaimArea subClaim = CommandUtils.getSubClaimWithNamesOrLocation(0, args, sender);
        CommandSubSubClaimPermissionList.outputMembers((ClaimArea)subClaim, sender);
    }

    private static void outputMembers(ClaimArea claim, ICommandSender sender) throws CommandException {
        ImmutableSetMultimap permMap = claim.getMembers();
        if (!CommandUtils.isAdminWithNodeOrManage(sender, claim, "claimit.subclaim.permission.list.others")) {
            throw new CommandException("You cannot view the members of this subclaim!", new Object[0]);
        }
        if (permMap == null || permMap.isEmpty()) {
            CommandSubSubClaimPermissionList.sendMessage(sender, TextFormatting.RED, "This subclaim has no members.");
        } else {
            for (UUID uuid : permMap.keySet()) {
                CommandSubSubClaimPermissionList.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.YELLOW, CommandUtils.getNameForUUID(uuid, sender.func_130014_f_().func_73046_m())), new FTC(TextFormatting.BLUE, " - "), new FTC(TextFormatting.GREEN, CommandSubSubClaimPermissionList.getMemberLine(uuid, (Set<ClaimPermissionMember>)permMap.get((Object)uuid)))});
            }
        }
    }

    private static String getMemberLine(UUID member, Set<ClaimPermissionMember> permSet) {
        String permString = "";
        for (ClaimPermissionMember p : permSet) {
            permString = permString + p.parsedName + TextFormatting.BLUE + ", " + TextFormatting.GREEN;
        }
        int end = permString.lastIndexOf(44);
        return permString.substring(0, end);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1 || args.length == 2) {
            return CommandUtils.getSubclaimCompletions(null, 0, args, sender);
        }
        return new ArrayList<String>();
    }

    @Override
    public String getPermissionString() {
        return "claimit.subclaim.permission.list";
    }
}

