/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.util;

import com.google.common.collect.ImmutableList;
import dev.itsmeow.claimit.api.claim.ClaimArea;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class ClaimPage {
    private ArrayList<ClaimArea> page = new ArrayList(3);

    public ClaimPage(ClaimArea area1, @Nullable ClaimArea area2, @Nullable ClaimArea area3) {
        this.page.add(area1);
        if (area2 != null) {
            this.page.add(area2);
        }
        if (area3 != null) {
            this.page.add(area3);
        }
    }

    public int getPageSize() {
        return this.page.size();
    }

    public boolean isFull() {
        return this.page.size() == 3;
    }

    public boolean addToPageIfNotFull(ClaimArea claim) {
        if (!this.isFull()) {
            this.page.add(claim);
            return true;
        }
        return false;
    }

    @Nullable
    public ClaimArea getInPage(int index) {
        int i = index % 3;
        return this.page.size() >= i ? this.page.get(i) : null;
    }

    public ImmutableList<ClaimArea> getClaimsInPage() {
        return ImmutableList.copyOf(this.page);
    }
}

