/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.util;

import com.google.common.collect.ImmutableList;
import dev.itsmeow.claimit.api.claim.ClaimArea;
import dev.itsmeow.claimit.api.event.claim.ClaimAddedEvent;
import dev.itsmeow.claimit.api.event.claim.ClaimRemovedEvent;
import dev.itsmeow.claimit.api.event.claim.ClaimsClearedEvent;
import dev.itsmeow.claimit.util.ClaimPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="claimit")
public class ClaimPageTracker {
    private static ArrayList<ClaimPage> pages = new ArrayList();
    private static HashMap<UUID, ArrayList<ClaimPage>> playerPages = new HashMap();

    @SubscribeEvent
    public static void claimAdded(ClaimAddedEvent e) {
        boolean addedAny = false;
        ClaimArea claim = e.getClaim();
        for (ClaimPage page : pages) {
            if (!page.addToPageIfNotFull(claim)) continue;
            addedAny = true;
            break;
        }
        if (!addedAny) {
            pages.add(new ClaimPage(claim, null, null));
        }
        UUID owner = claim.getOwner();
        ClaimPageTracker.ensurePages(owner);
        boolean addedAny2 = false;
        for (ClaimPage page : playerPages.get(owner)) {
            if (!page.addToPageIfNotFull(claim)) continue;
            addedAny2 = true;
            break;
        }
        if (!addedAny2) {
            playerPages.get(owner).add(new ClaimPage(claim, null, null));
        }
    }

    @SubscribeEvent
    public static void claimRemoved(ClaimRemovedEvent e) {
        ArrayList<ClaimPage> playerPageList = playerPages.get(e.getClaim().getOwner());
        if (playerPageList != null && !playerPageList.isEmpty()) {
            playerPages.put(e.getClaim().getOwner(), ClaimPageTracker.removeAndRebuild(playerPageList, e.getClaim()));
        }
        if (!pages.isEmpty()) {
            pages = ClaimPageTracker.removeAndRebuild(pages, e.getClaim());
        }
    }

    private static ArrayList<ClaimPage> removeAndRebuild(ArrayList<ClaimPage> list, ClaimArea toRemove) {
        ArrayList claimList = new ArrayList();
        ArrayList<ClaimPage> newList = new ArrayList<ClaimPage>();
        list.forEach(page -> page.getClaimsInPage().forEach(claim -> claimList.add(claim)));
        claimList.remove(toRemove);
        for (ClaimArea claim : claimList) {
            boolean addedAny = false;
            for (ClaimPage page2 : newList) {
                if (!page2.addToPageIfNotFull(claim)) continue;
                addedAny = true;
                break;
            }
            if (addedAny) continue;
            newList.add(new ClaimPage(claim, null, null));
        }
        return newList;
    }

    @SubscribeEvent
    public static void claimsCleared(ClaimsClearedEvent.Pre e) {
        pages.clear();
        playerPages.clear();
    }

    @Nullable
    public static ClaimPage getPage(@Nullable UUID owner, int index) {
        try {
            if (owner != null) {
                ClaimPageTracker.ensurePages(owner);
                return playerPages.get(owner).get(index);
            }
            return pages.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public static ImmutableList<ClaimPage> getPages(@Nullable UUID filter) {
        ClaimPageTracker.ensurePages(filter);
        return ImmutableList.copyOf(filter == null ? pages : (Collection)playerPages.get(filter));
    }

    public static int getMaxPage(@Nullable UUID filter) {
        ClaimPageTracker.ensurePages(filter);
        return filter == null ? pages.size() : playerPages.get(filter).size();
    }

    private static void ensurePages(@Nullable UUID owner) {
        if (owner != null && !playerPages.containsKey(owner)) {
            playerPages.put(owner, new ArrayList());
        }
    }
}

