/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.util;

import dev.itsmeow.claimit.api.claim.ClaimManager;
import dev.itsmeow.claimit.api.event.claim.ClaimCreatedEvent;
import dev.itsmeow.claimit.config.ClaimItConfig;
import dev.itsmeow.claimit.serialization.ClaimItGlobalDataSerializer;
import dev.itsmeow.claimit.util.text.FTC;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="claimit")
public class UserClaimBlocks {
    private static HashMap<UUID, Integer> claimBlocksAllowed = new HashMap();

    public static int getClaimBlocksUsed(UUID uuid) {
        return ClaimManager.getManager().getClaimsOwnedByPlayer(uuid).stream().mapToInt(claim -> claim.getArea()).sum();
    }

    public static int getClaimBlocksRemaining(UUID uuid) {
        return UserClaimBlocks.getClaimBlocksAllowed(uuid) - UserClaimBlocks.getClaimBlocksUsed(uuid);
    }

    public static int getClaimBlocksAllowed(UUID uuid) {
        return claimBlocksAllowed.getOrDefault(uuid, ClaimItConfig.default_claim_max_area);
    }

    public static void setAllowedClaimBlocks(UUID uuid, int allowedBlocks) {
        claimBlocksAllowed.put(uuid, allowedBlocks);
    }

    @SubscribeEvent
    public static void onClaimCreated(ClaimCreatedEvent e) {
        int area = e.getClaim().getArea();
        UUID owner = e.getClaim().getOwner();
        int allowed = UserClaimBlocks.getClaimBlocksRemaining(owner);
        EntityPlayer player = e.getClaim().getWorld().func_152378_a(owner);
        if (allowed - area < 0) {
            if (player != null) {
                player.func_145747_a((ITextComponent)new FTC("You need " + Math.abs(allowed - area) + " more claim blocks to create this claim!", TextFormatting.RED));
                player.func_145747_a((ITextComponent)new FTC("Claim Blocks Required: " + area, TextFormatting.YELLOW));
                player.func_145747_a((ITextComponent)new FTC("Claim Blocks Remaining: " + allowed, TextFormatting.YELLOW));
            }
            e.setCanceled(true);
        } else if (player != null) {
            player.func_145747_a((ITextComponent)new FTC("This claim is " + area + " claim blocks. You now have " + (allowed - area) + " claim blocks remaining.", TextFormatting.GREEN));
        }
    }

    public static void serialize() {
        NBTTagCompound tag = new NBTTagCompound();
        claimBlocksAllowed.forEach((uuid, amount) -> {
            if (amount != ClaimItConfig.default_claim_max_area) {
                tag.func_74768_a(uuid.toString(), amount.intValue());
            }
        });
        ClaimItGlobalDataSerializer.get().data.func_74782_a("USER_MAX_CLAIM_BLOCKS", (NBTBase)tag);
        ClaimItGlobalDataSerializer wsd = ClaimItGlobalDataSerializer.get();
        wsd.func_76185_a();
    }

    public static void deserialize() {
        NBTTagCompound tag = ClaimItGlobalDataSerializer.get().data.func_74775_l("USER_MAX_CLAIM_BLOCKS");
        if (tag != null) {
            tag.func_150296_c().forEach(key -> {
                if (tag.func_150297_b(key, 3)) {
                    claimBlocksAllowed.put(UUID.fromString(key), tag.func_74762_e(key));
                }
            });
        }
    }
}

