/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.util.command;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import dev.itsmeow.claimit.api.AdminManager;
import dev.itsmeow.claimit.api.claim.ClaimArea;
import dev.itsmeow.claimit.api.claim.ClaimManager;
import dev.itsmeow.claimit.api.claim.SubClaimArea;
import dev.itsmeow.claimit.api.group.GroupManager;
import dev.itsmeow.claimit.api.permission.ClaimPermissionMember;
import dev.itsmeow.claimit.api.permission.ClaimPermissionRegistry;
import dev.itsmeow.claimit.api.permission.ClaimPermissionToggle;
import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.util.text.FTC;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;

public class CommandUtils {
    @Nullable
    public static ClaimArea getClaimWithName(String claimName, ICommandSender sender) {
        ClaimArea claim = null;
        ClaimManager mgr = ClaimManager.getManager();
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            claim = mgr.getClaimByNameAndOwner(claimName, player.func_110124_au());
            ClaimArea trueC = mgr.getClaimByTrueName(claimName);
            if (claim == null && AdminManager.isAdmin((EntityPlayer)player)) {
                CommandCIBase.sendMessage(sender, TextFormatting.AQUA, "Using true name.");
                claim = mgr.getClaimByTrueName(claimName);
            } else if (claim == null && trueC != null && trueC.isOwner(player)) {
                claim = trueC;
            }
        } else if (sender.func_70003_b(2, "")) {
            CommandCIBase.sendMessage(sender, TextFormatting.YELLOW, "You are console, using true name");
            claim = mgr.getClaimByTrueName(claimName);
        }
        return claim;
    }

    @Nullable
    public static ClaimArea getClaimWithNameOrLocation(String claimName, ICommandSender sender) throws CommandException {
        ClaimArea claim = null;
        if (claimName != null && !claimName.equals("")) {
            claim = CommandUtils.getClaimWithName(claimName, sender);
        } else if (sender instanceof EntityPlayer) {
            claim = ClaimManager.getManager().getClaimAtLocation(sender.func_130014_f_(), sender.func_180425_c());
        } else {
            throw new CommandException("Console must specify a true claim name!", new Object[0]);
        }
        return claim;
    }

    public static ClaimPermissionMember getPermissionMember(String permName, String usage) throws CommandException {
        String validPerms = ClaimPermissionRegistry.getValidPermissionListMember();
        ClaimPermissionMember permission = null;
        try {
            permission = ClaimPermissionRegistry.getPermissionMember((String)permName);
        }
        catch (IllegalArgumentException e) {
            throw new CommandException("Invalid permission. Valid Permissions: " + validPerms + "\nUsage: " + usage, new Object[0]);
        }
        if (permission == null) {
            throw new CommandException("Invalid permission. Valid Permissions: " + validPerms + "\nUsage: " + usage, new Object[0]);
        }
        return permission;
    }

    public static ClaimPermissionToggle getPermissionToggle(String permName, String usage) throws CommandException {
        String validPerms = ClaimPermissionRegistry.getValidPermissionListToggle();
        ClaimPermissionToggle permission = null;
        try {
            permission = ClaimPermissionRegistry.getPermissionToggle((String)permName);
        }
        catch (IllegalArgumentException e) {
            throw new CommandException("Invalid permission. Valid Permissions: " + validPerms + "\nUsage: " + usage, new Object[0]);
        }
        if (permission == null) {
            throw new CommandException("Invalid permission. Valid Permissions: " + validPerms + "\nUsage: " + usage, new Object[0]);
        }
        return permission;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public static SubClaimArea getSubClaimWithNamesOrLocation(int startIndex, String[] args, ICommandSender sender) throws CommandException {
        String claimName = null;
        if (args.length >= startIndex + 1) {
            claimName = args[startIndex];
        }
        ClaimArea claim = CommandUtils.getClaimWithNameOrLocation(claimName, sender);
        if (claimName != null && claim == null) {
            claim = ClaimManager.getManager().getClaimAtLocation(sender.func_130014_f_(), sender.func_180425_c());
        }
        SubClaimArea subClaim = null;
        if (claimName == null && claim == null) {
            throw new CommandException("There is no claim here!", new Object[0]);
        }
        if (claim != null && claimName != null && args.length == startIndex + 1) {
            if (claim.getSubClaimWithName(claimName) == null) throw new CommandException("There is no subclaim in this claim with that name!", new Object[0]);
            subClaim = claim.getSubClaimWithName(claimName);
        } else if (claim == null && claimName != null) {
            throw new CommandException("No claim with this name!", new Object[0]);
        }
        String subClaimName = null;
        if (args.length == startIndex + 2 && (subClaim = claim.getSubClaimWithName(subClaimName = args[startIndex + 1])) == null) {
            throw new CommandException("There is no subclaim with that name in that claim!", new Object[0]);
        }
        if (args.length <= startIndex && claim != null) {
            subClaim = claim.getSubClaimAtLocation(sender.func_180425_c());
        }
        if (subClaim != null && claim != null) return subClaim;
        throw new CommandException("Could not get subclaim!", new Object[0]);
    }

    public static boolean canManagePerms(ICommandSender sender, ClaimArea claim) {
        return sender instanceof EntityPlayer ? claim.canManage((EntityPlayer)sender) : sender.func_70003_b(2, "claimit.claim.manage.others");
    }

    public static UUID getUUIDForName(String username, MinecraftServer server) throws PlayerNotFoundException {
        if (username == null) {
            return null;
        }
        GameProfile profile = server.func_152358_ax().func_152655_a(username);
        if (profile != null && profile.getName().equals(username)) {
            return profile.getId();
        }
        throw new PlayerNotFoundException("Invalid player: " + username);
    }

    public static Set<UUID> getUUIDsForArgument(Set<UUID> wildcard, String names, ICommandSender sender, MinecraftServer server) throws PlayerNotFoundException {
        HashSet<UUID> uuids = new HashSet<UUID>();
        if (names == null) {
            return uuids;
        }
        if (names.contains(",")) {
            for (String username : names.split(",")) {
                GameProfile profile = server.func_152358_ax().func_152655_a(username);
                if (profile != null && profile.getName().equals(username)) {
                    uuids.add(profile.getId());
                    continue;
                }
                sender.func_145747_a((ITextComponent)new FTC(TextFormatting.RED, "No such player " + username));
            }
        } else {
            if (names.equals("*")) {
                return wildcard;
            }
            uuids.add(CommandUtils.getUUIDForName(names, server));
            return uuids;
        }
        return uuids;
    }

    public static Set<ClaimPermissionMember> getMemberPermissionsForArgument(Set<ClaimPermissionMember> wildcard, String usage, String arg, ICommandSender sender, MinecraftServer server) throws CommandException {
        HashSet<ClaimPermissionMember> set = new HashSet<ClaimPermissionMember>();
        if (arg == null) {
            return set;
        }
        if (arg.contains(",")) {
            for (String arg1 : arg.split(",")) {
                set.add(CommandUtils.getPermissionMember(arg1, "\n" + TextFormatting.YELLOW + usage));
            }
        } else {
            if (arg.equals("*")) {
                return wildcard;
            }
            set.add(CommandUtils.getPermissionMember(arg, "\n" + TextFormatting.YELLOW + usage));
            return set;
        }
        return set;
    }

    @Nonnull
    public static String getNameForUUID(UUID uuid, MinecraftServer server) {
        String name = null;
        GameProfile profile = server.func_152358_ax().func_152652_a(uuid);
        name = profile != null ? profile.getName() : uuid.toString();
        return name;
    }

    public static boolean isAdmin(ICommandSender sender) {
        return CommandUtils.isAdminNoded(sender, "");
    }

    public static boolean isAdminNoded(ICommandSender sender, String permNode) {
        return !(sender instanceof EntityPlayer) && sender.func_70003_b(2, permNode) || sender instanceof EntityPlayer && AdminManager.isAdmin((EntityPlayer)((EntityPlayer)sender)) && sender.func_70003_b(0, permNode);
    }

    public static boolean isAdminNodedNeedsManage(ICommandSender sender, String permNode) {
        return !(sender instanceof EntityPlayer) && sender.func_70003_b(2, permNode) && sender.func_70003_b(2, "claimit.claim.manage.others") || sender instanceof EntityPlayer && AdminManager.isAdmin((EntityPlayer)((EntityPlayer)sender)) && sender.func_70003_b(0, "claimit.claim.manage.others") && sender.func_70003_b(0, permNode);
    }

    public static boolean isAdminWithNodeOrOwner(ICommandSender sender, ClaimArea claim, String permNode) {
        if (sender instanceof EntityPlayer) {
            return claim.isOwner((EntityPlayer)sender) || CommandUtils.isAdminNodedNeedsManage(sender, permNode);
        }
        return CommandUtils.isAdminNodedNeedsManage(sender, permNode);
    }

    public static boolean isAdminWithNodeOrManage(ICommandSender sender, ClaimArea claim, String permNode) {
        if (sender instanceof EntityPlayer) {
            return claim.canManage((EntityPlayer)sender) || CommandUtils.isAdminNodedNeedsManage(sender, permNode);
        }
        return CommandUtils.isAdminNodedNeedsManage(sender, permNode);
    }

    public static List<String> getOwnedClaimNames(@Nullable List<String> list, ICommandSender sender) {
        if (list == null) {
            list = new ArrayList<String>();
        }
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            ImmutableSet owned = ClaimManager.getManager().getClaimsOwnedByPlayer(player.func_146103_bH().getId());
            if (owned != null) {
                for (ClaimArea claim : owned) {
                    list.add(claim.getDisplayedViewName());
                }
            }
        }
        return list;
    }

    public static List<String> getSubclaimNames(@Nullable List<String> list, ICommandSender sender, ClaimArea parent) {
        ImmutableSet owned;
        if (list == null) {
            list = new ArrayList<String>();
        }
        if (sender instanceof EntityPlayer && (owned = parent.getSubClaims()) != null && owned.size() > 0) {
            for (SubClaimArea subclaim : owned) {
                list.add(subclaim.getDisplayedViewName());
            }
        }
        return list;
    }

    public static List<String> getRelevantGroupNames(ICommandSender sender) {
        if (sender instanceof EntityPlayer) {
            UUID uuid = ((EntityPlayer)sender).func_146103_bH().getId();
            return GroupManager.getGroups().stream().filter(g -> g.getMembers().keySet().contains((Object)uuid) || g.isOwner(uuid)).collect(ArrayList::new, (l, g) -> l.add(g.getName()), (l, l1) -> l1.addAll(l));
        }
        return new ArrayList<String>();
    }

    public static List<String> getPossiblePlayers(@Nullable List<String> list, MinecraftServer server, ICommandSender sender, String[] args) {
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.addAll(CommandBase.func_71530_a((String[])args, (String[])server.func_71213_z()));
        return list;
    }

    public static List<String> getMemberPermissionsAndWildcard(@Nullable List<String> list) {
        list = CommandUtils.getMemberPermissions(list);
        list.add("*");
        return list;
    }

    public static List<String> getMemberPermissions(@Nullable List<String> list) {
        if (list == null) {
            list = new ArrayList<String>();
        }
        for (ClaimPermissionMember perm : ClaimPermissionRegistry.getMemberPermissions()) {
            list.add(perm.parsedName);
        }
        return list;
    }

    public static List<String> getTogglePermissions(@Nullable List<String> list) {
        if (list == null) {
            list = new ArrayList<String>();
        }
        for (ClaimPermissionToggle perm : ClaimPermissionRegistry.getTogglePermissions()) {
            list.add(perm.parsedName);
        }
        return list;
    }

    public static boolean checkDefaultNode(EntityPlayer player, int permLevel, String node) {
        return player.func_70003_b(permLevel, node) || !Loader.isModLoaded((String)"sponge");
    }

    public static List<String> getSubclaimCompletions(@Nullable List<String> list, int startIndex, String[] args, ICommandSender sender) {
        ClaimArea claim;
        if (list == null) {
            list = new ArrayList<String>();
        }
        if (args.length == startIndex + 1) {
            if (!ClaimManager.getManager().isBlockInAnyClaim(sender.func_130014_f_(), sender.func_180425_c())) {
                list.addAll(CommandBase.func_175762_a((String[])args, CommandUtils.getOwnedClaimNames(null, sender)));
            } else {
                list.addAll(CommandBase.func_175762_a((String[])args, CommandUtils.getSubclaimNames(null, sender, ClaimManager.getManager().getClaimAtLocation(sender.func_130014_f_(), sender.func_180425_c()))));
            }
        } else if (args.length == startIndex + 2 && (claim = CommandUtils.getClaimWithName(args[startIndex], sender)) != null) {
            list.addAll(CommandBase.func_175762_a((String[])args, CommandUtils.getSubclaimNames(null, sender, claim)));
        }
        return list;
    }
}

