/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.util.command;

import dev.itsmeow.claimit.util.command.IConfirmable;
import java.util.HashMap;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;

public class ConfirmationManager {
    private static ConfirmationManager instance = null;
    private HashMap<ICommandSender, Pair<IConfirmable, String[]>> confirmActions = new HashMap();

    private ConfirmationManager() {
    }

    public static ConfirmationManager getManager() {
        if (instance == null) {
            instance = new ConfirmationManager();
        }
        return instance;
    }

    public boolean needsConfirm(ICommandSender sender) {
        return this.confirmActions.containsKey(sender);
    }

    public IConfirmable getAction(ICommandSender sender) {
        return (IConfirmable)this.confirmActions.get(sender).getLeft();
    }

    public boolean addConfirm(ICommandSender sender, IConfirmable action, String[] args) {
        if (this.needsConfirm(sender)) {
            return false;
        }
        this.confirmActions.put(sender, (Pair<IConfirmable, String[]>)Pair.of((Object)action, (Object)args));
        return true;
    }

    public boolean removeConfirm(ICommandSender sender) {
        if (!this.needsConfirm(sender)) {
            return false;
        }
        this.confirmActions.remove(sender);
        return true;
    }

    public void removeAllConfirms() {
        this.confirmActions.clear();
    }

    public void doAction(MinecraftServer server, ICommandSender sender, IConfirmable action) throws CommandException {
        action.doAction(server, sender, (String[])this.confirmActions.get(sender).getRight());
    }
}

