/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IAirContainerItem;
import cr0s.warpdrive.api.IBreathingHelmet;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnergyWrapper;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.data.StateAir;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.event.ChunkHandler;
import cr0s.warpdrive.render.EntityCamera;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BreathingManager {
    private static final int AIR_BLOCK_TICKS = 20;
    private static final int AIR_DROWN_TICKS = 20;
    private static final int AIR_FIRST_BREATH_TICKS = 300;
    private static final int AIR_IC2_COMPRESSED_AIR_TICKS = 300;
    private static final int AIR_ENERGY_FOR_ELECTROLYSE = 2000;
    private static final VectorI[] vAirOffsets = new VectorI[]{new VectorI(0, 0, 0), new VectorI(0, 1, 0), new VectorI(0, 1, 1), new VectorI(0, 1, -1), new VectorI(1, 1, 0), new VectorI(1, 1, 0), new VectorI(0, 0, 1), new VectorI(0, 0, -1), new VectorI(1, 0, 0), new VectorI(1, 0, 0)};
    private static final HashMap<UUID, Integer> entity_airBlock = new HashMap();
    private static final HashMap<UUID, Integer> player_airTank = new HashMap();

    public static boolean hasAirBlock(EntityLivingBase entityLivingBase, int x, int y, int z) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (VectorI vOffset : vAirOffsets) {
            mutableBlockPos.func_181079_c(x + vOffset.x, y + vOffset.y, z + vOffset.z);
            Block block = entityLivingBase.field_70170_p.func_180495_p((BlockPos)mutableBlockPos).func_177230_c();
            if (!BreathingManager.isAirBlock(block)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAirBlock(@Nonnull Block block) {
        return block == WarpDrive.blockAirSource || block == WarpDrive.blockAirFlow;
    }

    public static boolean onLivingJoinEvent(EntityLivingBase entityLivingBase, int x, int y, int z) {
        if (entityLivingBase instanceof EntityCamera && !entityLivingBase.func_130014_f_().field_72995_K) {
            WarpDrive.logger.warn(String.format("EntityCamera is client-side only, deny spawning %s entityId '%s'", Commons.format(entityLivingBase.field_70170_p, x, y, z), Dictionary.getId((Entity)entityLivingBase)));
            return false;
        }
        if (Dictionary.isLivingWithoutAir((Entity)entityLivingBase)) {
            return true;
        }
        if (BreathingManager.hasAirBlock(entityLivingBase, x, y, z)) {
            return true;
        }
        if (BreathingManager.hasValidSetup(entityLivingBase)) {
            return true;
        }
        if (WarpDriveConfig.LOGGING_BREATHING) {
            WarpDrive.logger.warn(String.format("Entity spawn denied %s entityId '%s'", Commons.format(entityLivingBase.field_70170_p, x, y, z), Dictionary.getId((Entity)entityLivingBase)));
        }
        return false;
    }

    public static void onLivingUpdateEvent(EntityLivingBase entityLivingBase, int x, int y, int z) {
        if (Dictionary.isLivingWithoutAir((Entity)entityLivingBase)) {
            return;
        }
        UUID uuidEntity = entityLivingBase.func_110124_au();
        boolean notInVacuum = false;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (VectorI vOffset : vAirOffsets) {
            StateAir stateAir;
            mutableBlockPos.func_181079_c(x + vOffset.x, y + vOffset.y, z + vOffset.z);
            IBlockState blockState = entityLivingBase.field_70170_p.func_180495_p((BlockPos)mutableBlockPos);
            Block block = blockState.func_177230_c();
            if (BreathingManager.isAirBlock(block)) {
                notInVacuum = true;
                break;
            }
            if (block == Blocks.field_150350_a || (stateAir = ChunkHandler.getStateAir(entityLivingBase.field_70170_p, mutableBlockPos.func_177958_n(), mutableBlockPos.func_177956_o(), mutableBlockPos.func_177952_p())) != null && stateAir.concentration <= 0) continue;
            notInVacuum = true;
            break;
        }
        Integer air = entity_airBlock.get(uuidEntity);
        if (notInVacuum) {
            if (air == null) {
                entity_airBlock.put(uuidEntity, 20);
            } else if (air <= 1) {
                entity_airBlock.put(uuidEntity, 20);
            } else {
                entity_airBlock.put(uuidEntity, air - 1);
            }
        } else {
            if (air == null) {
                entity_airBlock.put(uuidEntity, 300);
                return;
            }
            if (air > 0) {
                if (entityLivingBase instanceof EntityPlayerMP) {
                    entity_airBlock.put(uuidEntity, 0);
                    player_airTank.put(uuidEntity, 300);
                    return;
                }
                entity_airBlock.put(uuidEntity, air - 1);
                return;
            }
            boolean hasValidSetup = BreathingManager.hasValidSetup(entityLivingBase);
            if (entityLivingBase instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)entityLivingBase;
                air = player_airTank.get(uuidEntity);
                boolean hasHelmet = hasValidSetup;
                if (hasValidSetup) {
                    if (air == null) {
                        player_airTank.put(uuidEntity, 300);
                    } else if (air <= 1) {
                        int ticksAir = BreathingManager.consumeAir((EntityLivingBase)player);
                        if (ticksAir > 0) {
                            player_airTank.put(uuidEntity, ticksAir);
                        } else {
                            hasHelmet = false;
                        }
                    } else {
                        player_airTank.put(uuidEntity, air - 1);
                    }
                }
                if (!hasHelmet) {
                    if (air == null) {
                        player_airTank.put(uuidEntity, 300);
                    } else if (air <= 1) {
                        player_airTank.put(uuidEntity, 20);
                        entityLivingBase.func_70097_a((DamageSource)WarpDrive.damageAsphyxia, 2.0f);
                    } else {
                        player_airTank.put(uuidEntity, air - 1);
                    }
                }
            } else if (hasValidSetup) {
                entity_airBlock.put(uuidEntity, 300);
            } else {
                entity_airBlock.put(uuidEntity, 0);
                entityLivingBase.func_70097_a((DamageSource)WarpDrive.damageAsphyxia, 2.0f);
            }
        }
    }

    private static int consumeAir(EntityLivingBase entityLivingBase) {
        Item itemChestplate;
        ItemStack itemStackChestplate;
        IAirContainerItem airContainerItem;
        int airAvailable;
        ItemStack itemStack;
        ItemStack itemStack2;
        int slotIndex;
        if (WarpDriveConfig.LOGGING_BREATHING) {
            WarpDrive.logger.info("Checking inventory for air reserves...");
        }
        if (!(entityLivingBase instanceof EntityPlayerMP)) {
            return 0;
        }
        EntityPlayerMP entityPlayer = (EntityPlayerMP)entityLivingBase;
        NonNullList playerInventory = entityPlayer.field_71071_by.field_70462_a;
        int slotAirCanisterFound = -1;
        float fillingRatioAirCanisterFound = 0.0f;
        for (slotIndex = 0; slotIndex < playerInventory.size(); ++slotIndex) {
            IAirContainerItem airContainerItem2;
            int airAvailable2;
            itemStack2 = (ItemStack)playerInventory.get(slotIndex);
            if (itemStack2 == ItemStack.field_190927_a || itemStack2.func_190916_E() <= 0 || !(itemStack2.func_77973_b() instanceof IAirContainerItem) || (airAvailable2 = (airContainerItem2 = (IAirContainerItem)itemStack2.func_77973_b()).getCurrentAirStorage(itemStack2)) <= 0) continue;
            float fillingRatio = (float)airAvailable2 / (float)airContainerItem2.getMaxAirStorage(itemStack2);
            fillingRatio -= (float)itemStack2.func_190916_E() / 1000.0f;
            if (!(fillingRatioAirCanisterFound <= 0.0f) && !(fillingRatio < fillingRatioAirCanisterFound)) continue;
            slotAirCanisterFound = slotIndex;
            fillingRatioAirCanisterFound = fillingRatio;
        }
        if (slotAirCanisterFound >= 0 && !(itemStack = (ItemStack)playerInventory.get(slotAirCanisterFound)).func_190926_b() && itemStack.func_77973_b() instanceof IAirContainerItem && (airAvailable = (airContainerItem = (IAirContainerItem)itemStack.func_77973_b()).getCurrentAirStorage(itemStack)) > 0) {
            if (itemStack.func_190916_E() > 1) {
                itemStack.func_190918_g(1);
                ItemStack itemStackToAdd = itemStack.func_77946_l();
                itemStackToAdd.func_190920_e(1);
                itemStackToAdd = airContainerItem.consumeAir(itemStackToAdd);
                if (!entityPlayer.field_71071_by.func_70441_a(itemStackToAdd)) {
                    EntityItem entityItem = new EntityItem(entityPlayer.field_70170_p, entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, itemStackToAdd);
                    entityPlayer.field_70170_p.func_72838_d((Entity)entityItem);
                }
                entityPlayer.func_71120_a(entityPlayer.field_71069_bz);
            } else {
                ItemStack itemStackNew = airContainerItem.consumeAir(itemStack);
                if (itemStack != itemStackNew) {
                    playerInventory.set(slotAirCanisterFound, (Object)itemStackNew);
                }
            }
            return airContainerItem.getAirTicksPerConsumption(itemStack);
        }
        if (WarpDriveConfig.IC2_compressedAir != null) {
            for (slotIndex = 0; slotIndex < playerInventory.size(); ++slotIndex) {
                itemStack2 = (ItemStack)playerInventory.get(slotIndex);
                if (itemStack2.func_190926_b() || !WarpDriveConfig.isIC2CompressedAir(itemStack2)) continue;
                itemStack2.func_190918_g(1);
                playerInventory.set(slotIndex, (Object)itemStack2);
                if (WarpDriveConfig.IC2_emptyCell != null) {
                    ItemStack emptyCell = new ItemStack(WarpDriveConfig.IC2_emptyCell.func_77973_b(), 1, 0);
                    if (!entityPlayer.field_71071_by.func_70441_a(emptyCell)) {
                        World world = entityPlayer.field_70170_p;
                        EntityItem entityItem = new EntityItem(world, entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, emptyCell);
                        entityPlayer.field_70170_p.func_72838_d((Entity)entityItem);
                    }
                    entityPlayer.func_71120_a(entityPlayer.field_71069_bz);
                }
                return 300;
            }
        }
        if (!(itemStackChestplate = entityLivingBase.func_184582_a(EntityEquipmentSlot.CHEST)).func_190926_b() && (itemChestplate = itemStackChestplate.func_77973_b()) == WarpDrive.itemWarpArmor[EnumTier.SUPERIOR.getIndex()][2]) {
            return BreathingManager.electrolyseIceToAir((Entity)entityLivingBase);
        }
        return 0;
    }

    public static boolean hasValidSetup(@Nonnull EntityLivingBase entityLivingBase) {
        ItemStack itemStackHelmet = entityLivingBase.func_184582_a(EntityEquipmentSlot.HEAD);
        if (entityLivingBase instanceof EntityPlayer) {
            ItemStack itemStackChestplate = entityLivingBase.func_184582_a(EntityEquipmentSlot.CHEST);
            ItemStack itemStackLeggings = entityLivingBase.func_184582_a(EntityEquipmentSlot.LEGS);
            ItemStack itemStackBoots = entityLivingBase.func_184582_a(EntityEquipmentSlot.FEET);
            if (!(itemStackHelmet.func_190926_b() || itemStackChestplate.func_190926_b() || itemStackLeggings.func_190926_b() || itemStackBoots.func_190926_b())) {
                Item itemHelmet = itemStackHelmet.func_77973_b();
                return itemHelmet instanceof IBreathingHelmet && ((IBreathingHelmet)itemHelmet).canBreath(entityLivingBase) || Dictionary.ITEMS_BREATHING_HELMET.contains(itemHelmet);
            }
        } else if (!itemStackHelmet.func_190926_b()) {
            Item itemHelmet = itemStackHelmet.func_77973_b();
            return itemHelmet instanceof IBreathingHelmet && ((IBreathingHelmet)itemHelmet).canBreath(entityLivingBase) || Dictionary.ITEMS_BREATHING_HELMET.contains(itemHelmet);
        }
        return false;
    }

    public static float getAirReserveRatio(@Nonnull EntityPlayer entityPlayer) {
        Item itemChestplate;
        NonNullList playerInventory = entityPlayer.field_71071_by.field_70462_a;
        boolean canElectrolyse = false;
        ItemStack itemStackChestplate = entityPlayer.func_184582_a(EntityEquipmentSlot.CHEST);
        if (!itemStackChestplate.func_190926_b() && (itemChestplate = itemStackChestplate.func_77973_b()) == WarpDrive.itemWarpArmor[EnumTier.SUPERIOR.getIndex()][2]) {
            canElectrolyse = true;
        }
        Item itemIce = Item.func_150898_a((Block)Blocks.field_150432_aD);
        int sumAirCapacityTicks = 0;
        int sumAirStoredTicks = 0;
        int countAirContainer = 0;
        int countIce = 0;
        int countEnergy = 0;
        ItemStack itemStackAirContainer = null;
        for (ItemStack itemStack : playerInventory) {
            if (itemStack.func_190926_b()) continue;
            if (itemStack.func_77973_b() instanceof IAirContainerItem) {
                ++countAirContainer;
                itemStackAirContainer = itemStack;
                IAirContainerItem airContainerItem = (IAirContainerItem)itemStack.func_77973_b();
                int airAvailable = airContainerItem.getCurrentAirStorage(itemStack);
                if (airAvailable > 0) {
                    sumAirStoredTicks += airAvailable * airContainerItem.getAirTicksPerConsumption(itemStack);
                }
                int airCapacity = airContainerItem.getMaxAirStorage(itemStack);
                sumAirCapacityTicks += airCapacity * airContainerItem.getAirTicksPerConsumption(itemStack);
                continue;
            }
            if (WarpDriveConfig.IC2_compressedAir != null && WarpDriveConfig.isIC2CompressedAir(itemStack)) {
                sumAirStoredTicks += 300 * itemStack.func_190916_E();
                sumAirCapacityTicks += 300 * itemStack.func_190916_E();
                continue;
            }
            if (WarpDriveConfig.IC2_emptyCell != null && itemStack.func_77969_a(WarpDriveConfig.IC2_emptyCell)) {
                sumAirCapacityTicks += 300 * itemStack.func_190916_E();
                continue;
            }
            if (!canElectrolyse) continue;
            if (itemStack.func_77973_b() == itemIce) {
                countIce += itemStack.func_190916_E();
                continue;
            }
            if (!EnergyWrapper.isEnergyContainer(itemStack) || !EnergyWrapper.canOutput(itemStack) || EnergyWrapper.getEnergyStored(itemStack) < 2000L) continue;
            countEnergy = (int)((long)countEnergy + EnergyWrapper.getEnergyStored(itemStack) / 2000L);
        }
        if (countAirContainer >= 1 && countIce > 0 && countEnergy > 0 && itemStackAirContainer.func_77973_b() instanceof IAirContainerItem) {
            IAirContainerItem airContainerItem = (IAirContainerItem)itemStackAirContainer.func_77973_b();
            int sumElectrolyseTicks = Math.min(2, countAirContainer) * Math.min(countIce, countEnergy) * airContainerItem.getMaxAirStorage(itemStackAirContainer) * airContainerItem.getAirTicksPerConsumption(itemStackAirContainer);
            sumAirStoredTicks += sumElectrolyseTicks;
            sumAirCapacityTicks += sumElectrolyseTicks;
        }
        return sumAirCapacityTicks > 0 ? (float)sumAirStoredTicks / (float)sumAirCapacityTicks : 0.0f;
    }

    private static int electrolyseIceToAir(Entity entity) {
        if (WarpDriveConfig.LOGGING_BREATHING) {
            WarpDrive.logger.info("Checking inventory for ice electrolysing...");
        }
        if (!(entity instanceof EntityPlayerMP)) {
            return 0;
        }
        EntityPlayerMP entityPlayer = (EntityPlayerMP)entity;
        NonNullList playerInventory = entityPlayer.field_71071_by.field_70462_a;
        int slotIceFound = -1;
        int slotFirstEmptyAirContainerFound = -1;
        int slotSecondEmptyAirContainerFound = -1;
        int slotEnergyContainer = -1;
        Item itemIce = Item.func_150898_a((Block)Blocks.field_150432_aD);
        for (int slotIndex = 0; slotIndex < playerInventory.size(); ++slotIndex) {
            ItemStack itemStack = (ItemStack)playerInventory.get(slotIndex);
            if (itemStack.func_190926_b()) continue;
            if (itemStack.func_77973_b() == itemIce) {
                slotIceFound = slotIndex;
                if (slotSecondEmptyAirContainerFound < 0 || slotEnergyContainer < 0) continue;
                break;
            }
            if (itemStack.func_190916_E() == 1 && itemStack.func_77973_b() instanceof IAirContainerItem) {
                IAirContainerItem airCanister = (IAirContainerItem)itemStack.func_77973_b();
                if (!airCanister.canContainAir(itemStack) || airCanister.getCurrentAirStorage(itemStack) < 0) continue;
                if (slotFirstEmptyAirContainerFound < 0) {
                    slotFirstEmptyAirContainerFound = slotIndex;
                    continue;
                }
                if (slotSecondEmptyAirContainerFound >= 0) continue;
                slotSecondEmptyAirContainerFound = slotIndex;
                if (slotIceFound < 0 || slotEnergyContainer < 0) continue;
                break;
            }
            if (slotEnergyContainer >= 0 || !EnergyWrapper.isEnergyContainer(itemStack) || !EnergyWrapper.canOutput(itemStack) || EnergyWrapper.getEnergyStored(itemStack) < 2000L) continue;
            slotEnergyContainer = slotIndex;
            if (slotIceFound >= 0 && slotSecondEmptyAirContainerFound >= 0) break;
        }
        if (slotEnergyContainer < 0 || slotIceFound < 0 || slotFirstEmptyAirContainerFound < 0) {
            return 0;
        }
        ItemStack itemStackEnergyContainer = (ItemStack)playerInventory.get(slotEnergyContainer);
        int energyProvided = EnergyWrapper.consume(itemStackEnergyContainer, 2000, false);
        if (energyProvided <= 0) {
            return 0;
        }
        ItemStack itemStackIce = (ItemStack)playerInventory.get(slotIceFound);
        itemStackIce.func_190918_g(1);
        playerInventory.set(slotIceFound, (Object)itemStackIce);
        ItemStack itemStackAirCanister = (ItemStack)playerInventory.get(slotFirstEmptyAirContainerFound);
        IAirContainerItem airCanister = (IAirContainerItem)itemStackAirCanister.func_77973_b();
        playerInventory.set(slotFirstEmptyAirContainerFound, (Object)airCanister.getFullAirContainer(itemStackAirCanister));
        if (slotSecondEmptyAirContainerFound >= 0) {
            itemStackAirCanister = (ItemStack)playerInventory.get(slotSecondEmptyAirContainerFound);
            airCanister = (IAirContainerItem)itemStackAirCanister.func_77973_b();
            playerInventory.set(slotSecondEmptyAirContainerFound, (Object)airCanister.getFullAirContainer(itemStackAirCanister));
        }
        entityPlayer.func_71120_a(entityPlayer.field_71069_bz);
        return airCanister.getAirTicksPerConsumption(itemStackAirCanister);
    }

    public static void onEntityLivingDeath(@Nonnull EntityLivingBase entityLivingBase) {
        entity_airBlock.remove(entityLivingBase.func_110124_au());
    }
}

