/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive;

import com.mojang.authlib.GameProfile;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IGlobalRegionProvider;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.BlockStatePos;
import cr0s.warpdrive.data.GlobalPosition;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.event.ChunkHandler;
import cr0s.warpdrive.world.SpaceTeleporter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.CommandException;
import net.minecraft.command.EntitySelector;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class Commons {
    private static final String CHAR_FORMATTING = "\u00a7";
    private static final List<EnumBlockRenderType> ALLOWED_RENDER_TYPES = Arrays.asList(EnumBlockRenderType.INVISIBLE, EnumBlockRenderType.ENTITYBLOCK_ANIMATED, EnumBlockRenderType.MODEL);
    private static final ExecutorService THREAD_POOL = new ThreadPoolExecutor(0, 2, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
    private static final CopyOnWriteArraySet<UUID> uuidGameProfileFilling = new CopyOnWriteArraySet();
    private static Method methodThrowable_getStackTraceElement;
    public static final EnumFacing[] FACINGS_VERTICAL;
    public static final VectorI[] DIRECTIONS_UP_CONE;
    public static final VectorI[] DIRECTIONS_HORIZONTAL;
    public static final VectorI[] DIRECTIONS_VERTICAL;
    public static final VectorI[] DIRECTIONS_ANY;
    private static final ConcurrentHashMap<String, Long> throttle_timePreviousForKey_ms;
    private static long dumpAllThreads_lastDump_ms;
    private static final double BLOCK_REACH_DISTANCE = 5.0;
    private static HashMap<String, Fluid> fluidByBlockName;

    @Nonnull
    public static String updateEscapeCodes(@Nonnull String message) {
        return message.replace("\u00c2\u00a7", CHAR_FORMATTING).replace("\\n", "\n").replace("\u00a7r", "\u00a77").replaceAll("\u00a0", " ");
    }

    @Nonnull
    public static String removeFormatting(@Nonnull String message) {
        return Commons.updateEscapeCodes(message).replaceAll("(\u00a7.)", "");
    }

    private static boolean isFormatColor(char chr) {
        return chr >= '0' && chr <= '9' || chr >= 'a' && chr <= 'f' || chr >= 'A' && chr <= 'F';
    }

    private static boolean isFormatSpecial(char chr) {
        return chr >= 'k' && chr <= 'o' || chr >= 'K' && chr <= 'O' || chr == 'r' || chr == 'R';
    }

    @Nonnull
    private static String getFormatFromString(@Nonnull String message) {
        int indexLastChar = message.length() - 1;
        StringBuilder result = new StringBuilder();
        int indexEscapeCode = -1;
        while ((indexEscapeCode = message.indexOf(167, indexEscapeCode + 1)) != -1) {
            if (indexEscapeCode >= indexLastChar) continue;
            char chr = message.charAt(indexEscapeCode + 1);
            if (Commons.isFormatColor(chr)) {
                result = new StringBuilder(CHAR_FORMATTING + chr);
                continue;
            }
            if (!Commons.isFormatSpecial(chr)) continue;
            result.append(CHAR_FORMATTING).append(chr);
        }
        return result.toString();
    }

    @Nonnull
    public static Style getStyleCommand() {
        return new Style().func_150238_a(TextFormatting.AQUA);
    }

    @Nonnull
    public static Style getStyleHeader() {
        return new Style().func_150238_a(TextFormatting.GOLD);
    }

    @Nonnull
    public static Style getStyleCorrect() {
        return new Style().func_150238_a(TextFormatting.GREEN);
    }

    @Nonnull
    public static Style getStyleDisabled() {
        return new Style().func_150238_a(TextFormatting.GRAY);
    }

    @Nonnull
    public static Style getStyleNormal() {
        return new Style().func_150238_a(TextFormatting.WHITE);
    }

    @Nonnull
    public static Style getStyleValue() {
        return new Style().func_150238_a(TextFormatting.YELLOW);
    }

    @Nonnull
    public static Style getStyleVoltage() {
        return new Style().func_150238_a(TextFormatting.DARK_GREEN);
    }

    @Nonnull
    public static Style getStyleWarning() {
        return new Style().func_150238_a(TextFormatting.RED);
    }

    @Nonnull
    public static WarpDriveText getChatPrefix(@Nonnull Block block) {
        return Commons.getChatPrefix(block.func_149739_a() + ".name");
    }

    @Nonnull
    public static WarpDriveText getChatPrefix(@Nonnull ItemStack itemStack) {
        return Commons.getChatPrefix(itemStack.func_77977_a() + ".name");
    }

    @Nonnull
    public static WarpDriveText getChatPrefix(@Nonnull String translationKey) {
        return new WarpDriveText(Commons.getStyleHeader(), "warpdrive.guide.prefix", new TextComponentTranslation(translationKey, new Object[0]));
    }

    @Nonnull
    public static WarpDriveText getNamedPrefix(@Nonnull String name) {
        return new WarpDriveText(Commons.getStyleHeader(), "warpdrive.guide.prefix", new TextComponentString(name));
    }

    @Nonnull
    public static WarpDriveText getChatValue(boolean bool) {
        if (bool) {
            return new WarpDriveText(Commons.getStyleCorrect(), "true", new Object[0]);
        }
        return new WarpDriveText(Commons.getStyleWarning(), "false", new Object[0]);
    }

    @Nonnull
    public static WarpDriveText getChatValue(int value) {
        return new WarpDriveText(Commons.getStyleValue(), "%s", value);
    }

    @Nonnull
    public static WarpDriveText getChatValue(@Nonnull String value) {
        if (value.equals("???")) {
            return new WarpDriveText(Commons.getStyleDisabled(), "???", new Object[0]);
        }
        return new WarpDriveText(Commons.getStyleValue(), "%s", value);
    }

    public static void addChatMessage(ICommandSender commandSender, @Nonnull ITextComponent textComponent) {
        String message = textComponent.func_150254_d();
        if (commandSender == null) {
            WarpDrive.logger.error(String.format("Unable to send message to NULL sender: %s", message));
            return;
        }
        if (message.isEmpty()) {
            return;
        }
        String[] lines = Commons.updateEscapeCodes(message).split("\n");
        if (lines.length == 1) {
            commandSender.func_145747_a(textComponent);
        } else {
            String formatNextLine = "";
            for (String line : lines) {
                commandSender.func_145747_a((ITextComponent)new TextComponentString(formatNextLine + line));
                for (int index = 0; index < line.length(); ++index) {
                    char charFormat;
                    if (line.charAt(index) != '\u00a7' || index + 1 >= line.length()) continue;
                    formatNextLine = (charFormat = line.charAt(++index)) == 'r' ? CHAR_FORMATTING + charFormat : formatNextLine + CHAR_FORMATTING + charFormat;
                }
            }
        }
    }

    private static String getComparableTooltipLine(String line) {
        String lineCleaned = Commons.removeFormatting(line).toLowerCase().replace("-", " ").replace(".", " ").replace(",", " ").replace(":", " ").replace(";", " ").replace("  ", " ").trim();
        if (lineCleaned.startsWith("- ")) {
            lineCleaned = lineCleaned.substring(2).trim();
        }
        if (lineCleaned.endsWith(":")) {
            lineCleaned = lineCleaned.substring(0, lineCleaned.length() - 1).trim();
        }
        return lineCleaned;
    }

    public static void addTooltip(List<String> list, @Nonnull String tooltip) {
        String[] lines;
        if (tooltip.isEmpty()) {
            return;
        }
        for (String line : lines = Commons.updateEscapeCodes(tooltip).split("\n")) {
            boolean isExisting = false;
            String cleanToAdd = Commons.getComparableTooltipLine(line);
            for (String lineExisting : list) {
                String cleanExisting = Commons.getComparableTooltipLine(lineExisting);
                if (!cleanExisting.equals(cleanToAdd)) continue;
                isExisting = true;
                break;
            }
            if (isExisting) continue;
            String lineRemaining = line;
            String formatNextLine = "";
            while (!lineRemaining.isEmpty()) {
                int indexToCut;
                int displayLength = 0;
                int length = lineRemaining.length();
                for (indexToCut = formatNextLine.length(); indexToCut < length && displayLength <= 38; ++indexToCut) {
                    if (lineRemaining.charAt(indexToCut) == '\u00a7' && indexToCut + 1 < length) {
                        ++indexToCut;
                        continue;
                    }
                    ++displayLength;
                }
                if (indexToCut < length) {
                    if ((indexToCut = lineRemaining.substring(0, indexToCut).lastIndexOf(32)) == -1 || indexToCut == 0) {
                        list.add(lineRemaining);
                        lineRemaining = "";
                        continue;
                    }
                    list.add(lineRemaining.substring(0, indexToCut).replaceAll("\u00a0", " "));
                    for (int index = formatNextLine.length(); index <= indexToCut; ++index) {
                        if (lineRemaining.charAt(index) != '\u00a7' || index + 1 >= indexToCut) continue;
                        formatNextLine = formatNextLine + CHAR_FORMATTING + lineRemaining.charAt(++index);
                    }
                    lineRemaining = formatNextLine + lineRemaining.substring(indexToCut + 1);
                    continue;
                }
                list.add(lineRemaining.replaceAll("\u00a0", " "));
                lineRemaining = "";
            }
        }
    }

    public static boolean isKeyPressed(@Nonnull KeyBinding keyBinding) {
        try {
            int keyCode = keyBinding.func_151463_i();
            return keyCode < 0 ? Mouse.isButtonDown((int)(keyCode + 100)) : Keyboard.isKeyDown((int)keyCode);
        }
        catch (Exception exception) {
            if (Commons.throttleMe(keyBinding.getDisplayName())) {
                exception.printStackTrace();
                WarpDrive.logger.error(String.format("Exception trying to get key pressed status for %s", keyBinding.getDisplayName()));
            }
            return false;
        }
    }

    public static Field getField(Class<?> clazz, String deobfuscatedName, String obfuscatedName) {
        Field fieldToReturn = null;
        try {
            fieldToReturn = clazz.getDeclaredField(deobfuscatedName);
        }
        catch (Exception exception1) {
            try {
                fieldToReturn = clazz.getDeclaredField(obfuscatedName);
            }
            catch (Exception exception2) {
                exception2.printStackTrace(WarpDrive.printStreamError);
                StringBuilder map = new StringBuilder();
                for (Field fieldDeclared : clazz.getDeclaredFields()) {
                    if (map.length() > 0) {
                        map.append(", ");
                    }
                    map.append(fieldDeclared.getName());
                }
                WarpDrive.logger.error(String.format("Unable to find %1$s field in %2$s class. Available fields are: %3$s", deobfuscatedName, clazz.toString(), map.toString()));
            }
        }
        if (fieldToReturn != null) {
            fieldToReturn.setAccessible(true);
        }
        return fieldToReturn;
    }

    public static String format(long value) {
        return String.format("%,d", Math.round(value));
    }

    @Nonnull
    public static String format(Object[] arguments) {
        StringBuilder result = new StringBuilder();
        if (arguments != null && arguments.length > 0) {
            for (Object argument : arguments) {
                if (result.length() > 0) {
                    result.append(", ");
                }
                if (argument instanceof String) {
                    result.append("\"").append(argument).append("\"");
                    continue;
                }
                result.append(argument);
            }
        }
        return result.toString();
    }

    @Nonnull
    public static String formatHexadecimal(int[] ints) {
        StringBuilder result = new StringBuilder();
        if (ints != null && ints.length > 0) {
            for (int value : ints) {
                if (result.length() > 0) {
                    result.append(", ");
                }
                result.append(String.format("0x%8x", value));
            }
        }
        return result.toString();
    }

    @Nonnull
    public static String format(World world) {
        String saveFolder;
        if (world == null) {
            return "~NULL~";
        }
        try {
            saveFolder = world.field_73011_w.getSaveFolder();
        }
        catch (Exception exception) {
            exception.printStackTrace(WarpDrive.printStreamError);
            saveFolder = "<Exception DIM" + world.field_73011_w.getDimension() + ">";
        }
        if (saveFolder == null || saveFolder.isEmpty()) {
            int dimension = world.field_73011_w.getDimension();
            if (dimension != 0) {
                assert (false);
                return String.format("~invalid dimension %d~", dimension);
            }
            String worldName = world.func_72912_H().func_76065_j();
            if (worldName.equals("MpServer")) {
                return "overworld";
            }
            return worldName;
        }
        return saveFolder;
    }

    public static String format(IBlockAccess blockAccess, @Nonnull BlockPos blockPos) {
        if (blockAccess instanceof World) {
            return Commons.format((World)blockAccess, blockPos);
        }
        return String.format("@ %s (%d %d %d)", blockAccess, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }

    public static String format(World world, @Nonnull BlockPos blockPos) {
        return Commons.format(world, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }

    public static String format(World world, int x, int y, int z) {
        return String.format("@ %s (%d %d %d)", Commons.format(world), x, y, z);
    }

    public static String format(World world, @Nonnull Vector3 vector3) {
        return Commons.format(world, vector3.x, vector3.y, vector3.z);
    }

    public static String format(World world, double x, double y, double z) {
        return String.format("@ %s (%.2f %.2f %.2f)", Commons.format(world), x, y, z);
    }

    public static String format(@Nonnull Entity entity) {
        if (entity.field_70170_p != null) {
            return Commons.format(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        }
        return String.format("@ DIM%d (%.2f %.2f %.2f)", entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public static String format(@Nonnull GlobalPosition globalPosition) {
        return String.format("@ DIM%d (%d %d %d)", globalPosition.dimensionId, globalPosition.x, globalPosition.y, globalPosition.z);
    }

    public static String format(@Nonnull ItemStack itemStack) {
        String stringNBT = itemStack.func_77942_o() ? " " + itemStack.func_77978_p() : "";
        return String.format("%dx%s@%d (%s)%s", itemStack.func_190916_E(), itemStack.func_77973_b().getRegistryName(), itemStack.func_77952_i(), itemStack.func_82833_r(), stringNBT);
    }

    public static String format(@Nonnull IBlockState blockState, @Nonnull World world, @Nonnull BlockPos blockPos) {
        Block block = blockState.func_177230_c();
        try {
            ItemStack itemStack = block.getPickBlock(blockState, null, world, blockPos, null);
            return new WarpDriveText(null, itemStack.func_77977_a() + ".name", new Object[0]).func_150254_d();
        }
        catch (Exception exception1) {
            try {
                return new WarpDriveText(null, block.func_149739_a() + ".name", new Object[0]).func_150254_d();
            }
            catch (Exception exception2) {
                return blockState.toString();
            }
        }
    }

    public static String format(@Nonnull Material material) {
        String name = material.toString();
        try {
            for (Field field : Material.class.getDeclaredFields()) {
                if (field.get(null) != material) continue;
                name = field.getName();
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    @Nonnull
    public static String sanitizeFileName(@Nonnull String name) {
        return name.replace("/", "").replace(".", "").replace(":", "").replace("\\", ".");
    }

    public static ItemStack copyWithSize(@Nonnull ItemStack itemStack, int newSize) {
        ItemStack ret = itemStack.func_77946_l();
        ret.func_190920_e(newSize);
        return ret;
    }

    public static Set<BlockPos> getConnectedBlocks(World world, BlockPos start, VectorI[] directions, Set<Block> whitelist, int maxRange, BlockPos ... ignore) {
        return Commons.getConnectedBlocks(world, Collections.singletonList(start), directions, whitelist, maxRange, ignore);
    }

    public static Set<BlockPos> getConnectedBlocks(World world, Collection<BlockPos> start, VectorI[] directions, Set<Block> whitelist, int maxRange, BlockPos ... ignore) {
        HashSet<BlockPos> toIgnore = new HashSet<BlockPos>();
        if (ignore != null) {
            toIgnore.addAll(Arrays.asList(ignore));
        }
        HashSet<Object> toIterate = new HashSet<BlockPos>(start);
        HashSet<BlockPos> iterated = new HashSet<BlockPos>();
        for (int range = 0; !toIterate.isEmpty() && range < maxRange; ++range) {
            HashSet<BlockPos> toIterateNext = new HashSet<BlockPos>();
            for (BlockPos blockPos : toIterate) {
                IBlockState blockStateCurrent = Commons.getBlockState_noChunkLoading((IBlockAccess)world, blockPos);
                if (blockStateCurrent != null && whitelist.contains(blockStateCurrent.func_177230_c())) {
                    iterated.add(blockPos);
                }
                for (VectorI direction : directions) {
                    IBlockState blockStateNext;
                    BlockPos next = new BlockPos(blockPos.func_177958_n() + direction.x, blockPos.func_177956_o() + direction.y, blockPos.func_177952_p() + direction.z);
                    if (iterated.contains(next) || toIgnore.contains(next) || toIterate.contains(next) || toIterateNext.contains(next) || (blockStateNext = Commons.getBlockState_noChunkLoading((IBlockAccess)world, next)) == null || !whitelist.contains(blockStateNext.func_177230_c())) continue;
                    toIterateNext.add(next);
                }
            }
            toIterate = toIterateNext;
        }
        return iterated;
    }

    @Nonnull
    public static Set<BlockStatePos> getConnectedBlockStatePos(@Nonnull IBlockAccess blockAccess, @Nonnull Collection<BlockPos> start, @Nonnull VectorI[] directions, @Nonnull Set<Block> blockConnecting, @Nonnull Set<Block> blockResults, int maxRange) {
        HashSet<BlockPos> toIterate = new HashSet<BlockPos>(start.size() * 4);
        HashSet<BlockPos> blockPosIterated = new HashSet<BlockPos>(64);
        HashSet<BlockStatePos> blockStatePosResults = new HashSet<BlockStatePos>(64);
        for (BlockPos blockPos : start) {
            IBlockState blockState = Commons.getBlockState_noChunkLoading(blockAccess, blockPos);
            if (blockState == null) continue;
            toIterate.add(blockPos);
            if (!blockResults.contains(blockState.func_177230_c())) continue;
            blockStatePosResults.add(new BlockStatePos(blockPos, blockState));
        }
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int range = 0; !toIterate.isEmpty() && range < maxRange; ++range) {
            HashSet<BlockPos> toIterateNext = new HashSet<BlockPos>();
            for (BlockPos current : toIterate) {
                for (VectorI direction : directions) {
                    mutableBlockPos.func_181079_c(current.func_177958_n() + direction.x, current.func_177956_o() + direction.y, current.func_177952_p() + direction.z);
                    if (blockPosIterated.contains(mutableBlockPos)) continue;
                    BlockPos blockPosNext = mutableBlockPos.func_185334_h();
                    blockPosIterated.add(blockPosNext);
                    IBlockState blockStateNext = Commons.getBlockState_noChunkLoading(blockAccess, (BlockPos)mutableBlockPos);
                    if (blockStateNext == null) continue;
                    if (blockConnecting.contains(blockStateNext.func_177230_c())) {
                        toIterateNext.add(blockPosNext);
                    }
                    if (!blockResults.contains(blockStateNext.func_177230_c())) continue;
                    blockStatePosResults.add(new BlockStatePos(blockPosNext, blockAccess.func_180495_p(blockPosNext)));
                }
            }
            toIterate = toIterateNext;
        }
        return blockStatePosResults;
    }

    public static String toString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    public static int toInt(double d) {
        return (int)Math.round(d);
    }

    public static int toInt(Object object) {
        return Commons.toInt(Commons.toDouble(object));
    }

    public static double toDouble(Object object) {
        if (object == null) {
            return 0.0;
        }
        assert (!(object instanceof Object[]));
        return Double.parseDouble(object.toString());
    }

    public static float toFloat(Object object) {
        if (object == null) {
            return 0.0f;
        }
        assert (!(object instanceof Object[]));
        return Float.parseFloat(object.toString());
    }

    public static boolean toBool(Object object) {
        if (object == null) {
            return false;
        }
        assert (!(object instanceof Object[]));
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        String string = object.toString();
        return string.equals("true") || string.equals("1.0") || string.equals("1") || string.equals("y") || string.equals("yes");
    }

    public static int clamp(int min, int max, int value) {
        return Math.min(max, Math.max(value, min));
    }

    public static long clamp(long min, long max, long value) {
        return Math.min(max, Math.max(value, min));
    }

    public static float clamp(float min, float max, float value) {
        return Math.min(max, Math.max(value, min));
    }

    public static double clamp(double min, double max, double value) {
        return Math.min(max, Math.max(value, min));
    }

    public static float clampMantisse(float min, float max, float value) {
        return Math.min(max, Math.max(Math.abs(value), min)) * Math.signum(value == 0.0f ? 1.0f : value);
    }

    public static double clampMantisse(double min, double max, double value) {
        return Math.min(max, Math.max(Math.abs(value), min)) * Math.signum(value == 0.0 ? 1.0 : value);
    }

    public static int randomRange(Random random, int min, int max) {
        return min + (max - min > 0 ? random.nextInt(max - min + 1) : 0);
    }

    public static double randomRange(Random random, double min, double max) {
        return min + (max - min > 0.0 ? random.nextDouble() * (max - min) : 0.0);
    }

    public static double interpolate(@Nonnull double[] xValues, @Nonnull double[] yValues, double xInput) {
        if (WarpDrive.isDev) {
            assert (xValues.length == yValues.length);
            assert (xValues.length > 1);
        }
        if (xInput < xValues[0]) {
            return yValues[0];
        }
        for (int index = 0; index < xValues.length - 1; ++index) {
            if (!(xInput < xValues[index + 1])) continue;
            return Commons.interpolate(xValues[index], yValues[index], xValues[index + 1], yValues[index + 1], xInput);
        }
        return yValues[yValues.length - 1];
    }

    public static double interpolate(double xMin, double yMin, double xMax, double yMax, double x) {
        return yMin + (x - xMin) * (yMax - yMin) / (xMax - xMin);
    }

    public static EnumFacing getHorizontalDirectionFromEntity(@Nullable EntityLivingBase entityLiving) {
        if (entityLiving != null) {
            int direction = Math.round(entityLiving.field_70177_z / 90.0f) & 3;
            switch (direction) {
                default: {
                    return EnumFacing.NORTH;
                }
                case 1: {
                    return EnumFacing.EAST;
                }
                case 2: {
                    return EnumFacing.SOUTH;
                }
                case 3: 
            }
            return EnumFacing.WEST;
        }
        return EnumFacing.NORTH;
    }

    public static EnumFacing getFacingFromEntity(@Nullable EntityLivingBase entityLivingBase) {
        if (entityLivingBase != null) {
            EnumFacing facing;
            if (entityLivingBase.field_70125_A > 45.0f) {
                facing = EnumFacing.UP;
            } else if (entityLivingBase.field_70125_A < -45.0f) {
                facing = EnumFacing.DOWN;
            } else {
                int direction = Math.round(entityLivingBase.field_70177_z / 90.0f) & 3;
                switch (direction) {
                    case 0: {
                        facing = EnumFacing.NORTH;
                        break;
                    }
                    case 1: {
                        facing = EnumFacing.EAST;
                        break;
                    }
                    case 2: {
                        facing = EnumFacing.SOUTH;
                        break;
                    }
                    case 3: {
                        facing = EnumFacing.WEST;
                        break;
                    }
                    default: {
                        facing = EnumFacing.NORTH;
                    }
                }
            }
            if (entityLivingBase.func_70093_af()) {
                return facing.func_176734_d();
            }
            return facing;
        }
        return EnumFacing.UP;
    }

    public static boolean throttleMe(String keyword) {
        return Commons.throttleMe(keyword, WarpDriveConfig.LOGGING_THROTTLE_MS);
    }

    public static boolean throttleMe(String keyword, long delay_ms) {
        Long timeLastLog_ms = throttle_timePreviousForKey_ms.getOrDefault(keyword, Long.MIN_VALUE);
        long timeCurrent_ms = System.currentTimeMillis();
        if (timeCurrent_ms > timeLastLog_ms + delay_ms) {
            throttle_timePreviousForKey_ms.put(keyword, timeCurrent_ms);
            return true;
        }
        return false;
    }

    public static boolean isSafeThread() {
        String name = Thread.currentThread().getName();
        return name.equals("Server thread") || name.equals("Client thread");
    }

    public static boolean isClientThread() {
        String name = Thread.currentThread().getName();
        return name.equals("Client thread");
    }

    public static boolean isServerThread() {
        String name = Thread.currentThread().getName();
        return name.equals("Server thread");
    }

    public static void dumpAllThreads() {
        ThreadInfo[] threadInfos;
        long currentTime_ms = System.currentTimeMillis();
        if (dumpAllThreads_lastDump_ms + 1000L >= currentTime_ms) {
            return;
        }
        dumpAllThreads_lastDump_ms = currentTime_ms;
        StringBuilder stringBuilder = new StringBuilder();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo threadInfo : threadInfos = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), 100)) {
            StackTraceElement[] stackTraceElements;
            stringBuilder.append("\n\"");
            stringBuilder.append(threadInfo.getThreadName());
            stringBuilder.append("\"\n\tjava.lang.Thread.State: ");
            stringBuilder.append((Object)threadInfo.getThreadState());
            for (StackTraceElement stackTraceElement : stackTraceElements = threadInfo.getStackTrace()) {
                stringBuilder.append("\n\t\tat ");
                stringBuilder.append(stackTraceElement);
            }
            stringBuilder.append("\n");
        }
        WarpDrive.logger.error(stringBuilder.toString());
    }

    @Nonnull
    public static String getMethodName(int depth) {
        try {
            StackTraceElement stackTraceElement = (StackTraceElement)methodThrowable_getStackTraceElement.invoke((Object)new Throwable(), depth + 1);
            return stackTraceElement.getMethodName();
        }
        catch (Exception exception) {
            exception.printStackTrace(WarpDrive.printStreamError);
            return "-?-";
        }
    }

    public static void writeNBTToFile(@Nonnull String fileName, @Nonnull NBTTagCompound tagCompound) {
        if (WarpDrive.isDev) {
            WarpDrive.logger.debug(String.format("writeNBTToFile %s", fileName));
        }
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream fileoutputstream = new FileOutputStream(file);
            CompressedStreamTools.func_74799_a((NBTTagCompound)tagCompound, (OutputStream)fileoutputstream);
            fileoutputstream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(WarpDrive.printStreamError);
        }
    }

    public static NBTTagCompound readNBTFromFile(@Nonnull String fileName) {
        if (WarpDrive.isDev) {
            WarpDrive.logger.debug(String.format("readNBTFromFile %s", fileName));
        }
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                return null;
            }
            FileInputStream fileinputstream = new FileInputStream(file);
            NBTTagCompound tagCompound = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
            fileinputstream.close();
            return tagCompound;
        }
        catch (Exception exception) {
            exception.printStackTrace(WarpDrive.printStreamError);
            return null;
        }
    }

    public static BlockPos createBlockPosFromNBT(@Nonnull NBTTagCompound tagCompound) {
        int x = tagCompound.func_74762_e("x");
        int y = tagCompound.func_74762_e("y");
        int z = tagCompound.func_74762_e("z");
        return new BlockPos(x, y, z);
    }

    public static NBTTagCompound writeBlockPosToNBT(@Nonnull BlockPos blockPos, @Nonnull NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("x", blockPos.func_177958_n());
        tagCompound.func_74768_a("y", blockPos.func_177956_o());
        tagCompound.func_74768_a("z", blockPos.func_177952_p());
        return tagCompound;
    }

    public static EntityPlayerMP[] getOnlinePlayerByNameOrSelector(@Nonnull ICommandSender commandSender, String playerNameOrSelector) {
        MinecraftServer server = commandSender.func_184102_h();
        assert (server != null);
        List onlinePlayers = server.func_184103_al().func_181057_v();
        for (EntityPlayerMP onlinePlayer : onlinePlayers) {
            if (!onlinePlayer.func_70005_c_().equalsIgnoreCase(playerNameOrSelector)) continue;
            return new EntityPlayerMP[]{onlinePlayer};
        }
        try {
            List entityPlayerMPs_found = EntitySelector.func_179656_b((ICommandSender)commandSender, (String)playerNameOrSelector, EntityPlayerMP.class);
            if (!entityPlayerMPs_found.isEmpty()) {
                return entityPlayerMPs_found.toArray(new EntityPlayerMP[0]);
            }
        }
        catch (CommandException exception) {
            WarpDrive.logger.error(String.format("Exception from %s with selector %s", commandSender, playerNameOrSelector));
        }
        return null;
    }

    @Nullable
    public static EntityPlayerMP getOnlinePlayerByName(String namePlayer) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        assert (server != null);
        return server.func_184103_al().func_152612_a(namePlayer);
    }

    @Nullable
    public static EntityPlayerMP getOnlinePlayerByUUID(@Nonnull UUID uuidPlayer) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        assert (server != null);
        return server.func_184103_al().func_177451_a(uuidPlayer);
    }

    @Nonnull
    public static GameProfile getGameProfile(@Nonnull UUID uuidPlayer, @Nonnull String namePlayer, ProfilePropertiesAvailableCallback profilePropertiesAvailableCallback) {
        GameProfile gameProfileEmpty;
        if (TileEntitySkull.field_184298_j == null || TileEntitySkull.field_184299_k == null) {
            return new GameProfile(uuidPlayer, namePlayer);
        }
        GameProfile gameProfileCached = TileEntitySkull.field_184298_j.func_152652_a(uuidPlayer);
        if (gameProfileCached != null && !gameProfileCached.getProperties().isEmpty()) {
            if (profilePropertiesAvailableCallback != null) {
                profilePropertiesAvailableCallback.profilePropertiesAvailable(gameProfileCached);
            }
            return gameProfileCached;
        }
        GameProfile gameProfile = gameProfileEmpty = gameProfileCached != null ? gameProfileCached : new GameProfile(uuidPlayer, namePlayer);
        if (profilePropertiesAvailableCallback == null || uuidGameProfileFilling.contains(uuidPlayer)) {
            return gameProfileEmpty;
        }
        uuidGameProfileFilling.add(uuidPlayer);
        THREAD_POOL.submit(() -> {
            GameProfile gameProfileFilled = TileEntitySkull.field_184299_k.fillProfileProperties(gameProfileEmpty, true);
            Minecraft.func_71410_x().func_152344_a(() -> {
                if (gameProfileEmpty != gameProfileFilled) {
                    TileEntitySkull.field_184298_j.func_152649_a(gameProfileFilled);
                }
                profilePropertiesAvailableCallback.profilePropertiesAvailable(gameProfileFilled);
                uuidGameProfileFilling.remove(uuidPlayer);
            });
        });
        return gameProfileEmpty;
    }

    public static int colorARGBtoInt(int alpha, int red, int green, int blue) {
        return (Commons.clamp(0, 255, alpha) << 24) + (Commons.clamp(0, 255, red) << 16) + (Commons.clamp(0, 255, green) << 8) + Commons.clamp(0, 255, blue);
    }

    public static void messageToAllPlayersInArea(@Nonnull IGlobalRegionProvider globalRegionProvider, @Nonnull WarpDriveText textComponent) {
        AxisAlignedBB globalRegionArea = globalRegionProvider.getGlobalRegionArea();
        WarpDriveText messagePrefixed = Commons.getNamedPrefix(globalRegionProvider.getSignatureName()).appendSibling(textComponent);
        WarpDrive.logger.info(String.format("%s messageToAllPlayersInArea: %s", globalRegionProvider, textComponent.func_150254_d()));
        WorldServer worldServer = Commons.getOrCreateWorldServer(globalRegionProvider.getDimension());
        for (EntityPlayer entityPlayer : worldServer.field_73010_i) {
            if (!entityPlayer.func_174813_aQ().func_72326_a(globalRegionArea)) continue;
            Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)messagePrefixed);
        }
    }

    public static void moveEntity(@Nonnull Entity entity, @Nonnull World worldDestination, @Nonnull Vector3 v3Destination) {
        if (entity.field_70170_p.field_72995_K) {
            WarpDrive.logger.error(String.format("Skipping remote movement for entity %s destination %s", entity, Commons.format(worldDestination, v3Destination)));
            return;
        }
        if (!entity.func_70089_S()) {
            WarpDrive.logger.warn(String.format("Skipping movement for dead entity %s destination %s", entity, Commons.format(worldDestination, v3Destination)));
            return;
        }
        if (worldDestination != entity.field_70170_p) {
            World worldSource = entity.field_70170_p;
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            WorldServer worldServerFrom = Commons.getOrCreateWorldServer(worldSource.field_73011_w.getDimension());
            WorldServer worldServerTo = Commons.getOrCreateWorldServer(worldDestination.field_73011_w.getDimension());
            SpaceTeleporter teleporter = new SpaceTeleporter(worldServerTo, v3Destination);
            if (entity instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)entity;
                server.func_184103_al().transferPlayerToDimension(player, worldDestination.field_73011_w.getDimension(), (ITeleporter)teleporter);
                player.field_184851_cj = true;
                player.field_71135_a.func_184342_d();
            } else {
                server.func_184103_al().transferEntityToWorld(entity, worldSource.field_73011_w.getDimension(), worldServerFrom, worldServerTo, (ITeleporter)teleporter);
            }
        } else if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            player.func_70634_a(v3Destination.x, v3Destination.y, v3Destination.z);
        } else {
            entity.func_70012_b(v3Destination.x, v3Destination.y, v3Destination.z, entity.field_70177_z, entity.field_70125_A);
            worldDestination.func_72866_a(entity, false);
        }
    }

    public static WorldServer getOrCreateWorldServer(int dimensionId) {
        WorldServer worldServer = DimensionManager.getWorld((int)dimensionId);
        if (worldServer == null) {
            try {
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                worldServer = server.func_71218_a(dimensionId);
                if (worldServer.field_73011_w.getDimension() != dimensionId) {
                    throw new RuntimeException(String.format("Inconsistent dimension id %d, expecting %d", worldServer.field_73011_w.getDimension(), dimensionId));
                }
            }
            catch (Exception exception) {
                WarpDrive.logger.error(String.format("%s: Failed to initialize dimension %d", exception.getMessage(), dimensionId));
                if (WarpDrive.isDev) {
                    exception.printStackTrace(WarpDrive.printStreamError);
                }
                worldServer = null;
            }
        }
        return worldServer;
    }

    public static RayTraceResult getInteractingBlock(@Nonnull World world, @Nonnull EntityPlayer entityPlayer) {
        return Commons.getInteractingBlock(world, entityPlayer, 5.0);
    }

    public static RayTraceResult getInteractingBlock(@Nonnull World world, @Nonnull EntityPlayer entityPlayer, double distance) {
        Vec3d vec3Position = new Vec3d(entityPlayer.field_70165_t, entityPlayer.field_70163_u + (double)entityPlayer.eyeHeight, entityPlayer.field_70161_v);
        Vec3d vec3Look = entityPlayer.func_70676_i(1.0f);
        Vec3d vec3Target = vec3Position.func_72441_c(vec3Look.field_72450_a * distance, vec3Look.field_72448_b * distance, vec3Look.field_72449_c * distance);
        return world.func_147447_a(vec3Position, vec3Target, false, false, true);
    }

    public static Fluid fluid_getByBlock(@Nonnull Block block) {
        if (!(block instanceof BlockLiquid)) {
            WarpDrive.logger.warn(String.format("Invalid lookup for fluid block not derived from BlockLiquid %s", block));
            return null;
        }
        if (fluidByBlockName == null) {
            Map fluidsRegistry = FluidRegistry.getRegisteredFluids();
            HashMap<String, Fluid> map = new HashMap<String, Fluid>(100);
            for (Fluid fluid : fluidsRegistry.values()) {
                Block blockFluid = fluid.getBlock();
                if (blockFluid == null) continue;
                map.put(blockFluid.func_149739_a(), fluid);
            }
            fluidByBlockName = map;
        }
        return fluidByBlockName.get(block.func_149739_a());
    }

    public static EnumFacing getDirection(int index) {
        if (index < 0 || index > 5) {
            return null;
        }
        return EnumFacing.func_82600_a((int)index);
    }

    public static int getOrdinal(@Nullable EnumFacing direction) {
        if (direction == null) {
            return 6;
        }
        return direction.ordinal();
    }

    public static boolean isValidCamouflage(@Nullable IBlockState blockState) {
        if (blockState == null || blockState.func_177230_c() == Blocks.field_150350_a || !ALLOWED_RENDER_TYPES.contains(blockState.func_185901_i()) || Dictionary.BLOCKS_NOCAMOUFLAGE.contains(blockState.func_177230_c())) {
            return false;
        }
        if (blockState instanceof IExtendedBlockState) {
            IExtendedBlockState extendedBlockState = (IExtendedBlockState)blockState;
            if (extendedBlockState.getUnlistedProperties().containsKey((Object)BlockProperties.CAMOUFLAGE)) {
                extendedBlockState.getValue((IUnlistedProperty)BlockProperties.CAMOUFLAGE);
                WarpDrive.logger.error(String.format("Recursive camouflage block detected for block state %s, updating dictionary with %s = NOCAMOUFLAGE to prevent further errors", blockState, blockState.func_177230_c().getRegistryName()));
                Dictionary.BLOCKS_NOCAMOUFLAGE.add(blockState.func_177230_c());
                return false;
            }
            for (IUnlistedProperty property : extendedBlockState.getUnlistedNames()) {
                if (!property.getType().toString().contains("IBlockState")) continue;
                WarpDrive.logger.error(String.format("Suspicious camouflage block detected for block state %s, updating dictionary with %s = NOCAMOUFLAGE to prevent further errors", blockState, blockState.func_177230_c().getRegistryName()));
                Dictionary.BLOCKS_NOCAMOUFLAGE.add(blockState.func_177230_c());
                return false;
            }
        }
        return true;
    }

    public static boolean isChunkLoaded(IBlockAccess blockAccess, int x, int z) {
        if (blockAccess instanceof WorldServer) {
            if (Commons.isSafeThread()) {
                return ChunkHandler.isLoaded((World)((WorldServer)blockAccess), x, 64, z);
            }
            ChunkProviderServer chunkProviderServer = ((WorldServer)blockAccess).func_72863_F();
            Chunk chunk = chunkProviderServer.func_186026_b(x >> 4, z >> 4);
            return chunk != null && chunk.func_177410_o();
        }
        return true;
    }

    public static IBlockState getBlockState_noChunkLoading(@Nullable IBlockAccess blockAccess, @Nonnull BlockPos blockPos) {
        if (blockAccess == null) {
            return null;
        }
        if (!Commons.isChunkLoaded(blockAccess, blockPos.func_177958_n(), blockPos.func_177952_p())) {
            return null;
        }
        return blockAccess.func_180495_p(blockPos);
    }

    public static boolean isReplaceableOreGen(@Nonnull World world, @Nonnull BlockPos blockPos) {
        IBlockState blockStateActual = world.func_180495_p(blockPos);
        Block blockActual = blockStateActual.func_177230_c();
        return blockActual.isReplaceableOreGen(blockStateActual, (IBlockAccess)world, blockPos, blockState -> blockState != null && (blockState.func_177230_c() == Blocks.field_150350_a || blockState.func_177230_c() == Blocks.field_150348_b || blockState.func_177230_c() == Blocks.field_150424_aL || blockState.func_177230_c() == Blocks.field_150377_bs));
    }

    static {
        try {
            methodThrowable_getStackTraceElement = Throwable.class.getDeclaredMethod("getStackTraceElement", Integer.TYPE);
            methodThrowable_getStackTraceElement.setAccessible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace(WarpDrive.printStreamError);
        }
        FACINGS_VERTICAL = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP};
        DIRECTIONS_UP_CONE = new VectorI[]{new VectorI(0, 1, 0), new VectorI(1, 0, 0), new VectorI(0, 0, 1), new VectorI(-1, 0, 0), new VectorI(0, 0, -1), new VectorI(1, 1, 0), new VectorI(0, 1, 1), new VectorI(-1, 1, 0), new VectorI(0, 1, -1), new VectorI(1, 1, 1), new VectorI(-1, 1, 1), new VectorI(-1, 1, -1), new VectorI(1, 1, -1)};
        DIRECTIONS_HORIZONTAL = new VectorI[]{new VectorI(1, 0, 0), new VectorI(0, 0, 1), new VectorI(-1, 0, 0), new VectorI(0, 0, -1)};
        DIRECTIONS_VERTICAL = new VectorI[]{new VectorI(0, -1, 0), new VectorI(0, 1, 0)};
        DIRECTIONS_ANY = new VectorI[]{new VectorI(0, -1, 0), new VectorI(0, 1, 0), new VectorI(1, 0, 0), new VectorI(0, 0, 1), new VectorI(-1, 0, 0), new VectorI(0, 0, -1)};
        throttle_timePreviousForKey_ms = new ConcurrentHashMap(16);
        dumpAllThreads_lastDump_ms = Long.MIN_VALUE;
    }

    public static interface ProfilePropertiesAvailableCallback {
        public void profilePropertiesAvailable(@Nonnull GameProfile var1);
    }
}

