/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.api;

import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.api.computer.IShipController;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class EventWarpDrive
extends Event {
    EventWarpDrive() {
    }

    public static abstract class Ship
    extends EventWarpDrive {
        public final World worldCurrent;
        public final BlockPos posCurrent;
        public final IShipController shipController;
        public final String movementType;

        public Ship(World world, BlockPos blockPos, IShipController shipController, String movementType) {
            this.worldCurrent = world;
            this.posCurrent = blockPos;
            this.shipController = shipController;
            this.movementType = movementType;
        }

        public static class JumpResult
        extends Ship {
            public final boolean isSuccessful;
            public final String reason;

            public JumpResult(World world, BlockPos blockPos, IShipController shipController, String jumpType, boolean isSuccessful, ITextComponent reason) {
                super(world, blockPos, shipController, jumpType);
                this.isSuccessful = isSuccessful;
                this.reason = reason == null ? "" : reason.func_150254_d();
            }
        }

        @Cancelable
        public static class TargetCheck
        extends Ship {
            public final int moveX;
            public final int moveY;
            public final int moveZ;
            public final World worldTarget;
            public final AxisAlignedBB aabbTarget;
            private final WarpDriveText reason;

            public TargetCheck(World worldCurrent, BlockPos blockPos, IShipController shipController, String movementType, int moveX, int moveY, int moveZ, World worldTarget, AxisAlignedBB aabbTarget) {
                super(worldCurrent, blockPos, shipController, movementType);
                this.moveX = moveX;
                this.moveY = moveY;
                this.moveZ = moveZ;
                this.worldTarget = worldTarget;
                this.aabbTarget = aabbTarget;
                this.reason = new WarpDriveText();
            }

            public WarpDriveText getReason() {
                return this.reason;
            }

            public void appendReason(ITextComponent reasonAdded) {
                this.reason.append(reasonAdded);
            }
        }

        @Cancelable
        public static class PreJump
        extends Ship {
            private final WarpDriveText reason = new WarpDriveText();

            public PreJump(World world, BlockPos blockPos, IShipController shipController, String movementType) {
                super(world, blockPos, shipController, movementType);
            }

            public WarpDriveText getReason() {
                return this.reason;
            }

            public void appendReason(ITextComponent reasonAdded) {
                this.reason.append(reasonAdded);
            }
        }

        public static class MovementCosts
        extends Ship {
            public final int mass;
            public final int distance;
            public final int warmup_seconds_initial;
            public final int energyRequired_initial;
            public final int cooldown_seconds_initial;
            public final int sickness_seconds_initial;
            public final int maximumDistance_blocks_initial;
            private int maximumDistance_blocks;
            private int energyRequired;
            private int warmup_seconds;
            private int sickness_seconds;
            private int cooldown_seconds;

            public MovementCosts(World world, BlockPos blockPos, IShipController shipController, String movementType, int mass, int distance, int maximumDistance_blocks, int energyRequired, int warmup_seconds, int sickness_seconds, int cooldown_seconds) {
                super(world, blockPos, shipController, movementType);
                this.mass = mass;
                this.distance = distance;
                this.warmup_seconds_initial = warmup_seconds;
                this.warmup_seconds = warmup_seconds;
                this.energyRequired_initial = energyRequired;
                this.energyRequired = energyRequired;
                this.cooldown_seconds_initial = cooldown_seconds;
                this.cooldown_seconds = cooldown_seconds;
                this.sickness_seconds_initial = sickness_seconds;
                this.sickness_seconds = sickness_seconds;
                this.maximumDistance_blocks_initial = maximumDistance_blocks;
                this.maximumDistance_blocks = maximumDistance_blocks;
            }

            public int getMaximumDistance_blocks() {
                return this.maximumDistance_blocks;
            }

            public void setMaximumDistance_blocks(int maximumDistance_blocks) {
                this.maximumDistance_blocks = maximumDistance_blocks;
            }

            public int getEnergyRequired() {
                return this.energyRequired;
            }

            public void setEnergyRequired(int energyRequired) {
                this.energyRequired = energyRequired;
            }

            public int getWarmup_seconds() {
                return this.warmup_seconds;
            }

            public void setWarmup_seconds(int warmup_seconds) {
                this.warmup_seconds = warmup_seconds;
            }

            public int getSickness_seconds() {
                return this.sickness_seconds;
            }

            public void setSickness_seconds(int sickness_seconds) {
                this.sickness_seconds = sickness_seconds;
            }

            public int getCooldown_seconds() {
                return this.cooldown_seconds;
            }

            public void setCooldown_seconds(int cooldown_seconds) {
                this.cooldown_seconds = cooldown_seconds;
            }
        }
    }
}

