/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.api;

import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IBlockTransformer {
    public boolean isApplicable(Block var1, int var2, TileEntity var3);

    public boolean isJumpReady(Block var1, int var2, TileEntity var3, WarpDriveText var4);

    public NBTBase saveExternals(World var1, int var2, int var3, int var4, Block var5, int var6, TileEntity var7);

    public void removeExternals(World var1, int var2, int var3, int var4, Block var5, int var6, TileEntity var7);

    public int rotate(Block var1, int var2, NBTTagCompound var3, ITransformation var4);

    public void restoreExternals(World var1, BlockPos var2, IBlockState var3, TileEntity var4, ITransformation var5, NBTBase var6);

    public static Block getBlockOrThrowException(String blockId) {
        ResourceLocation resourceLocation = new ResourceLocation(blockId);
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)resourceLocation);
        if (block == Blocks.field_150350_a) {
            throw new RuntimeException(String.format("Invalid %s version, please report to mod author, %s is missing", resourceLocation.func_110624_b(), blockId));
        }
        return block;
    }

    public static int rotateFirstEnumFacingProperty(@Nonnull Block block, int metadata, byte rotationSteps) {
        IBlockState blockState = block.func_176203_a(metadata);
        PropertyEnum propertyFacing = null;
        for (IProperty propertyKey : blockState.func_177227_a()) {
            if (!(propertyKey instanceof PropertyEnum) || propertyKey.func_177699_b() != EnumFacing.class) continue;
            propertyFacing = (PropertyEnum)propertyKey;
            break;
        }
        if (propertyFacing != null) {
            EnumFacing facingNew;
            EnumFacing facingOld = (EnumFacing)blockState.func_177229_b(propertyFacing);
            if (facingOld == EnumFacing.DOWN || facingOld == EnumFacing.UP) {
                return metadata;
            }
            switch (rotationSteps) {
                case 1: {
                    facingNew = facingOld.func_176746_e();
                    break;
                }
                case 2: {
                    facingNew = facingOld.func_176746_e().func_176746_e();
                    break;
                }
                case 3: {
                    facingNew = facingOld.func_176746_e().func_176746_e().func_176746_e();
                    break;
                }
                default: {
                    facingNew = facingOld;
                }
            }
            IBlockState blockStateNew = blockState.func_177226_a((IProperty)propertyFacing, (Comparable)facingNew);
            return block.func_176201_c(blockStateNew);
        }
        return metadata;
    }
}

