/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.api;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.data.Vector3;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.item.EnumRarity;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Particle {
    protected final String registryName;
    protected int color;
    protected int colorIndex;
    protected IRarity rarity = EnumRarity.COMMON;
    private int entityLifespan;
    private float radiationLevel = 0.0f;
    private float explosionStrength = 0.0f;

    public Particle(String registryName) {
        this.registryName = registryName.toLowerCase(Locale.ENGLISH);
    }

    public Particle setRarity(@Nonnull IRarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public Particle setColorIndex(int colorIndex) {
        this.colorIndex = Commons.clamp(0, 4, colorIndex);
        return this;
    }

    public Particle setColor(int colorIndex) {
        this.color = Commons.clamp(0, 0xFFFFFF, colorIndex);
        return this;
    }

    public Particle setColor(int red, int green, int blue) {
        this.color = (Commons.clamp(0, 255, red) << 16) + (Commons.clamp(0, 255, green) << 8) + Commons.clamp(0, 255, blue);
        return this;
    }

    public Particle setEntityLifespan(int entityLifespan) {
        this.entityLifespan = entityLifespan;
        return this;
    }

    public Particle setRadiationLevel(float radiationLevel) {
        this.radiationLevel = radiationLevel;
        return this;
    }

    public Particle setExplosionStrength(float explosionStrength) {
        this.explosionStrength = explosionStrength;
        return this;
    }

    public final String getRegistryName() {
        return this.registryName;
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedName() {
        String unlocalizedName = this.getTranslationKey();
        return unlocalizedName == null ? "" : new TextComponentTranslation(unlocalizedName + ".name", new Object[0]).func_150254_d();
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedTooltip() {
        String unlocalizedName = this.getTranslationKey();
        return unlocalizedName == null ? "" : new TextComponentTranslation(unlocalizedName + ".tooltip", new Object[0]).func_150254_d();
    }

    public String getTranslationKey() {
        return "warpdrive.particle." + this.registryName;
    }

    @Nonnull
    public IRarity getForgeRarity() {
        return this.rarity;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public int getColor() {
        return this.color;
    }

    public int getEntityLifespan() {
        return this.entityLifespan;
    }

    public void onWorldEffect(World world, Vector3 v3Position, int amount) {
        if (world.field_72995_K) {
            return;
        }
        if (this.radiationLevel > 0.0f) {
            float strength = this.radiationLevel * (float)amount / 1000.0f;
            WarpDrive.damageIrradiation.onWorldEffect(world, v3Position, strength);
        }
        if (this.explosionStrength > 0.0f) {
            float amountFactor = Math.max(1.25f, (float)amount / 1000.0f);
            world.func_72885_a(null, v3Position.x, v3Position.y, v3Position.z, this.explosionStrength * amountFactor, true, true);
            WarpDrive.logger.info(String.format("Explosion %s with strength %.3f due to %d mg of %s", Commons.format(world, v3Position), Float.valueOf(this.explosionStrength * amountFactor), amount, this));
        }
    }

    public String toString() {
        return String.format("Particle %s (%s, RGB 0x%x %d, %d ticks, %.3f Sv, strength %.3f)", this.registryName, this.rarity, this.color, this.colorIndex, this.entityLifespan, Float.valueOf(this.radiationLevel), Float.valueOf(this.explosionStrength));
    }
}

