/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cr0s.warpdrive.CommonProxy;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBeamFrequency;
import cr0s.warpdrive.api.IBlockBase;
import cr0s.warpdrive.api.IBlockUpdateDetector;
import cr0s.warpdrive.api.IVideoChannel;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.api.computer.ICoreSignature;
import cr0s.warpdrive.block.TileEntityAbstractMachine;
import cr0s.warpdrive.data.CameraRegistryItem;
import cr0s.warpdrive.data.EnumComponentType;
import cr0s.warpdrive.data.EnumForceFieldUpgrade;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.data.GlobalRegionManager;
import cr0s.warpdrive.item.ItemComponent;
import cr0s.warpdrive.item.ItemForceFieldUpgrade;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.world.World;

public abstract class TileEntityAbstractBase
extends TileEntity
implements IBlockUpdateDetector,
ITickable {
    private boolean isConstructed = false;
    private boolean isFirstTick = true;
    private boolean isDirty = false;
    protected EnumTier enumTier;
    private final HashMap<UpgradeSlot, Integer> upgradeSlots = new HashMap(10);

    public void onLoad() {
        super.onLoad();
        assert (this.func_145830_o() && this.field_174879_c != BlockPos.field_177992_a);
        if (!this.isConstructed) {
            this.onConstructed();
        }
    }

    protected void onConstructed() {
        Block block;
        if (this.field_145850_b == null) {
            return;
        }
        if (WarpDrive.isDev && this instanceof TileEntityAbstractMachine) {
            WarpDrive.logger.info(String.format("%s onConstructed at %d", this, this.field_145850_b.func_72820_D()));
            if (Commons.throttleMe("onConstructed")) {
                new Exception().printStackTrace(WarpDrive.printStreamInfo);
            }
        }
        if ((block = this.func_145838_q()) instanceof IBlockBase) {
            this.enumTier = ((IBlockBase)block).getTier(ItemStack.field_190927_a);
        } else {
            WarpDrive.logger.error(String.format("Invalid block for %s %s: %s", this, Commons.format(this.field_145850_b, this.field_174879_c), block));
            this.enumTier = EnumTier.BASIC;
        }
        this.isConstructed = true;
    }

    public void finishConstruction() {
        if (!this.isConstructed) {
            this.onConstructed();
            if (Commons.throttleMe("finishConstruction")) {
                new RuntimeException(String.format("%s Recovered from missing call to onConstructed", this)).printStackTrace(WarpDrive.printStreamWarn);
            }
        }
    }

    protected void onFirstUpdateTick() {
        assert (this.isConstructed);
        assert (this.enumTier != null);
    }

    public void func_73660_a() {
        if (this.isFirstTick) {
            this.isFirstTick = false;
            this.onFirstUpdateTick();
        }
        if (this.isDirty) {
            this.func_70296_d();
        }
    }

    protected boolean isFirstTick() {
        return this.isFirstTick;
    }

    @Override
    public void onBlockUpdateDetected(@Nonnull BlockPos blockPosUpdated) {
        assert (Commons.isSafeThread());
        if (!this.isConstructed) {
            this.onConstructed();
        }
    }

    public void onBlockBroken(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState) {
    }

    protected <T extends Comparable<T>, V extends T> void updateBlockState(IBlockState blockState_in, IProperty<T> property, V value) {
        IBlockState blockState = blockState_in;
        if (blockState == null) {
            blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        }
        if (property != null) {
            if (!blockState.func_177228_b().containsKey(property)) {
                WarpDrive.logger.error(String.format("Unable to update block state due to missing property in %s: %s calling updateBlockState(%s, %s, %s)", blockState.func_177230_c(), this, blockState_in, property, value));
                return;
            }
            if (blockState.func_177229_b(property) == value) {
                return;
            }
            blockState = blockState.func_177226_a(property, value);
        }
        if (this.func_145832_p() != blockState.func_177230_c().func_176201_c(blockState)) {
            this.field_145850_b.func_180501_a(this.field_174879_c, blockState, 2);
        }
    }

    protected void updateBlockState(IBlockState blockState_in, @Nonnull IBlockState blockState_new) {
        int metadata_new;
        IBlockState blockState_old = blockState_in;
        if (blockState_old == null) {
            blockState_old = this.field_145850_b.func_180495_p(this.field_174879_c);
        }
        Block block_old = blockState_old.func_177230_c();
        Block block_new = blockState_new.func_177230_c();
        if (block_new != block_old) {
            WarpDrive.logger.error(String.format("Unable to update block state from %s to %s: %s calling updateBlockState(%s, %s)", block_old, block_new, this, blockState_in, blockState_new));
            return;
        }
        int metadata_old = block_old.func_176201_c(blockState_old);
        if (metadata_old != (metadata_new = block_new.func_176201_c(blockState_new))) {
            this.field_145850_b.func_180501_a(this.field_174879_c, blockState_new, 2);
        }
    }

    public void func_70296_d() {
        if (this.func_145830_o() && Commons.isSafeThread()) {
            super.func_70296_d();
            this.isDirty = false;
            IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 3);
            GlobalRegionManager.onBlockUpdating(null, this.field_145850_b, this.field_174879_c, blockState);
        } else {
            this.isDirty = true;
        }
    }

    public boolean shouldRefresh(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockStateOld, @Nonnull IBlockState blockStateNew) {
        return blockStateOld.func_177230_c() != blockStateNew.func_177230_c();
    }

    protected boolean isBlockBreakCanceled(UUID uuidPlayer, World world, BlockPos blockPosEvent) {
        return CommonProxy.isBlockBreakCanceled(uuidPlayer, this.field_174879_c, world, blockPosEvent);
    }

    protected boolean isBlockPlaceCanceled(UUID uuidPlayer, World world, BlockPos blockPosEvent, IBlockState blockState) {
        return CommonProxy.isBlockPlaceCanceled(uuidPlayer, this.field_174879_c, world, blockPosEvent, blockState);
    }

    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (tagCompound.func_74764_b("upgrades")) {
            NBTTagCompound nbtTagCompoundUpgrades = tagCompound.func_74775_l("upgrades");
            Set keys = nbtTagCompoundUpgrades.func_150296_c();
            for (String key : keys) {
                UpgradeSlot upgradeSlot = this.getUpgradeSlot(key);
                byte quantity = nbtTagCompoundUpgrades.func_74771_c(key);
                if (upgradeSlot == null) {
                    WarpDrive.logger.error(String.format("Found an unknown upgrade named %s in %s", key, this));
                    upgradeSlot = new UpgradeSlot(key, ItemStack.field_190927_a, 0);
                }
                this.upgradeSlots.put(upgradeSlot, Integer.valueOf(quantity));
            }
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        if ((tagCompound = super.func_189515_b(tagCompound)).func_74775_l("ForgeCaps").func_82582_d()) {
            tagCompound.func_82580_o("ForgeCaps");
        }
        if (!this.upgradeSlots.isEmpty()) {
            NBTTagCompound nbtTagCompoundUpgrades = new NBTTagCompound();
            for (Map.Entry<UpgradeSlot, Integer> entry : this.upgradeSlots.entrySet()) {
                if (entry.getValue() == 0) continue;
                String key = entry.getKey().toString();
                nbtTagCompoundUpgrades.func_74774_a(key, (byte)entry.getValue().intValue());
            }
            if (!nbtTagCompoundUpgrades.func_82582_d()) {
                tagCompound.func_74782_a("upgrades", (NBTBase)nbtTagCompoundUpgrades);
            }
        }
        return tagCompound;
    }

    public NBTTagCompound writeItemDropNBT(NBTTagCompound tagCompound) {
        this.func_189515_b(tagCompound);
        tagCompound.func_82580_o("id");
        tagCompound.func_82580_o("x");
        tagCompound.func_82580_o("y");
        tagCompound.func_82580_o("z");
        return tagCompound;
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public void onDataPacket(@Nonnull NetworkManager networkManager, @Nonnull SPacketUpdateTileEntity packet) {
        NBTTagCompound tagCompound = packet.func_148857_g();
        this.func_145839_a(tagCompound);
    }

    public int getTierIndex() {
        if (!this.isConstructed) {
            this.onConstructed();
            WarpDrive.logger.error(String.format("%s Tile entity was used before being loaded! this is a forge issue.", this));
            if (Commons.throttleMe("TileEntityAbstractBase.getTierIndex")) {
                new RuntimeException().printStackTrace(WarpDrive.printStreamInfo);
            }
        }
        return this.enumTier.getIndex();
    }

    protected WarpDriveText getUpgradeStatus(boolean isAnimated) {
        if (!this.isUpgradeable()) {
            return new WarpDriveText(null, "", new Object[0]);
        }
        boolean isShowingItemNames = !isAnimated || System.currentTimeMillis() % 4000L > 2000L;
        WarpDriveText warpDriveText = new WarpDriveText(null, "warpdrive.upgrade.status_line.header", new Object[0]);
        for (Map.Entry<UpgradeSlot, Integer> entry : this.upgradeSlots.entrySet()) {
            UpgradeSlot upgradeSlot = entry.getKey();
            String keyName = isShowingItemNames ? upgradeSlot.itemStack.func_77977_a() + ".name" : upgradeSlot.getTranslationKey();
            Style style = entry.getValue() == 0 ? Commons.getStyleDisabled() : Commons.getStyleCorrect();
            warpDriveText.append(Commons.getStyleDisabled(), "- %1$s/%2$s x %3$s", new Object[]{new WarpDriveText(Commons.getStyleValue(), "%1$s", entry.getValue()), entry.getKey().maxCount, new WarpDriveText(style, keyName, new Object[0])});
        }
        return warpDriveText;
    }

    @Nonnull
    protected WarpDriveText getStatusPrefix() {
        Item item;
        if (this.field_145850_b != null && (item = Item.func_150898_a((Block)this.func_145838_q())) != Items.field_190931_a) {
            ItemStack itemStack = new ItemStack(item, 1, this.func_145832_p());
            return Commons.getChatPrefix(itemStack);
        }
        return new WarpDriveText();
    }

    @Nonnull
    protected WarpDriveText getBeamFrequencyStatus(int beamFrequency) {
        if (beamFrequency == -1) {
            return new WarpDriveText(Commons.getStyleWarning(), "warpdrive.beam_frequency.status_line.undefined", new Object[0]);
        }
        if (beamFrequency < 0) {
            return new WarpDriveText(Commons.getStyleWarning(), "warpdrive.beam_frequency.status_line.invalid", beamFrequency);
        }
        return new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.beam_frequency.status_line.valid", beamFrequency);
    }

    @Nonnull
    protected WarpDriveText getVideoChannelStatus(int videoChannel) {
        if (videoChannel == -1) {
            return new WarpDriveText(Commons.getStyleWarning(), "warpdrive.video_channel.status_line.undefined", new Object[0]);
        }
        if (videoChannel < 0) {
            return new WarpDriveText(Commons.getStyleWarning(), "warpdrive.video_channel.status_line.invalid", videoChannel);
        }
        CameraRegistryItem camera = WarpDrive.cameras.getCameraByVideoChannel(this.field_145850_b, videoChannel);
        if (camera == null) {
            return new WarpDriveText(Commons.getStyleWarning(), "warpdrive.video_channel.status_line.not_loaded", videoChannel);
        }
        if (camera.isTileEntity(this)) {
            return new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.video_channel.status_line.valid_self", videoChannel);
        }
        return new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.video_channel.status_line.valid_other", videoChannel, Commons.format(this.field_145850_b, camera.blockPos));
    }

    @Nonnull
    protected WarpDriveText getCoreSignatureStatus(String nameSignature) {
        if (nameSignature != null && !nameSignature.isEmpty()) {
            return new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.core_signature.status_line.defined", nameSignature);
        }
        return new WarpDriveText();
    }

    public WarpDriveText getStatusHeader() {
        return new WarpDriveText();
    }

    public WarpDriveText getStatus() {
        WarpDriveText message = this.getStatusPrefix();
        message.appendSibling(this.getStatusHeader());
        if (this instanceof IBeamFrequency && (this.field_145850_b == null || !this.field_145850_b.field_72995_K)) {
            message.append((ITextComponent)this.getBeamFrequencyStatus(((IBeamFrequency)((Object)this)).getBeamFrequency()));
        }
        if (this instanceof IVideoChannel && (this.field_145850_b == null || this.field_145850_b.field_72995_K)) {
            message.append((ITextComponent)this.getVideoChannelStatus(((IVideoChannel)((Object)this)).getVideoChannel()));
        }
        if (this instanceof ICoreSignature && (this.field_145850_b == null || this.field_145850_b.field_72995_K)) {
            message.append((ITextComponent)this.getCoreSignatureStatus(((ICoreSignature)((Object)this)).getSignatureName()));
        }
        if (!(!this.isUpgradeable() || this.func_145830_o() && this.field_145850_b.field_72995_K)) {
            boolean showDetails = this.func_145830_o();
            if (Commons.isClientThread()) {
                KeyBinding keyBindingSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
                String keyName = keyBindingSneak.getDisplayName();
                showDetails = Commons.isKeyPressed(keyBindingSneak);
                if (!showDetails) {
                    message.append(null, "warpdrive.upgrade.status_line.upgradeable", new Object[]{new WarpDriveText(Commons.getStyleCommand(), "%1$s", keyName)});
                }
            }
            if (showDetails) {
                message.append((ITextComponent)this.getUpgradeStatus(!this.func_145830_o()));
            }
        }
        return message;
    }

    public final WarpDriveText getStatus(@Nonnull ItemStack itemStack, @Nonnull IBlockState blockState) {
        NBTTagCompound tagCompound;
        Block block = blockState.func_177230_c();
        if (block instanceof IBlockBase) {
            this.enumTier = ((IBlockBase)block).getTier(itemStack);
            this.onConstructed();
        }
        if ((tagCompound = itemStack.func_77978_p()) != null) {
            this.func_145839_a(tagCompound);
        }
        return this.getStatus();
    }

    public String getStatusHeaderInPureText() {
        return Commons.removeFormatting(this.getStatusHeader().func_150260_c());
    }

    public String getInternalStatus() {
        return String.format("%s\nNBT %s\nisConstructed %s isFirstTick %s isDirty %s", this, this.func_189515_b(new NBTTagCompound()), this.isConstructed, this.isFirstTick, this.isDirty);
    }

    public boolean isUpgradeable() {
        return !this.upgradeSlots.isEmpty();
    }

    public boolean hasUpgrade(@Nonnull UpgradeSlot upgradeSlot) {
        return this.getUpgradeCount(upgradeSlot) > 0;
    }

    @Nullable
    private UpgradeSlot getUpgradeSlot(@Nonnull String name) {
        for (UpgradeSlot upgradeSlot : this.upgradeSlots.keySet()) {
            if (!upgradeSlot.name.equals(name)) continue;
            return upgradeSlot;
        }
        try {
            EnumComponentType componentType = EnumComponentType.valueOf(name);
            return this.getUpgradeSlot(ItemComponent.getItemStackNoCache(componentType, 1));
        }
        catch (IllegalArgumentException componentType) {
            try {
                EnumForceFieldUpgrade forceFieldUpgrade = EnumForceFieldUpgrade.valueOf(name);
                return this.getUpgradeSlot(ItemForceFieldUpgrade.getItemStackNoCache(forceFieldUpgrade, 1));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
    }

    @Nullable
    public UpgradeSlot getUpgradeSlot(@Nonnull ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return null;
        }
        for (UpgradeSlot upgradeSlot : this.upgradeSlots.keySet()) {
            if (!upgradeSlot.itemStack.func_77969_a(itemStack)) continue;
            return upgradeSlot;
        }
        return null;
    }

    @Nullable
    public UpgradeSlot getFirstUpgradeOfType(@Nonnull Class<?> clazz, @Nullable UpgradeSlot defaultValue) {
        for (Map.Entry<UpgradeSlot, Integer> entry : this.upgradeSlots.entrySet()) {
            if (entry.getValue() <= 0 || !clazz.isInstance(entry.getKey()) && !clazz.isInstance(entry.getKey().itemStack.func_77973_b())) continue;
            return entry.getKey();
        }
        return defaultValue;
    }

    public Map<UpgradeSlot, Integer> getUpgradesOfType(Class<?> clazz) {
        if (clazz == null) {
            return this.upgradeSlots;
        }
        HashMap<UpgradeSlot, Integer> mapResult = new HashMap<UpgradeSlot, Integer>(this.upgradeSlots.size());
        for (Map.Entry<UpgradeSlot, Integer> entry : this.upgradeSlots.entrySet()) {
            if (!clazz.isInstance(entry.getKey())) continue;
            mapResult.put(entry.getKey(), entry.getValue());
        }
        return mapResult;
    }

    public int getValidUpgradeCount(@Nonnull UpgradeSlot upgrade) {
        return Math.min(this.getUpgradeMaxCount(upgrade), this.getUpgradeCount(upgrade));
    }

    public int getUpgradeCount(@Nonnull UpgradeSlot upgradeSlot) {
        Integer value = this.upgradeSlots.get(upgradeSlot);
        return value == null ? 0 : value;
    }

    public int getUpgradeMaxCount(@Nonnull UpgradeSlot upgradeSlot) {
        return upgradeSlot.maxCount;
    }

    protected void registerUpgradeSlot(UpgradeSlot upgradeSlot) {
        this.upgradeSlots.put(upgradeSlot, 0);
    }

    public boolean canMountUpgrade(@Nonnull UpgradeSlot upgradeSlot) {
        return this.upgradeSlots.containsKey(upgradeSlot) && upgradeSlot.maxCount >= this.getUpgradeCount(upgradeSlot) + 1;
    }

    public final boolean mountUpgrade(@Nonnull UpgradeSlot upgradeSlot) {
        if (this.canMountUpgrade(upgradeSlot)) {
            int countNew = this.getUpgradeCount(upgradeSlot) + 1;
            this.upgradeSlots.put(upgradeSlot, countNew);
            this.onUpgradeChanged(upgradeSlot, countNew, true);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean canDismountUpgrade(@Nonnull UpgradeSlot upgradeSlot) {
        return this.upgradeSlots.containsKey(upgradeSlot) && this.getUpgradeCount(upgradeSlot) > 0;
    }

    public final boolean dismountUpgrade(@Nonnull UpgradeSlot upgradeSlot) {
        int countNew;
        if (this.canDismountUpgrade(upgradeSlot) && (countNew = this.getUpgradeCount(upgradeSlot) - 1) >= 0) {
            this.upgradeSlots.put(upgradeSlot, countNew);
            this.onUpgradeChanged(upgradeSlot, countNew, false);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    protected void onUpgradeChanged(@Nonnull UpgradeSlot upgradeSlot, int countNew, boolean isAdded) {
    }

    public void setDebugValues() {
    }

    public void onEMP(float efficiency) {
    }

    public String toString() {
        return String.format("%s %s", this.getClass().getSimpleName(), Commons.format(this.field_145850_b, this.field_174879_c));
    }

    public static class UpgradeSlot {
        public final String name;
        public final ItemStack itemStack;
        public final int maxCount;
        private final int hashCode;

        public UpgradeSlot(@Nonnull String name, @Nonnull ItemStack itemStack, int maxCount) {
            this.name = name;
            this.itemStack = itemStack;
            this.maxCount = maxCount;
            this.hashCode = name.hashCode();
        }

        @Nonnull
        String getTranslationKey() {
            return "warpdrive.upgrade.description." + this.name;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.name;
        }
    }
}

