/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityAbstractEnergyConsumer;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.event.ChunkLoadingHandler;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public abstract class TileEntityAbstractChunkLoading
extends TileEntityAbstractEnergyConsumer {
    protected ChunkPos chunkMin = null;
    protected ChunkPos chunkMax = null;
    private ForgeChunkManager.Ticket ticket = null;
    private boolean isRefreshNeeded = true;
    protected boolean areChunksLoaded = false;

    TileEntityAbstractChunkLoading() {
    }

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.chunkMin == null || this.chunkMax == null) {
            WarpDrive.logger.warn(String.format("%s No chunk coordinates defined, assuming current chunk", this));
            this.chunkMin = this.field_145850_b.func_175726_f(this.field_174879_c).func_76632_l();
            this.chunkMax = this.field_145850_b.func_175726_f(this.field_174879_c).func_76632_l();
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.isRefreshNeeded || this.shouldChunkLoad() != this.areChunksLoaded) {
            this.refreshLoading(this.isRefreshNeeded);
            this.isRefreshNeeded = false;
        }
    }

    public abstract boolean shouldChunkLoad();

    public void refreshChunkLoading() {
        this.isRefreshNeeded = true;
    }

    private void refreshLoading(boolean force) {
        boolean shouldChunkLoad = this.shouldChunkLoad();
        if (shouldChunkLoad) {
            if (this.ticket == null) {
                this.chunkloading_giveTicket(ChunkLoadingHandler.forgeTicket_requestNormal(this.field_145850_b, this));
            } else if (force) {
                ChunkLoadingHandler.forgeTicket_clearChunks(this.ticket);
            }
            if (!this.areChunksLoaded || force) {
                int ticketSize = this.ticket.getMaxChunkListDepth();
                ArrayList<ChunkPos> chunksToLoad = this.getChunksToLoad();
                if (chunksToLoad.size() > ticketSize) {
                    WarpDrive.logger.error(String.format("Too many chunk requested for loading %s", Commons.format(this.field_145850_b, this.field_174879_c)));
                    return;
                }
                for (ChunkPos chunk : chunksToLoad) {
                    ChunkLoadingHandler.forgeTicket_addChunks(this.ticket, chunk);
                }
                this.areChunksLoaded = true;
            }
        } else if (this.ticket != null) {
            ChunkLoadingHandler.forgeTicket_release(this.ticket);
            this.ticket = null;
            this.areChunksLoaded = false;
        }
    }

    public void chunkloading_giveTicket(ForgeChunkManager.Ticket ticket) {
        if (this.ticket != null) {
            ChunkLoadingHandler.forgeTicket_release(this.ticket);
            this.ticket = null;
        }
        this.ticket = ticket;
    }

    public int chunkloading_getArea() {
        return (this.chunkMax.field_77276_a - this.chunkMin.field_77276_a + 1) * (this.chunkMax.field_77275_b - this.chunkMin.field_77275_b + 1);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        if (this.chunkMin == null) {
            this.chunkMin = this.field_145850_b.func_175726_f(this.field_174879_c).func_76632_l();
        }
        if (this.chunkMax == null) {
            this.chunkMax = this.field_145850_b.func_175726_f(this.field_174879_c).func_76632_l();
        }
        tagCompound.func_74768_a("minChunkX", this.chunkMin.field_77276_a);
        tagCompound.func_74768_a("minChunkZ", this.chunkMin.field_77275_b);
        tagCompound.func_74768_a("maxChunkX", this.chunkMax.field_77276_a);
        tagCompound.func_74768_a("maxChunkZ", this.chunkMax.field_77275_b);
        return tagCompound;
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (tagCompound.func_74764_b("minChunkX")) {
            int xMin = tagCompound.func_74762_e("minChunkX");
            int zMin = tagCompound.func_74762_e("minChunkZ");
            this.chunkMin = new ChunkPos(xMin, zMin);
            int xMax = tagCompound.func_74762_e("maxChunkX");
            int zMax = tagCompound.func_74762_e("maxChunkZ");
            this.chunkMax = new ChunkPos(xMax, zMax);
        }
    }

    @Override
    public void onBlockBroken(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState) {
        if (this.ticket != null) {
            ChunkLoadingHandler.forgeTicket_release(this.ticket);
            this.ticket = null;
        }
        super.onBlockBroken(world, blockPos, blockState);
    }

    public ArrayList<ChunkPos> getChunksToLoad() {
        if (!this.shouldChunkLoad()) {
            return null;
        }
        assert (this.chunkMin.field_77276_a <= this.chunkMax.field_77276_a);
        assert (this.chunkMin.field_77275_b <= this.chunkMax.field_77275_b);
        int count = this.chunkloading_getArea();
        if (WarpDriveConfig.LOGGING_CHUNK_LOADING) {
            WarpDrive.logger.info(String.format("Collecting %d chunks to be loaded @ %s from %s to %s", count, Commons.format(this.field_145850_b), this.chunkMin, this.chunkMax));
        }
        ArrayList<ChunkPos> chunkCoords = new ArrayList<ChunkPos>(count);
        for (int x = this.chunkMin.field_77276_a; x <= this.chunkMax.field_77276_a; ++x) {
            for (int z = this.chunkMin.field_77275_b; z <= this.chunkMax.field_77275_b; ++z) {
                chunkCoords.add(new ChunkPos(x, z));
            }
        }
        return chunkCoords;
    }
}

