/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cofh.redstoneflux.api.IEnergyHandler;
import cofh.redstoneflux.api.IEnergyProvider;
import cofh.redstoneflux.api.IEnergyReceiver;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.TileEntityAbstractEnergyBase;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnergyWrapper;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.network.PacketHandler;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.util.GTUtility;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyHandler", modid="redstoneflux"), @Optional.Interface(iface="cofh.redstoneflux.api.IEnergyProvider", modid="redstoneflux"), @Optional.Interface(iface="cofh.redstoneflux.api.IEnergyReceiver", modid="redstoneflux"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="ic2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="ic2")})
public abstract class TileEntityAbstractEnergy
extends TileEntityAbstractEnergyBase
implements IEnergyProvider,
IEnergyReceiver,
IEnergyHandler,
IEnergySink,
IEnergySource {
    private long energyMaxStorage;
    private int IC2_sinkTier;
    private int IC2_sourceTier;
    private int FERF_fluxRateInput;
    private int FERF_fluxRateOutput;
    private int GT_voltageInput;
    private int GT_amperageInput;
    private int GT_voltageOutput;
    private int GT_amperageOutput;
    protected boolean isEnergyLostWhenBroken = true;
    private long energyStored_internal = 0L;
    private final IEnergyStorage[] FE_energyStorages = new IEnergyStorage[EnumFacing.field_82609_l.length + 1];
    private final Object[] GT_energyContainers = new Object[EnumFacing.field_82609_l.length + 1];
    private boolean IC2_isAddedToEnergyNet = false;
    private long IC2_timeAddedToEnergyNet = Long.MIN_VALUE;
    private int scanTickCount = WarpDriveConfig.ENERGY_SCAN_INTERVAL_TICKS;
    private final IEnergyStorage[] FE_energyReceivers = new IEnergyStorage[EnumFacing.field_82609_l.length + 1];
    private final TileEntity[] RF_energyReceivers = new TileEntity[EnumFacing.field_82609_l.length + 1];
    private boolean isOvervoltageLogged = false;

    public TileEntityAbstractEnergy() {
        this.energy_setParameters(Integer.MAX_VALUE, 0, 0, "HV", 0, "HV", 0);
    }

    protected void energy_setParameters(long energyMaxStorage, int fluxRateInput, int fluxRateOutput, String nameTierInput, int amperageInput, String nameTierOutput, int amperageOutput) {
        this.energyMaxStorage = energyMaxStorage;
        this.FERF_fluxRateInput = fluxRateInput;
        this.FERF_fluxRateOutput = fluxRateOutput;
        this.IC2_sinkTier = EnergyWrapper.EU_getTierByName(nameTierInput);
        this.IC2_sourceTier = EnergyWrapper.EU_getTierByName(nameTierOutput);
        this.GT_voltageInput = 8 * (int)Math.pow(4.0, this.IC2_sinkTier);
        this.GT_amperageInput = amperageInput;
        this.GT_voltageOutput = 8 * (int)Math.pow(4.0, this.IC2_sourceTier);
        this.GT_amperageOutput = amperageOutput;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (this.energy_getMaxStorage() != 0L) {
            if (WarpDriveConfig.ENERGY_ENABLE_FE && capability == CapabilityEnergy.ENERGY) {
                return true;
            }
            if (WarpDriveConfig.ENERGY_ENABLE_GTCE_EU && WarpDriveConfig.isGregtechLoaded && this.GT_isEnergyContainer(capability)) {
                return true;
            }
        }
        return super.hasCapability(capability, facing);
    }

    @Optional.Method(modid="gregtech")
    private boolean GT_isEnergyContainer(@Nonnull Capability<?> capability) {
        return capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, final @Nullable EnumFacing facing) {
        if (this.energy_getMaxStorage() != 0L) {
            if (WarpDriveConfig.ENERGY_ENABLE_FE && capability == CapabilityEnergy.ENERGY) {
                IEnergyStorage energyStorage = this.FE_energyStorages[Commons.getOrdinal(facing)];
                if (energyStorage == null) {
                    energyStorage = new IEnergyStorage(){

                        public int receiveEnergy(int maxReceive, boolean simulate) {
                            return TileEntityAbstractEnergy.this.FE_receiveEnergy(facing, maxReceive, simulate);
                        }

                        public int extractEnergy(int maxExtract, boolean simulate) {
                            return TileEntityAbstractEnergy.this.FE_extractEnergy(facing, maxExtract, simulate);
                        }

                        public int getEnergyStored() {
                            return this.canExtract() || this.canReceive() ? EnergyWrapper.convertInternalToRF_floor(TileEntityAbstractEnergy.this.energy_getEnergyStored()) : 0;
                        }

                        public int getMaxEnergyStored() {
                            return this.canExtract() || this.canReceive() ? EnergyWrapper.convertInternalToRF_floor(TileEntityAbstractEnergy.this.energy_getMaxStorage()) : 0;
                        }

                        public boolean canExtract() {
                            return TileEntityAbstractEnergy.this.energy_canOutput(facing);
                        }

                        public boolean canReceive() {
                            return TileEntityAbstractEnergy.this.energy_canInput(facing);
                        }
                    };
                    if (WarpDriveConfig.LOGGING_ENERGY) {
                        WarpDrive.logger.info(String.format("%s IEnergyStorage(%s) capability created!", this, facing));
                    }
                    this.FE_energyStorages[Commons.getOrdinal((EnumFacing)facing)] = energyStorage;
                }
                return (T)CapabilityEnergy.ENERGY.cast((Object)energyStorage);
            }
            if (WarpDriveConfig.ENERGY_ENABLE_GTCE_EU && WarpDriveConfig.isGregtechLoaded && this.GT_isEnergyContainer(capability)) {
                return this.GT_getEnergyContainer(capability, facing);
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    @Optional.Method(modid="gregtech")
    private <T> T GT_getEnergyContainer(@Nonnull Capability<T> capability, final @Nullable EnumFacing facing) {
        assert (capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER);
        IEnergyContainer energyContainer = (IEnergyContainer)this.GT_energyContainers[Commons.getOrdinal(facing)];
        if (energyContainer == null) {
            energyContainer = new IEnergyContainer(){

                public long acceptEnergyFromNetwork(EnumFacing side, long voltage, long amperage) {
                    if (!this.inputsEnergy(side)) {
                        return 0L;
                    }
                    if (voltage > this.getInputVoltage()) {
                        if (!TileEntityAbstractEnergy.this.isOvervoltageLogged) {
                            WarpDrive.logger.info(String.format("Overvoltage detected at %s input side %s: %d > %d", this, side, voltage, this.getInputVoltage()));
                            TileEntityAbstractEnergy.this.isOvervoltageLogged = true;
                        }
                        byte tier = GTUtility.getTierByVoltage((long)voltage);
                        TileEntityAbstractEnergy.this.applyOvervoltageEffects(tier);
                        return Math.min(amperage, this.getInputAmperage());
                    }
                    long energyMaxToAccept_GT = EnergyWrapper.convertInternalToGT_ceil(TileEntityAbstractEnergy.this.energy_getMaxStorage() - TileEntityAbstractEnergy.this.energy_getEnergyStored());
                    long amperageMaxToAccept_GT = Math.min(energyMaxToAccept_GT / voltage, Math.min(amperage, this.getInputAmperage()));
                    if (amperageMaxToAccept_GT <= 0L) {
                        return 0L;
                    }
                    TileEntityAbstractEnergy.this.energyStored_internal = TileEntityAbstractEnergy.this.energyStored_internal + EnergyWrapper.convertGTtoInternal_floor(voltage * amperageMaxToAccept_GT);
                    return amperageMaxToAccept_GT;
                }

                public boolean inputsEnergy(EnumFacing side) {
                    return TileEntityAbstractEnergy.this.energy_canInput(side);
                }

                public boolean outputsEnergy(EnumFacing side) {
                    return TileEntityAbstractEnergy.this.energy_canOutput(side);
                }

                public long changeEnergy(long differenceAmount) {
                    long energyMaxToRemove_GT = EnergyWrapper.convertInternalToGT_ceil(TileEntityAbstractEnergy.this.energy_getEnergyStored());
                    long energyMaxToAccept_GT = EnergyWrapper.convertInternalToGT_ceil(TileEntityAbstractEnergy.this.energy_getMaxStorage() - TileEntityAbstractEnergy.this.energy_getEnergyStored());
                    long energyToAccept_GT = Math.max(-energyMaxToRemove_GT, Math.min(energyMaxToAccept_GT, differenceAmount));
                    TileEntityAbstractEnergy.this.energyStored_internal = TileEntityAbstractEnergy.this.energyStored_internal + EnergyWrapper.convertGTtoInternal_floor(energyToAccept_GT);
                    return energyToAccept_GT;
                }

                public long getEnergyStored() {
                    return this.outputsEnergy(facing) || this.inputsEnergy(facing) ? EnergyWrapper.convertInternalToGT_floor(TileEntityAbstractEnergy.this.energy_getEnergyStored()) : 0L;
                }

                public long getEnergyCapacity() {
                    return this.outputsEnergy(facing) || this.inputsEnergy(facing) ? EnergyWrapper.convertInternalToGT_floor(TileEntityAbstractEnergy.this.energy_getMaxStorage()) : 0L;
                }

                public long getOutputAmperage() {
                    return TileEntityAbstractEnergy.this.GT_amperageOutput;
                }

                public long getOutputVoltage() {
                    return TileEntityAbstractEnergy.this.GT_voltageOutput;
                }

                public long getInputAmperage() {
                    return TileEntityAbstractEnergy.this.GT_amperageInput;
                }

                public long getInputVoltage() {
                    return TileEntityAbstractEnergy.this.GT_voltageInput;
                }

                public long getInputPerSec() {
                    return this.inputsEnergy(facing) ? (long)TileEntityAbstractEnergy.this.GT_amperageInput * (long)TileEntityAbstractEnergy.this.GT_voltageInput / 20L : 0L;
                }

                public long getOutputPerSec() {
                    return this.outputsEnergy(facing) ? (long)TileEntityAbstractEnergy.this.GT_amperageOutput * (long)TileEntityAbstractEnergy.this.GT_voltageOutput / 20L : 0L;
                }
            };
            if (WarpDriveConfig.LOGGING_ENERGY) {
                WarpDrive.logger.info(String.format("%s IEnergyContainer capability created!", this));
            }
            this.GT_energyContainers[Commons.getOrdinal((EnumFacing)facing)] = energyContainer;
        }
        return (T)GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER.cast((Object)energyContainer);
    }

    private void applyOvervoltageEffects(int tier) {
        int radius = 3;
        if (WarpDriveConfig.ENERGY_OVERVOLTAGE_SHOCK_FACTOR > 0.0f) {
            Vector3 v3Entity = new Vector3();
            Vector3 v3Direction = new Vector3();
            for (int count = 0; count < 3; ++count) {
                v3Direction.x = 2.0 * (this.field_145850_b.field_73012_v.nextDouble() - 0.5);
                v3Direction.y = 2.0 * (this.field_145850_b.field_73012_v.nextDouble() - 0.5);
                v3Direction.z = 2.0 * (this.field_145850_b.field_73012_v.nextDouble() - 0.5);
                double range = 3.0 * (0.4 + 0.6 * this.field_145850_b.field_73012_v.nextDouble());
                v3Entity.x = (double)this.field_174879_c.func_177958_n() + 0.5 + range * v3Direction.x + (this.field_145850_b.field_73012_v.nextDouble() - 0.5);
                v3Entity.y = (double)this.field_174879_c.func_177956_o() + 0.5 + range * v3Direction.y + (this.field_145850_b.field_73012_v.nextDouble() - 0.5);
                v3Entity.z = (double)this.field_174879_c.func_177952_p() + 0.5 + range * v3Direction.z + (this.field_145850_b.field_73012_v.nextDouble() - 0.5);
                v3Direction.scale(0.15);
                PacketHandler.sendSpawnParticlePacket(this.field_145850_b, "fireworksSpark", (byte)1, v3Entity, v3Direction, 0.2f + 0.3f * this.field_145850_b.field_73012_v.nextFloat(), 0.5f + 0.15f * this.field_145850_b.field_73012_v.nextFloat(), 0.75f + 0.25f * this.field_145850_b.field_73012_v.nextFloat(), 0.1f + 0.2f * this.field_145850_b.field_73012_v.nextFloat(), 0.1f + 0.3f * this.field_145850_b.field_73012_v.nextFloat(), 0.2f + 0.1f * this.field_145850_b.field_73012_v.nextFloat(), 32);
            }
            List entityLivingBases = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 3), (double)(this.field_174879_c.func_177956_o() - 3), (double)(this.field_174879_c.func_177952_p() - 3), (double)(this.field_174879_c.func_177958_n() + 3 + 1), (double)(this.field_174879_c.func_177956_o() + 3 + 1), (double)(this.field_174879_c.func_177952_p() + 3 + 1)));
            for (EntityLivingBase entityLivingBase : entityLivingBases) {
                if (entityLivingBase.field_70128_L || !entityLivingBase.func_190631_cK() || entityLivingBase instanceof EntityPlayer && ((EntityPlayer)entityLivingBase).field_71075_bZ.field_75102_a) continue;
                entityLivingBase.func_70097_a((DamageSource)WarpDrive.damageShock, (float)tier * WarpDriveConfig.ENERGY_OVERVOLTAGE_SHOCK_FACTOR);
            }
        }
        if (WarpDriveConfig.ENERGY_OVERVOLTAGE_EXPLOSION_FACTOR > 0.0f) {
            this.field_145850_b.func_175698_g(this.field_174879_c);
            this.field_145850_b.func_72885_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, (float)tier * WarpDriveConfig.ENERGY_OVERVOLTAGE_EXPLOSION_FACTOR, true, true);
        }
    }

    public long energy_getEnergyStored() {
        return Commons.clamp(0L, this.energy_getMaxStorage(), this.energyStored_internal);
    }

    public long energy_getMaxStorage() {
        return this.energyMaxStorage;
    }

    public int energy_getPotentialOutput() {
        return 0;
    }

    protected void energy_outputDone(long energyOutput_internal) {
        this.energy_consume(energyOutput_internal);
    }

    public boolean energy_canInput(EnumFacing from) {
        return false;
    }

    public boolean energy_canOutput(EnumFacing to) {
        return false;
    }

    public boolean energy_consume(long amount_internal, boolean simulate) {
        if (this.energy_getEnergyStored() >= amount_internal) {
            if (!simulate) {
                this.energy_consume(amount_internal);
            }
            return true;
        }
        return false;
    }

    public void energy_consume(long amount_internal) {
        this.energyStored_internal -= amount_internal;
    }

    @Override
    public void setDebugValues() {
        super.setDebugValues();
        this.energyStored_internal = this.energyMaxStorage;
    }

    @Override
    protected WarpDriveText getEnergyStatusText() {
        WarpDriveText text = new WarpDriveText();
        long energy_maxStorage = this.energy_getMaxStorage();
        if (energy_maxStorage == 0L) {
            return text;
        }
        EnergyWrapper.formatAndAppendCharge(text, this.energy_getEnergyStored(), energy_maxStorage, null);
        if (this.energy_canInput(null)) {
            EnergyWrapper.formatAndAppendInputRate(text, this.GT_amperageInput, this.GT_voltageInput, this.IC2_sinkTier, this.FERF_fluxRateInput, null);
        }
        if (this.energy_canOutput(null)) {
            EnergyWrapper.formatAndAppendOutputRate(text, this.GT_amperageOutput, this.GT_voltageOutput, this.IC2_sourceTier, this.FERF_fluxRateOutput, null);
        }
        return text;
    }

    @Override
    protected void onConstructed() {
        super.onConstructed();
        this.energyMaxStorage = 0L;
    }

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (WarpDriveConfig.ENERGY_ENABLE_RF || WarpDriveConfig.ENERGY_ENABLE_FE) {
            this.FERF_scanForEnergyReceivers();
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (WarpDriveConfig.ENERGY_ENABLE_IC2_EU && WarpDriveConfig.isIndustrialCraft2Loaded) {
            this.IC2_addToEnergyNet();
        }
        if (WarpDriveConfig.ENERGY_ENABLE_FE || WarpDriveConfig.ENERGY_ENABLE_RF) {
            --this.scanTickCount;
            if (this.scanTickCount <= 0) {
                this.scanTickCount = WarpDriveConfig.ENERGY_SCAN_INTERVAL_TICKS;
                if (this.FERF_fluxRateOutput > 0) {
                    this.FERF_scanForEnergyReceivers();
                }
            }
            if (this.FERF_fluxRateOutput > 0) {
                if (WarpDriveConfig.ENERGY_ENABLE_RF && WarpDriveConfig.isRedstoneFluxLoaded) {
                    this.RF_outputEnergy();
                }
                if (WarpDriveConfig.ENERGY_ENABLE_FE) {
                    this.FE_outputEnergy();
                }
            }
        }
    }

    @Override
    public void onChunkUnload() {
        if (WarpDriveConfig.isIndustrialCraft2Loaded) {
            this.IC2_removeFromEnergyNet();
        }
        super.onChunkUnload();
    }

    @Override
    public void func_145843_s() {
        if (WarpDriveConfig.isIndustrialCraft2Loaded) {
            this.IC2_removeFromEnergyNet();
        }
        super.func_145843_s();
    }

    @Override
    public Object[] getEnergyStatus() {
        String units = this.energy_getDisplayUnits();
        return new Object[]{EnergyWrapper.convert(this.energy_getEnergyStored(), units), EnergyWrapper.convert(this.energy_getMaxStorage(), units), units};
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing from) {
        boolean accepts;
        boolean bl = accepts = WarpDriveConfig.ENERGY_ENABLE_IC2_EU && this.energy_canInput(from);
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(String.format("%s [IC2]acceptsEnergyFrom(%s, %s) => %s", this, emitter, from, accepts));
        }
        return accepts;
    }

    @Optional.Method(modid="ic2")
    public int getSinkTier() {
        int tier;
        int n = tier = WarpDriveConfig.ENERGY_ENABLE_IC2_EU && this.energy_getMaxStorage() > 0L ? this.IC2_sinkTier : 0;
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(String.format("%s [IC2]getSinkTier() => %d", this, tier));
        }
        return tier;
    }

    @Optional.Method(modid="ic2")
    public double getDemandedEnergy() {
        double demanded_EU = Math.max(0.0, EnergyWrapper.convertInternalToEU_floor(this.energy_getMaxStorage() - this.energy_getEnergyStored()));
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(String.format("%s [IC2]getDemandedEnergy() => %.2f EU", this, demanded_EU));
        }
        return demanded_EU;
    }

    @Optional.Method(modid="ic2")
    public double injectEnergy(EnumFacing from, double amount_EU, double voltage) {
        double amountLeftOver_EU = amount_EU;
        if (WarpDriveConfig.ENERGY_ENABLE_IC2_EU && this.energy_canInput(from.func_176734_d())) {
            long leftover_internal = 0L;
            this.energyStored_internal += EnergyWrapper.convertEUtoInternal_floor(amount_EU);
            if (this.energyStored_internal > this.energy_getMaxStorage()) {
                leftover_internal = this.energyStored_internal - this.energy_getMaxStorage();
                this.energyStored_internal = this.energy_getMaxStorage();
            }
            amountLeftOver_EU = EnergyWrapper.convertInternalToEU_floor(leftover_internal);
        }
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(String.format("%s [IC2]injectEnergy(%s, %.2f EU, %.1f) => %.2f EU", this, from, amount_EU, voltage, amountLeftOver_EU));
        }
        return amountLeftOver_EU;
    }

    @Optional.Method(modid="ic2")
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing to) {
        boolean emits;
        boolean bl = emits = WarpDriveConfig.ENERGY_ENABLE_IC2_EU && this.energy_canOutput(to);
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(String.format("%s [IC2]emitsEnergyTo(%s, %s) => %s", this, receiver, to, emits));
        }
        return emits;
    }

    @Optional.Method(modid="ic2")
    public int getSourceTier() {
        int tier;
        int n = tier = WarpDriveConfig.ENERGY_ENABLE_IC2_EU && this.energy_getMaxStorage() > 0L ? this.IC2_sourceTier : 0;
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(String.format("%s [IC2]getSourceTier() => %d", this, tier));
        }
        return Math.min(4, tier);
    }

    @Optional.Method(modid="ic2")
    public double getOfferedEnergy() {
        double offered_EU = 0.0;
        if (WarpDriveConfig.ENERGY_ENABLE_IC2_EU) {
            offered_EU = EnergyWrapper.convertInternalToEU_floor(this.energy_getPotentialOutput());
        }
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(String.format("%s [IC2]getOfferedEnergy() => %.2f EU", this, offered_EU));
        }
        return offered_EU;
    }

    @Optional.Method(modid="ic2")
    public void drawEnergy(double amount_EU) {
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(String.format("%s [IC2]drawEnergy(%.2f EU)", this, amount_EU));
        }
        this.energy_outputDone(EnergyWrapper.convertEUtoInternal_ceil(amount_EU));
    }

    @Optional.Method(modid="ic2")
    private void IC2_addToEnergyNet() {
        if (!this.field_145850_b.field_72995_K && !this.IC2_isAddedToEnergyNet) {
            this.IC2_timeAddedToEnergyNet = this.field_145850_b.func_82737_E();
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.IC2_isAddedToEnergyNet = true;
        }
    }

    @Optional.Method(modid="ic2")
    private void IC2_removeFromEnergyNet() {
        if (!this.field_145850_b.field_72995_K && this.IC2_isAddedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.IC2_isAddedToEnergyNet = false;
        }
    }

    @Optional.Method(modid="redstoneflux")
    public int receiveEnergy(EnumFacing from, int maxReceive_RF, boolean simulate) {
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(String.format("%s [RF]receiveEnergy(%s, %d, %s)", this, from, maxReceive_RF, simulate));
        }
        return this.FERF_receiveEnergy(from, maxReceive_RF, simulate);
    }

    private int FE_receiveEnergy(EnumFacing from, int maxReceive_RF, boolean simulate) {
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(String.format("%s FE_receiveEnergy(%s, %d, %s)", this, from, maxReceive_RF, simulate));
        }
        return this.FERF_receiveEnergy(from, maxReceive_RF, simulate);
    }

    private int FERF_receiveEnergy(EnumFacing from, int maxReceive_RF, boolean simulate) {
        if (!this.energy_canInput(from)) {
            return 0;
        }
        long energyMaxStored_internal = this.energy_getMaxStorage();
        if (energyMaxStored_internal == 0L) {
            return 0;
        }
        long energyStored_internal = this.energy_getEnergyStored();
        int energyMaxToAdd_RF = EnergyWrapper.convertInternalToRF_ceil(energyMaxStored_internal - energyStored_internal);
        int energyToAdd_RF = Math.min(maxReceive_RF, energyMaxToAdd_RF);
        if (WarpDriveConfig.LOGGING_ENERGY) {
            int energyMaxStored_RF = EnergyWrapper.convertInternalToRF_floor(energyMaxStored_internal);
            int energyStored_RF = EnergyWrapper.convertInternalToRF_floor(energyStored_internal);
            WarpDrive.logger.info(String.format("%s FERF_receiveEnergy(%s, %d, %s) adding %s to %d / %s RF", this, from, maxReceive_RF, simulate, energyToAdd_RF, energyStored_RF, energyMaxStored_RF));
        }
        if (!simulate) {
            this.energyStored_internal += EnergyWrapper.convertRFtoInternal_floor(energyToAdd_RF);
        }
        return energyToAdd_RF;
    }

    @Optional.Method(modid="redstoneflux")
    public int extractEnergy(EnumFacing from, int maxExtract_RF, boolean simulate) {
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(String.format("%s [RF]extractEnergy(%s, %d, %s)", this, from, maxExtract_RF, simulate));
        }
        return this.FERF_extractEnergy(from, maxExtract_RF, simulate);
    }

    private int FE_extractEnergy(EnumFacing from, int maxExtract_RF, boolean simulate) {
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(String.format("%s FE_extractEnergy(%s, %d, %s)", this, from, maxExtract_RF, simulate));
        }
        return this.FERF_extractEnergy(from, maxExtract_RF, simulate);
    }

    private int FERF_extractEnergy(EnumFacing from, int maxExtract_RF, boolean simulate) {
        if (!this.energy_canOutput(from)) {
            return 0;
        }
        long potentialEnergyOutput_internal = this.energy_getPotentialOutput();
        long energyExtracted_internal = Math.min(EnergyWrapper.convertRFtoInternal_ceil(maxExtract_RF), potentialEnergyOutput_internal);
        if (!simulate) {
            this.energy_outputDone(energyExtracted_internal);
        }
        return EnergyWrapper.convertInternalToRF_floor(energyExtracted_internal);
    }

    @Optional.Method(modid="redstoneflux")
    public boolean canConnectEnergy(EnumFacing from) {
        return WarpDriveConfig.ENERGY_ENABLE_RF && this.energy_getMaxStorage() != 0L && (this.energy_canInput(from) || this.energy_canOutput(from));
    }

    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(EnumFacing from) {
        return this.canConnectEnergy(from) ? EnergyWrapper.convertInternalToRF_floor(this.energy_getEnergyStored()) : 0;
    }

    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(EnumFacing from) {
        return this.canConnectEnergy(from) ? EnergyWrapper.convertInternalToRF_floor(this.energy_getMaxStorage()) : 0;
    }

    @Optional.Method(modid="redstoneflux")
    private void RF_outputEnergy(EnumFacing to, @Nonnull IEnergyReceiver energyReceiver) {
        if (!this.energy_canOutput(to)) {
            return;
        }
        long potentialEnergyOutput_internal = this.energy_getPotentialOutput();
        if (potentialEnergyOutput_internal > 0L) {
            int potentialEnergyOutput_RF = EnergyWrapper.convertInternalToRF_floor(potentialEnergyOutput_internal);
            int energyToOutput_RF = energyReceiver.receiveEnergy(to.func_176734_d(), potentialEnergyOutput_RF, true);
            if (energyToOutput_RF > 0) {
                int energyOutputted_RF = energyReceiver.receiveEnergy(to.func_176734_d(), energyToOutput_RF, false);
                this.energy_outputDone(EnergyWrapper.convertRFtoInternal_ceil(energyOutputted_RF));
            }
        }
    }

    private void FE_outputEnergy(EnumFacing to, @Nonnull IEnergyStorage energyStorage) {
        int potentialEnergyOutput_RF;
        int energyToOutput_RF;
        if (!this.energy_canOutput(to)) {
            return;
        }
        long potentialEnergyOutput_internal = this.energy_getPotentialOutput();
        if (potentialEnergyOutput_internal > 0L && (energyToOutput_RF = energyStorage.receiveEnergy(potentialEnergyOutput_RF = EnergyWrapper.convertInternalToRF_floor(potentialEnergyOutput_internal), true)) > 0) {
            int energyOutputted_RF = energyStorage.receiveEnergy(energyToOutput_RF, false);
            this.energy_outputDone(EnergyWrapper.convertRFtoInternal_ceil(energyOutputted_RF));
        }
    }

    @Optional.Method(modid="redstoneflux")
    private void RF_outputEnergy() {
        for (EnumFacing to : EnumFacing.field_82609_l) {
            TileEntity tileEntity = this.RF_energyReceivers[Commons.getOrdinal(to)];
            if (!(tileEntity instanceof IEnergyReceiver) || tileEntity.func_145837_r()) continue;
            this.RF_outputEnergy(to, (IEnergyReceiver)tileEntity);
        }
    }

    private void FE_outputEnergy() {
        for (EnumFacing to : EnumFacing.field_82609_l) {
            IEnergyStorage energyStorage = this.FE_energyReceivers[Commons.getOrdinal(to)];
            if (energyStorage == null) continue;
            this.FE_outputEnergy(to, energyStorage);
        }
    }

    @Optional.Method(modid="redstoneflux")
    private boolean RF_addEnergyReceiver(@Nonnull EnumFacing to, TileEntity tileEntity) {
        IEnergyReceiver energyReceiver;
        if (tileEntity instanceof IEnergyReceiver && !tileEntity.func_145837_r() && (energyReceiver = (IEnergyReceiver)tileEntity).canConnectEnergy(to.func_176734_d())) {
            if (this.RF_energyReceivers[Commons.getOrdinal(to)] != tileEntity) {
                this.RF_energyReceivers[Commons.getOrdinal((EnumFacing)to)] = tileEntity;
            }
            return true;
        }
        this.RF_energyReceivers[Commons.getOrdinal((EnumFacing)to)] = null;
        return false;
    }

    private boolean FE_addEnergyReceiver(@Nonnull EnumFacing to, TileEntity tileEntity) {
        IEnergyStorage energyStorage;
        if (tileEntity != null && (energyStorage = (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, to.func_176734_d())) != null && energyStorage.canReceive()) {
            if (this.FE_energyReceivers[Commons.getOrdinal(to)] != energyStorage) {
                this.FE_energyReceivers[Commons.getOrdinal((EnumFacing)to)] = energyStorage;
            }
            return true;
        }
        this.FE_energyReceivers[Commons.getOrdinal((EnumFacing)to)] = null;
        return false;
    }

    private void FERF_scanForEnergyReceivers() {
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(String.format("%s FERF_scanForEnergyReceivers()", this));
        }
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(this.field_174879_c);
        for (EnumFacing to : EnumFacing.field_82609_l) {
            if (!this.energy_canOutput(to)) continue;
            mutableBlockPos.func_181079_c(this.field_174879_c.func_177958_n() + to.func_82601_c(), this.field_174879_c.func_177956_o() + to.func_96559_d(), this.field_174879_c.func_177952_p() + to.func_82599_e());
            TileEntity tileEntity = this.field_145850_b.func_175625_s((BlockPos)mutableBlockPos);
            if ((!WarpDriveConfig.ENERGY_ENABLE_RF || !WarpDriveConfig.isRedstoneFluxLoaded || !this.RF_addEnergyReceiver(to, tileEntity)) && WarpDriveConfig.ENERGY_ENABLE_FE && !this.FE_addEnergyReceiver(to, tileEntity)) continue;
        }
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.energyStored_internal = tagCompound.func_74763_f("energy");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        tagCompound.func_74772_a("energy", this.energyStored_internal);
        return tagCompound;
    }

    @Override
    public NBTTagCompound writeItemDropNBT(NBTTagCompound tagCompound) {
        tagCompound = super.writeItemDropNBT(tagCompound);
        if (this.isEnergyLostWhenBroken) {
            tagCompound.func_82580_o("energy");
        }
        return tagCompound;
    }

    protected void energy_refreshConnections() {
        if (WarpDriveConfig.isIndustrialCraft2Loaded && this.field_145850_b.func_82737_E() - this.IC2_timeAddedToEnergyNet > 1L) {
            this.IC2_removeFromEnergyNet();
        }
        this.scanTickCount = -1;
    }

    @Override
    public void onEMP(float efficiency) {
        if (this.energy_getMaxStorage() > 0L) {
            this.energy_consume(Math.round((float)this.energy_getEnergyStored() * efficiency), false);
        }
    }
}

