/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.api.computer.ISecurityStation;
import cr0s.warpdrive.block.TileEntityAbstractMachine;
import cr0s.warpdrive.data.PlayerIdName;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fml.common.Optional;

public class TileEntitySecurityStation
extends TileEntityAbstractMachine
implements ISecurityStation {
    public static final TileEntitySecurityStation DUMMY = new TileEntitySecurityStation(true);
    private final CopyOnWriteArraySet<PlayerIdName> playerIdNames = new CopyOnWriteArraySet();
    private final boolean isDummy;

    private TileEntitySecurityStation(boolean isDummy) {
        this.isDummy = isDummy;
        this.peripheralName = "warpdriveSecurityStation";
        this.addMethods(new String[]{"getAttachedPlayers", "removeAllAttachedPlayers", "removeAttachedPlayer"});
    }

    public TileEntitySecurityStation() {
        this(false);
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tagListPlayers = tagCompound.func_150295_c("players", 10);
        ArrayList<PlayerIdName> playerIdNames = new ArrayList<PlayerIdName>(tagListPlayers.func_74745_c());
        for (int index = 0; index < tagListPlayers.func_74745_c(); ++index) {
            NBTTagCompound tagCompoundEntry = tagListPlayers.func_150305_b(index);
            PlayerIdName playerIdName = PlayerIdName.loadFromNBT(tagCompoundEntry);
            if (playerIdName == null) {
                WarpDrive.logger.warn(String.format("Skipping invalid PlayerIdName in %s: %s", this, tagCompoundEntry.toString()));
                continue;
            }
            playerIdNames.add(playerIdName);
        }
        this.playerIdNames.clear();
        this.playerIdNames.addAll(playerIdNames);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        NBTTagList tagListPlayers = new NBTTagList();
        for (PlayerIdName playerIdName : this.playerIdNames) {
            tagListPlayers.func_74742_a((NBTBase)playerIdName.writeToNBT(new NBTTagCompound()));
        }
        tagCompound.func_74782_a("players", (NBTBase)tagListPlayers);
        return tagCompound;
    }

    @Override
    public NBTTagCompound writeItemDropNBT(NBTTagCompound tagCompound) {
        tagCompound = super.writeItemDropNBT(tagCompound);
        tagCompound.func_82580_o("players");
        return tagCompound;
    }

    @Override
    public WarpDriveText getStatus() {
        return super.getStatus().append(null, "warpdrive.security_station.guide.registered_players", this.getAttachedPlayersList());
    }

    public WarpDriveText attachPlayer(EntityPlayer entityPlayer) {
        if (this.isDummy) {
            return new WarpDriveText(Commons.getStyleDisabled(), "-dummy-", new Object[0]);
        }
        for (PlayerIdName playerIdName : this.playerIdNames) {
            if (!entityPlayer.func_110124_au().equals(playerIdName.getUUID())) continue;
            this.playerIdNames.remove(playerIdName);
            WarpDriveText text = Commons.getChatPrefix(this.func_145838_q());
            text.appendSibling(new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.security_station.guide.player_unregistered", this.getAttachedPlayersList()));
            this.func_70296_d();
            return text;
        }
        entityPlayer.func_70097_a(DamageSource.field_76377_j, 1.0f);
        this.playerIdNames.add(new PlayerIdName(entityPlayer));
        WarpDriveText text = Commons.getChatPrefix(this.func_145838_q());
        text.appendSibling(new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.security_station.guide.player_registered", this.getAttachedPlayersList()));
        this.func_70296_d();
        return text;
    }

    public boolean isAttachedPlayer(EntityPlayer entityPlayer) {
        if (this.isDummy) {
            return false;
        }
        for (PlayerIdName playerIdName : this.playerIdNames) {
            if (!entityPlayer.func_110124_au().equals(playerIdName.getUUID())) continue;
            return true;
        }
        return false;
    }

    protected String getAttachedPlayersList() {
        if (this.isDummy) {
            return "<everyone>";
        }
        if (this.playerIdNames.isEmpty()) {
            return "<nobody>";
        }
        StringBuilder stringBuilderList = new StringBuilder();
        int index = 0;
        for (PlayerIdName playerIdName : this.playerIdNames) {
            String namePlayer = playerIdName.getName();
            if (index > 0) {
                stringBuilderList.append(", ");
            }
            stringBuilderList.append(namePlayer);
            ++index;
        }
        return stringBuilderList.toString();
    }

    public String getFirstOnlinePlayer() {
        if (this.playerIdNames.isEmpty()) {
            return null;
        }
        for (PlayerIdName playerIdName : this.playerIdNames) {
            EntityPlayerMP entityPlayer = Commons.getOnlinePlayerByUUID(playerIdName.getUUID());
            if (entityPlayer == null) continue;
            playerIdName.setName(entityPlayer.func_70005_c_());
            return playerIdName.getName();
        }
        return null;
    }

    @Override
    public Object[] getAttachedPlayers() {
        StringBuilder stringBuilderList = new StringBuilder();
        String[] namePlayers = new String[this.playerIdNames.size()];
        if (!this.playerIdNames.isEmpty()) {
            int index = 0;
            for (PlayerIdName playerIdName : this.playerIdNames) {
                String namePlayer = playerIdName.getName();
                if (index > 0) {
                    stringBuilderList.append(", ");
                }
                stringBuilderList.append(namePlayer);
                namePlayers[index] = namePlayer;
                ++index;
            }
        }
        return new Object[]{stringBuilderList.toString(), namePlayers};
    }

    @Override
    public Object[] removeAllAttachedPlayers() {
        int count = this.playerIdNames.size();
        if (count == 0) {
            return new Object[]{true, "Nothing to do as there's already no attached players."};
        }
        this.playerIdNames.clear();
        return new Object[]{true, String.format("Done, %d players have been removed.", count)};
    }

    @Override
    public Object[] removeAttachedPlayer(@Nonnull Object[] arguments) {
        if (arguments.length != 1 || !(arguments[0] instanceof String)) {
            return new Object[]{false, "Invalid argument, expecting exactly one player name as string."};
        }
        String nameToRemove = (String)arguments[0];
        for (PlayerIdName playerIdName : this.playerIdNames) {
            if (!nameToRemove.equals(playerIdName.getName())) continue;
            this.playerIdNames.remove(playerIdName);
            return new Object[]{true, "Player removed successfully."};
        }
        return new Object[]{false, "No player found with that name."};
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getAttachedPlayers(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getAttachedPlayers();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] removeAllAttachedPlayers(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.removeAllAttachedPlayers();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] removeAttachedPlayer(Context context, Arguments arguments) {
        return this.removeAttachedPlayer(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Override
    @Optional.Method(modid="computercraft")
    protected Object[] CC_callMethod(@Nonnull String methodName, @Nonnull Object[] arguments) {
        switch (methodName) {
            case "getAttachedPlayers": {
                return this.getAttachedPlayers();
            }
            case "removeAllAttachedPlayers": {
                return this.removeAllAttachedPlayers();
            }
            case "removeAttachedPlayer": {
                return this.removeAttachedPlayer(arguments);
            }
        }
        return super.CC_callMethod(methodName, arguments);
    }
}

