/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.atomic;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IControlChannel;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.TileEntityAbstractMachine;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.BlockProperties;
import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.Optional;

public class TileEntityAcceleratorControlPoint
extends TileEntityAbstractMachine
implements IControlChannel {
    private int controlChannel = -1;
    private static final int UPDATE_INTERVAL_TICKS = 20;
    private int updateTicks;

    public TileEntityAcceleratorControlPoint() {
        this.peripheralName = "warpdriveAcceleratorControlPoint";
        this.addMethods(new String[]{"state", "controlChannel"});
    }

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        --this.updateTicks;
        if (this.updateTicks <= 0) {
            this.updateTicks = 20;
            this.updateBlockState((IBlockState)null, BlockProperties.ACTIVE, this.controlChannel != -1 && this.isEnabled);
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
    }

    @Override
    public int getControlChannel() {
        return this.controlChannel;
    }

    @Override
    public void setControlChannel(int controlChannel) {
        if (this.controlChannel != controlChannel) {
            this.controlChannel = controlChannel;
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info(this + " Accelerator control point controlChannel channel set to " + controlChannel);
            }
            this.func_70296_d();
        }
    }

    private WarpDriveText getControlChannelStatus() {
        if (this.controlChannel == -1) {
            return new WarpDriveText(Commons.getStyleWarning(), "warpdrive.control_channel.status_line.undefined", new Object[0]);
        }
        if (!IControlChannel.isValid(this.controlChannel)) {
            return new WarpDriveText(Commons.getStyleWarning(), "warpdrive.control_channel.status_line.invalid", this.controlChannel);
        }
        return new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.control_channel.status_line.valid", this.controlChannel);
    }

    @Override
    public WarpDriveText getStatus() {
        return super.getStatus().append((ITextComponent)this.getControlChannelStatus());
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.controlChannel = tagCompound.func_74762_e("controlChannel");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("controlChannel", this.controlChannel);
        return tagCompound;
    }

    public Object[] controlChannel(Object[] arguments) {
        if (arguments != null && arguments.length == 1 && arguments[0] != null) {
            int controlChannelRequested;
            try {
                controlChannelRequested = Commons.toInt(arguments[0]);
            }
            catch (Exception exception) {
                if (WarpDriveConfig.LOGGING_LUA) {
                    WarpDrive.logger.error(String.format("%s LUA error on controlChannel(): Integer expected for 1st argument %s", this, arguments[0]));
                }
                return new Object[]{this.controlChannel};
            }
            this.setControlChannel(controlChannelRequested);
        }
        return new Integer[]{this.controlChannel};
    }

    private Object[] state() {
        String status = this.getStatusHeaderInPureText();
        return new Object[]{status, this.isEnabled, this.controlChannel};
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] controlChannel(Context context, Arguments arguments) {
        return this.controlChannel(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] state(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.state();
    }

    @Override
    @Optional.Method(modid="computercraft")
    protected Object[] CC_callMethod(@Nonnull String methodName, @Nonnull Object[] arguments) {
        switch (methodName) {
            case "controlChannel": {
                return this.controlChannel(arguments);
            }
            case "state": {
                return this.state();
            }
        }
        return super.CC_callMethod(methodName, arguments);
    }
}

