/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.breathing;

import cr0s.warpdrive.block.TileEntityAbstractEnergyConsumer;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.EnergyWrapper;
import cr0s.warpdrive.data.StateAir;
import cr0s.warpdrive.event.ChunkHandler;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class TileEntityAirGeneratorTiered
extends TileEntityAbstractEnergyConsumer {
    private int tickUpdate;

    public TileEntityAirGeneratorTiered() {
        this.peripheralName = "warpdriveAirGenerator";
        this.doRequireUpgradeToInterface();
    }

    @Override
    protected void onConstructed() {
        super.onConstructed();
        this.energy_setParameters(WarpDriveConfig.BREATHING_MAX_ENERGY_STORED_BY_TIER[this.enumTier.getIndex()], 4096, 0, "HV", 2, "HV", 0);
    }

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
        this.tickUpdate = this.field_145850_b.field_73012_v.nextInt(WarpDriveConfig.BREATHING_AIR_GENERATION_TICKS);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        --this.tickUpdate;
        if (this.tickUpdate >= 0) {
            return;
        }
        this.tickUpdate = WarpDriveConfig.BREATHING_AIR_GENERATION_TICKS;
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (CelestialObjectManager.hasAtmosphere(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p())) {
            this.updateBlockState(blockState, BlockProperties.ACTIVE, false);
            return;
        }
        boolean isActive = this.releaseAir((EnumFacing)blockState.func_177229_b((IProperty)BlockProperties.FACING));
        this.updateBlockState(blockState, BlockProperties.ACTIVE, isActive);
    }

    private boolean releaseAir(EnumFacing direction) {
        BlockPos posDirection = this.field_174879_c.func_177972_a(direction);
        if (!this.field_145850_b.func_175623_d(posDirection)) {
            return false;
        }
        StateAir stateAir = ChunkHandler.getStateAir(this.field_145850_b, posDirection.func_177958_n(), posDirection.func_177956_o(), posDirection.func_177952_p());
        if (stateAir == null) {
            return true;
        }
        stateAir.updateBlockCache(this.field_145850_b);
        if (!stateAir.isAir()) {
            return false;
        }
        if (this.isEnabled) {
            int energy_cost;
            int n = energy_cost = !stateAir.isAirSource() ? WarpDriveConfig.BREATHING_ENERGY_PER_NEW_AIR_BLOCK_BY_TIER[this.enumTier.getIndex()] : WarpDriveConfig.BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK_BY_TIER[this.enumTier.getIndex()];
            if (this.energy_consume(energy_cost, true)) {
                short range = (short)(WarpDriveConfig.BREATHING_AIR_GENERATION_RANGE_BLOCKS_BY_TIER[this.enumTier.getIndex()] - 1);
                stateAir.setAirSource(this.field_145850_b, direction, range);
                this.energy_consume(energy_cost, false);
                return true;
            }
        }
        if (stateAir.concentration > 4) {
            stateAir.setConcentration(this.field_145850_b, (byte)(stateAir.concentration / 2));
        } else if (stateAir.concentration > 0) {
            stateAir.removeAirSource(this.field_145850_b);
        }
        return false;
    }

    @Override
    public boolean energy_canInput(EnumFacing from) {
        return true;
    }

    @Override
    public Object[] getEnergyRequired() {
        String units = this.energy_getDisplayUnits();
        double energyRequired_newAir = (double)WarpDriveConfig.BREATHING_ENERGY_PER_NEW_AIR_BLOCK_BY_TIER[this.enumTier.getIndex()] / (double)WarpDriveConfig.BREATHING_AIR_GENERATION_TICKS;
        double energyRequired_refresh = (double)WarpDriveConfig.BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK_BY_TIER[this.enumTier.getIndex()] / (double)WarpDriveConfig.BREATHING_AIR_GENERATION_TICKS;
        return new Object[]{true, Float.valueOf((float)EnergyWrapper.convert((long)Math.ceil(energyRequired_newAir * 100.0), units) / 100.0f), Float.valueOf((float)EnergyWrapper.convert((long)Math.ceil(energyRequired_refresh * 100.0), units) / 100.0f)};
    }
}

