/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.collection;

import cr0s.warpdrive.CommonProxy;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityAbstractLaser;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.FluidWrapper;
import cr0s.warpdrive.data.InventoryWrapper;
import cr0s.warpdrive.data.Vector3;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class TileEntityAbstractMiner
extends TileEntityAbstractLaser {
    protected EnumFacing laserOutputSide = EnumFacing.NORTH;
    protected boolean enableSilktouch = false;
    protected Vector3 laserOutput = null;

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
        this.laserOutput = new Vector3(this).translate(0.5).translate(this.laserOutputSide, 0.5);
    }

    protected void harvestBlock(@Nonnull BlockPos blockPos, @Nonnull IBlockState blockState) {
        if (blockState.func_177230_c().isAir(blockState, (IBlockAccess)this.field_145850_b, blockPos)) {
            return;
        }
        if (FluidWrapper.isFluid(blockState)) {
            this.field_145850_b.func_184133_a(null, blockPos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.8f);
            this.field_145850_b.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
        } else {
            NonNullList<ItemStack> itemStackDrops = this.getItemStackFromBlock(blockPos, blockState);
            EntityPlayer entityPlayer = CommonProxy.getFakePlayer(null, (WorldServer)this.field_145850_b, blockPos);
            ForgeEventFactory.fireBlockHarvesting(itemStackDrops, (World)this.func_145831_w(), (BlockPos)blockPos, (IBlockState)blockState, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)entityPlayer);
            this.field_145850_b.func_175718_b(2001, blockPos, Block.func_176210_f((IBlockState)blockState));
            this.field_145850_b.func_175698_g(blockPos);
            if (itemStackDrops != null && blockState.func_177230_c() instanceof IGrowable) {
                for (ItemStack itemStackPlant : itemStackDrops) {
                    if (!(itemStackPlant.func_77973_b() instanceof IPlantable)) continue;
                    IPlantable plantable = (IPlantable)itemStackPlant.func_77973_b();
                    IBlockState blockStatePlant = plantable.getPlant((IBlockAccess)this.field_145850_b, blockPos);
                    if (WarpDriveConfig.LOGGING_COLLECTION) {
                        WarpDrive.logger.info(String.format("Drop includes %s which is plantable %s as block %s", itemStackPlant, plantable, blockStatePlant));
                    }
                    BlockPos blockPosSoil = blockPos.func_177977_b();
                    IBlockState blockStateSoil = this.func_145831_w().func_180495_p(blockPosSoil);
                    if (!blockStateSoil.func_177230_c().canSustainPlant(blockStateSoil, (IBlockAccess)this.field_145850_b, blockPosSoil, EnumFacing.UP, plantable) || !blockStatePlant.func_177230_c().func_176196_c(this.field_145850_b, blockPos)) continue;
                    this.field_145850_b.func_180501_a(blockPos, blockStatePlant, 3);
                    itemStackDrops.remove(itemStackPlant);
                    itemStackPlant.func_190918_g(1);
                    if (itemStackPlant.func_190926_b()) break;
                    itemStackDrops.add(itemStackPlant);
                    break;
                }
            }
            if (InventoryWrapper.addToConnectedInventories(this.field_145850_b, this.field_174879_c, itemStackDrops)) {
                this.setIsEnabled(false);
            }
        }
    }

    @Nullable
    private NonNullList<ItemStack> getItemStackFromBlock(BlockPos blockPos, IBlockState blockState) {
        if (blockState == null) {
            WarpDrive.logger.error(String.format("%s Invalid block %s", this, Commons.format(this.field_145850_b, blockPos)));
            return null;
        }
        NonNullList itemStackDrops = NonNullList.func_191196_a();
        boolean isHarvested = false;
        if (this.enableSilktouch) {
            boolean isSilkHarvestable = false;
            try {
                isSilkHarvestable = blockState.func_177230_c().canSilkHarvest(this.field_145850_b, blockPos, blockState, null);
            }
            catch (Exception exception) {
                exception.printStackTrace(WarpDrive.printStreamError);
            }
            if (isSilkHarvestable) {
                ItemStack itemStackDrop;
                try {
                    itemStackDrop = (ItemStack)WarpDrive.methodBlock_getSilkTouch.invoke((Object)blockState.func_177230_c(), blockState);
                }
                catch (IllegalAccessException | InvocationTargetException exception) {
                    throw new RuntimeException(exception);
                }
                if (!itemStackDrop.func_190926_b()) {
                    itemStackDrops.add((Object)itemStackDrop);
                }
                isHarvested = true;
            }
        }
        try {
            if (!isHarvested) {
                blockState.func_177230_c().getDrops(itemStackDrops, (IBlockAccess)this.field_145850_b, blockPos, blockState, 0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(WarpDrive.printStreamError);
            return null;
        }
        return itemStackDrops;
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.enableSilktouch = tagCompound.func_74767_n("enableSilktouch");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("enableSilktouch", this.enableSilktouch);
        return tagCompound;
    }
}

