/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.collection;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.TileEntityAbstractBase;
import cr0s.warpdrive.block.collection.BlockMiningLaser;
import cr0s.warpdrive.block.collection.TileEntityAbstractMiner;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.EnergyWrapper;
import cr0s.warpdrive.data.EnumComponentType;
import cr0s.warpdrive.data.EnumMiningLaserMode;
import cr0s.warpdrive.data.FluidWrapper;
import cr0s.warpdrive.data.SoundEvents;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.item.ItemComponent;
import cr0s.warpdrive.network.PacketHandler;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Optional;

public class TileEntityMiningLaser
extends TileEntityAbstractMiner {
    private static final TileEntityAbstractBase.UpgradeSlot upgradeSlotPumping = new TileEntityAbstractBase.UpgradeSlot("mining_laser.pumping", ItemComponent.getItemStackNoCache(EnumComponentType.PUMP, 1), 20);
    private static final boolean canSilktouch = WarpDriveConfig.MINING_LASER_MINE_SILKTOUCH_DEUTERIUM_MB <= 0 || FluidRegistry.isFluidRegistered((String)"deuterium");
    private int layerOffset = 1;
    private boolean mineAllBlocks = true;
    private static final int STATE_IDLE = 0;
    private static final int STATE_WARMING_UP = 1;
    private static final int STATE_START_SCANNING = 2;
    private static final int STATE_DO_SCANNING = 3;
    private static final int STATE_MINING = 4;
    private int stateCurrent = 0;
    private int currentLayer;
    private float explosionResistanceMax = 10000.0f;
    private Explosion explosion;
    private float viscosityMax = 0.0f;
    private int radiusX_actual = 0;
    private int radiusZ_actual = 0;
    private int energyScanning = Integer.MAX_VALUE;
    private int energyMining = Integer.MAX_VALUE;
    private int tickUpdateParameters = 0;
    private int tickCurrentTask = 0;
    private boolean isPowered = false;
    private int radiusCapacity = WarpDriveConfig.MINING_LASER_RADIUS_NO_LASER_MEDIUM;
    private final ArrayList<BlockPos> blockPosValuables = new ArrayList();
    private int indexValuable = 0;

    public TileEntityMiningLaser() {
        this.laserOutputSide = EnumFacing.DOWN;
        this.peripheralName = "warpdriveMiningLaser";
        this.addMethods(new String[]{"state", "offset", "onlyOres", "silktouch"});
        this.CC_scripts = Arrays.asList("mine", "stop");
        this.doRequireUpgradeToInterface();
        this.laserMedium_maxCount = WarpDriveConfig.MINING_LASER_MAX_MEDIUMS_COUNT;
        this.registerUpgradeSlot(upgradeSlotPumping);
    }

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
        this.explosion = new Explosion(this.field_145850_b, null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 1.0f, true, true);
        this.explosionResistanceMax = Blocks.field_150343_Z.getExplosionResistance(this.field_145850_b, this.field_174879_c, null, this.explosion);
        this.updateParameters();
    }

    private void updateParameters() {
        this.viscosityMax = this.getUpgradeCount(upgradeSlotPumping) * 2500;
        boolean hasAtmosphere = CelestialObjectManager.hasAtmosphere(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p());
        this.radiusX_actual = this.radiusCapacity = WarpDriveConfig.MINING_LASER_RADIUS_NO_LASER_MEDIUM + (int)Math.floor(this.cache_laserMedium_factor * (double)WarpDriveConfig.MINING_LASER_RADIUS_PER_LASER_MEDIUM);
        this.radiusZ_actual = this.radiusCapacity;
        this.energyScanning = hasAtmosphere ? WarpDriveConfig.MINING_LASER_SCAN_ENERGY_PER_LAYER_IN_ATMOSPHERE : WarpDriveConfig.MINING_LASER_SCAN_ENERGY_PER_LAYER_IN_VOID;
        int n = this.energyMining = hasAtmosphere ? WarpDriveConfig.MINING_LASER_MINE_ENERGY_PER_BLOCK_IN_ATMOSPHERE : WarpDriveConfig.MINING_LASER_MINE_ENERGY_PER_BLOCK_IN_VOID;
        if (!this.mineAllBlocks) {
            this.energyMining = (int)((double)this.energyMining * WarpDriveConfig.MINING_LASER_MINE_ORES_ONLY_ENERGY_FACTOR);
        }
        if (this.enableSilktouch) {
            this.energyMining = (int)((double)this.energyMining * WarpDriveConfig.MINING_LASER_MINE_SILKTOUCH_ENERGY_FACTOR);
        }
        this.enableSilktouch &= canSilktouch;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.isEnabled) {
            if (this.stateCurrent != 0) {
                this.stateCurrent = 0;
                this.tickCurrentTask = 0;
                this.updateBlockState((IBlockState)null, BlockMiningLaser.MODE, EnumMiningLaserMode.INACTIVE);
            }
            if (!this.isInterfaceEnabled()) {
                this.enableSilktouch = false;
                this.layerOffset = 1;
                this.mineAllBlocks = true;
                this.setIsEnabled(true);
            }
            return;
        }
        --this.tickUpdateParameters;
        if (this.tickUpdateParameters <= 0) {
            this.tickUpdateParameters = WarpDriveConfig.MINING_LASER_SETUP_UPDATE_PARAMETERS_TICKS;
            this.updateParameters();
        }
        --this.tickCurrentTask;
        if (this.tickCurrentTask > 0) {
            return;
        }
        switch (this.stateCurrent) {
            case 0: {
                this.currentLayer = this.field_174879_c.func_177956_o() - this.layerOffset - 1;
                if (WarpDriveConfig.LOGGING_COLLECTION) {
                    WarpDrive.logger.info(String.format("%s Starting from Y %d with silktouch %s", this, this.currentLayer, this.enableSilktouch));
                }
                this.stateCurrent = 1;
                this.tickCurrentTask = WarpDriveConfig.MINING_LASER_WARMUP_DELAY_TICKS;
                this.updateBlockState((IBlockState)null, BlockMiningLaser.MODE, EnumMiningLaserMode.SCANNING_LOW_POWER);
                break;
            }
            case 1: {
                this.stateCurrent = 2;
                this.tickCurrentTask = 0;
                this.updateBlockState((IBlockState)null, BlockMiningLaser.MODE, EnumMiningLaserMode.SCANNING_LOW_POWER);
                break;
            }
            case 2: {
                this.isPowered = this.laserMedium_consumeExactly(this.energyScanning, true);
                if (!this.isPowered) {
                    this.tickCurrentTask = WarpDriveConfig.MINING_LASER_WARMUP_DELAY_TICKS;
                    this.updateBlockState((IBlockState)null, BlockMiningLaser.MODE, EnumMiningLaserMode.SCANNING_LOW_POWER);
                    return;
                }
                int age = Math.max(40, 5 * WarpDriveConfig.MINING_LASER_SCAN_DELAY_TICKS);
                int y = this.currentLayer + 1;
                PacketHandler.sendScanningPacket(this.field_145850_b, this.field_174879_c.func_177958_n() - this.radiusX_actual, y, this.field_174879_c.func_177952_p() - this.radiusZ_actual, this.field_174879_c.func_177958_n() + this.radiusX_actual + 1, y, this.field_174879_c.func_177952_p() + this.radiusZ_actual + 1, 0.3f, 0.0f, 1.0f, age);
                this.stateCurrent = 3;
                this.tickCurrentTask = WarpDriveConfig.MINING_LASER_SCAN_DELAY_TICKS;
                this.updateBlockState((IBlockState)null, BlockMiningLaser.MODE, EnumMiningLaserMode.SCANNING_POWERED);
                break;
            }
            case 3: {
                if (this.currentLayer <= 0) {
                    this.setIsEnabled(false);
                    this.tickCurrentTask = 0;
                    return;
                }
                this.isPowered = this.laserMedium_consumeExactly(this.energyScanning, false);
                if (!this.isPowered) {
                    this.updateBlockState((IBlockState)null, BlockMiningLaser.MODE, EnumMiningLaserMode.SCANNING_LOW_POWER);
                    this.tickCurrentTask = WarpDriveConfig.MINING_LASER_WARMUP_DELAY_TICKS;
                    return;
                }
                this.updateBlockState((IBlockState)null, BlockMiningLaser.MODE, EnumMiningLaserMode.SCANNING_POWERED);
                this.scanLayer();
                if (this.blockPosValuables.isEmpty()) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.LASER_LOW, SoundCategory.BLOCKS, 1.0f, 0.85f + 0.3f * this.field_145850_b.field_73012_v.nextFloat());
                    --this.currentLayer;
                    this.tickCurrentTask = WarpDriveConfig.MINING_LASER_SCAN_DELAY_TICKS;
                    return;
                }
                int r = (int)Math.ceil((double)this.radiusCapacity / 2.0);
                int offset = (this.field_174879_c.func_177956_o() - this.currentLayer) % (2 * r);
                int age = Math.max(20, Math.round(2.5f * (float)WarpDriveConfig.MINING_LASER_SCAN_DELAY_TICKS));
                double y = (double)this.currentLayer + 1.0;
                PacketHandler.sendBeamPacket(this.field_145850_b, this.laserOutput, new Vector3(this.field_174879_c.func_177958_n() - r + offset, y, this.field_174879_c.func_177952_p() + r).translate(0.3), 0.0f, 0.0f, 1.0f, age, 0, 50);
                PacketHandler.sendBeamPacket(this.field_145850_b, this.laserOutput, new Vector3(this.field_174879_c.func_177958_n() + r, y, this.field_174879_c.func_177952_p() + r - offset).translate(0.3), 0.0f, 0.0f, 1.0f, age, 0, 50);
                PacketHandler.sendBeamPacket(this.field_145850_b, this.laserOutput, new Vector3(this.field_174879_c.func_177958_n() + r - offset, y, this.field_174879_c.func_177952_p() - r).translate(0.3), 0.0f, 0.0f, 1.0f, age, 0, 50);
                PacketHandler.sendBeamPacket(this.field_145850_b, this.laserOutput, new Vector3(this.field_174879_c.func_177958_n() - r, y, this.field_174879_c.func_177952_p() - r + offset).translate(0.3), 0.0f, 0.0f, 1.0f, age, 0, 50);
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.LASER_HIGH, SoundCategory.BLOCKS, 1.0f, 0.85f + 0.3f * this.field_145850_b.field_73012_v.nextFloat());
                if (this.stateCurrent == 3) {
                    this.stateCurrent = 4;
                }
                this.tickCurrentTask = WarpDriveConfig.MINING_LASER_MINE_DELAY_TICKS;
                this.updateBlockState((IBlockState)null, BlockMiningLaser.MODE, EnumMiningLaserMode.MINING_POWERED);
                break;
            }
            case 4: {
                this.tickCurrentTask = WarpDriveConfig.MINING_LASER_MINE_DELAY_TICKS;
                if (this.indexValuable < 0 || this.indexValuable >= this.blockPosValuables.size()) {
                    this.stateCurrent = 2;
                    this.tickCurrentTask = WarpDriveConfig.MINING_LASER_SCAN_DELAY_TICKS;
                    this.updateBlockState((IBlockState)null, BlockMiningLaser.MODE, EnumMiningLaserMode.SCANNING_POWERED);
                    this.scanLayer();
                    if (this.blockPosValuables.size() <= 0) {
                        --this.currentLayer;
                    }
                    return;
                }
                this.isPowered = this.laserMedium_consumeExactly(this.energyMining, false);
                if (!this.isPowered) {
                    this.updateBlockState((IBlockState)null, BlockMiningLaser.MODE, EnumMiningLaserMode.MINING_LOW_POWER);
                    return;
                }
                this.updateBlockState((IBlockState)null, BlockMiningLaser.MODE, EnumMiningLaserMode.MINING_POWERED);
                BlockPos blockPosValuable = this.blockPosValuables.get(this.indexValuable);
                ++this.indexValuable;
                IBlockState blockStateValuable = this.field_145850_b.func_180495_p(blockPosValuable);
                if (!this.canDig(blockStateValuable, blockPosValuable)) {
                    this.tickCurrentTask = Math.round((float)WarpDriveConfig.MINING_LASER_MINE_DELAY_TICKS * 0.2f);
                    return;
                }
                int age = Math.max(10, Math.round((4.0f + this.field_145850_b.field_73012_v.nextFloat()) * (float)WarpDriveConfig.MINING_LASER_MINE_DELAY_TICKS));
                PacketHandler.sendBeamPacket(this.field_145850_b, this.laserOutput, new Vector3(blockPosValuable).translate(0.5), 1.0f, 1.0f, 0.0f, age, 0, 50);
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.LASER_LOW, SoundCategory.BLOCKS, 1.0f, 0.85f + 0.3f * this.field_145850_b.field_73012_v.nextFloat());
                this.harvestBlock(blockPosValuable, blockStateValuable);
                break;
            }
            default: {
                this.stateCurrent = 0;
                WarpDrive.logger.error(String.format("%s Invalid state %d, please report to mod author", this, this.stateCurrent));
            }
        }
    }

    private boolean canDig(@Nonnull IBlockState blockState, BlockPos blockPos) {
        Block block = blockState.func_177230_c();
        if (this.field_145850_b.func_175623_d(blockPos)) {
            return false;
        }
        if (Dictionary.BLOCKS_SKIPMINING.contains(block)) {
            return false;
        }
        if (Dictionary.BLOCKS_STOPMINING.contains(block)) {
            this.setIsEnabled(false);
            if (WarpDriveConfig.LOGGING_COLLECTION) {
                WarpDrive.logger.info(String.format("%s Mining stopped by %s %s", this, blockState, Commons.format(this.field_145850_b, blockPos)));
            }
            return false;
        }
        if (this.isBlockBreakCanceled(null, this.field_145850_b, blockPos)) {
            this.setIsEnabled(false);
            if (WarpDriveConfig.LOGGING_COLLECTION) {
                WarpDrive.logger.info(String.format("%s Mining stopped by cancelled event %s", this, Commons.format(this.field_145850_b, blockPos)));
            }
            return false;
        }
        Fluid fluid = FluidWrapper.getFluid(blockState);
        if (fluid != null) {
            return this.viscosityMax >= (float)fluid.getViscosity();
        }
        if (Dictionary.BLOCKS_MINING.contains(block) || Dictionary.BLOCKS_ORES.contains(block)) {
            return true;
        }
        float explosionResistance = blockState.func_177230_c().getExplosionResistance(this.field_145850_b, blockPos, null, this.explosion);
        if (explosionResistance <= this.explosionResistanceMax) {
            return true;
        }
        if (WarpDriveConfig.LOGGING_COLLECTION) {
            WarpDrive.logger.info(String.format("%s Rejecting %s %s %s with explosion resistance %.1f", this, blockState, blockState.func_177230_c().getRegistryName(), Commons.format(this.field_145850_b, blockPos), Float.valueOf(explosionResistance)));
        }
        return false;
    }

    private void scanLayer() {
        IBlockState blockState;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(this.field_174879_c);
        for (int y = this.field_174879_c.func_177956_o() - 1; y > this.currentLayer; --y) {
            mutableBlockPos.func_181079_c(this.field_174879_c.func_177958_n(), y, this.field_174879_c.func_177952_p());
            blockState = this.field_145850_b.func_180495_p((BlockPos)mutableBlockPos);
            if (!Dictionary.BLOCKS_STOPMINING.contains(blockState.func_177230_c())) continue;
            this.setIsEnabled(false);
            if (WarpDriveConfig.LOGGING_COLLECTION) {
                WarpDrive.logger.info(String.format("%s Mining stopped by %s %s", this, blockState, Commons.format(this.field_145850_b, this.field_174879_c)));
            }
            return;
        }
        this.blockPosValuables.clear();
        this.indexValuable = 0;
        int x = this.field_174879_c.func_177958_n();
        int z = this.field_174879_c.func_177952_p();
        BlockPos blockPos = new BlockPos(x, this.currentLayer, z);
        blockState = this.field_145850_b.func_180495_p(blockPos);
        if (this.canDig(blockState, blockPos) && (this.mineAllBlocks || Dictionary.BLOCKS_ORES.contains(blockState.func_177230_c()))) {
            this.blockPosValuables.add(blockPos);
        }
        for (int radius = 1; radius <= this.radiusCapacity; ++radius) {
            int xMax = this.field_174879_c.func_177958_n() + radius;
            int xMin = this.field_174879_c.func_177958_n() - radius;
            int zMax = this.field_174879_c.func_177952_p() + radius;
            int zMin = this.field_174879_c.func_177952_p() - radius;
            z = zMin;
            for (x = this.field_174879_c.func_177958_n(); x <= xMax; ++x) {
                blockPos = new BlockPos(x, this.currentLayer, z);
                blockState = this.field_145850_b.func_180495_p(blockPos);
                if (!this.canDig(blockState, blockPos) || !this.mineAllBlocks && !Dictionary.BLOCKS_ORES.contains(blockState.func_177230_c())) continue;
                this.blockPosValuables.add(blockPos);
            }
            x = xMax;
            ++z;
            while (z <= zMax) {
                blockPos = new BlockPos(x, this.currentLayer, z);
                blockState = this.field_145850_b.func_180495_p(blockPos);
                if (this.canDig(blockState, blockPos) && (this.mineAllBlocks || Dictionary.BLOCKS_ORES.contains(blockState.func_177230_c()))) {
                    this.blockPosValuables.add(blockPos);
                }
                ++z;
            }
            --x;
            z = zMax;
            while (x >= xMin) {
                blockPos = new BlockPos(x, this.currentLayer, z);
                blockState = this.field_145850_b.func_180495_p(blockPos);
                if (this.canDig(blockState, blockPos) && (this.mineAllBlocks || Dictionary.BLOCKS_ORES.contains(blockState.func_177230_c()))) {
                    this.blockPosValuables.add(blockPos);
                }
                --x;
            }
            x = xMin;
            --z;
            while (z > zMin) {
                blockPos = new BlockPos(x, this.currentLayer, z);
                blockState = this.field_145850_b.func_180495_p(blockPos);
                if (this.canDig(blockState, blockPos) && (this.mineAllBlocks || Dictionary.BLOCKS_ORES.contains(blockState.func_177230_c()))) {
                    this.blockPosValuables.add(blockPos);
                }
                --z;
            }
            z = zMin;
            for (x = xMin; x < this.field_174879_c.func_177958_n(); ++x) {
                blockPos = new BlockPos(x, this.currentLayer, z);
                blockState = this.field_145850_b.func_180495_p(blockPos);
                if (!this.canDig(blockState, blockPos) || !this.mineAllBlocks && !Dictionary.BLOCKS_ORES.contains(blockState.func_177230_c())) continue;
                this.blockPosValuables.add(blockPos);
            }
        }
        if (WarpDriveConfig.LOGGING_COLLECTION) {
            WarpDrive.logger.info(String.format("%s Found %s valueables", this, this.blockPosValuables.size()));
        }
    }

    @Override
    protected void onUpgradeChanged(@Nonnull TileEntityAbstractBase.UpgradeSlot upgradeSlot, int countNew, boolean isAdded) {
        super.onUpgradeChanged(upgradeSlot, countNew, isAdded);
        if (upgradeSlot.equals(upgradeSlotPumping)) {
            this.updateParameters();
        }
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.layerOffset = tagCompound.func_74762_e("layerOffset");
        this.mineAllBlocks = tagCompound.func_74767_n("mineAllBlocks");
        this.stateCurrent = tagCompound.func_74762_e("stateCurrent");
        this.currentLayer = tagCompound.func_74762_e("currentLayer");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("layerOffset", this.layerOffset);
        tagCompound.func_74757_a("mineAllBlocks", this.mineAllBlocks);
        tagCompound.func_74768_a("stateCurrent", this.stateCurrent);
        tagCompound.func_74768_a("currentLayer", this.currentLayer);
        return tagCompound;
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] state(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.state();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] offset(Context context, Arguments arguments) {
        return this.offset(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] onlyOres(Context context, Arguments arguments) {
        return this.onlyOres(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] silktouch(Context context, Arguments arguments) {
        return this.silktouch(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    private Object[] state() {
        int return_countValuables;
        int return_indexValuable;
        String units = this.energy_getDisplayUnits();
        long energy = EnergyWrapper.convert(this.laserMedium_getEnergyStored(true), units);
        String status = this.getStatusHeaderInPureText();
        if (this.stateCurrent != 0) {
            return_indexValuable = this.indexValuable;
            return_countValuables = this.blockPosValuables.size();
        } else {
            return_indexValuable = 0;
            return_countValuables = 0;
        }
        return new Object[]{status, this.stateCurrent != 0, energy, this.currentLayer, return_indexValuable, return_countValuables};
    }

    @Override
    public Object[] getEnergyRequired() {
        String units = this.energy_getDisplayUnits();
        return new Object[]{true, EnergyWrapper.convert(this.energyScanning, units), EnergyWrapper.convert(this.energyMining, units)};
    }

    private Object[] onlyOres(@Nonnull Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            try {
                this.mineAllBlocks = !Commons.toBool(arguments[0]);
                this.func_70296_d();
            }
            catch (Exception exception) {
                return new Object[]{!this.mineAllBlocks};
            }
        }
        return new Object[]{!this.mineAllBlocks};
    }

    private Object[] offset(@Nonnull Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            try {
                this.layerOffset = Math.min(256, Math.abs(Commons.toInt(arguments[0])));
                this.func_70296_d();
            }
            catch (Exception exception) {
                return new Integer[]{this.layerOffset};
            }
        }
        return new Integer[]{this.layerOffset};
    }

    private Object[] silktouch(@Nonnull Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            try {
                this.enableSilktouch = Commons.toBool(arguments[0]);
                this.func_70296_d();
            }
            catch (Exception exception) {
                return new Object[]{this.enableSilktouch};
            }
        }
        return new Object[]{this.enableSilktouch};
    }

    @Override
    @Optional.Method(modid="computercraft")
    protected Object[] CC_callMethod(@Nonnull String methodName, @Nonnull Object[] arguments) {
        switch (methodName) {
            case "state": {
                return this.state();
            }
            case "offset": {
                return this.offset(arguments);
            }
            case "onlyOres": {
                return this.onlyOres(arguments);
            }
            case "silktouch": {
                return this.silktouch(arguments);
            }
        }
        return super.CC_callMethod(methodName, arguments);
    }

    @Override
    public WarpDriveText getStatusHeader() {
        int energy = this.laserMedium_getEnergyStored(true);
        WarpDriveText textState = new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.error.internal_check_console", new Object[0]);
        if (this.stateCurrent == 0) {
            textState = new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.mining_laser.status_line.idle", new Object[0]);
        } else if (this.stateCurrent == 1) {
            textState = new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.mining_laser.status_line.warming_up", new Object[0]);
        } else if (this.stateCurrent == 2 || this.stateCurrent == 3) {
            textState = this.mineAllBlocks ? new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.mining_laser.status_line.scanning_all", new Object[0]) : new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.mining_laser.status_line.scanning_ores", new Object[0]);
        } else if (this.stateCurrent == 4) {
            textState = !this.enableSilktouch ? (this.mineAllBlocks ? new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.mining_laser.status_line.mining_all", new Object[0]) : new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.mining_laser.status_line.mining_ores", new Object[0])) : (this.mineAllBlocks ? new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.mining_laser.status_line.mining_all_with_silktouch", new Object[0]) : new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.mining_laser.status_line.mining_ores_with_silktouch", new Object[0]));
        }
        if (energy <= 0) {
            textState.appendSibling(new WarpDriveText(Commons.getStyleWarning(), "warpdrive.mining_laser.status_line._insufficient_energy", new Object[0]));
        } else if (!(this.stateCurrent != 2 && this.stateCurrent != 3 && this.stateCurrent != 4 || this.isPowered)) {
            textState.appendSibling(new WarpDriveText(Commons.getStyleWarning(), "warpdrive.mining_laser.status_line._insufficient_energy", new Object[0]));
        }
        return textState;
    }
}

