/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.decoration;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.BlockAbstractBase;
import cr0s.warpdrive.block.decoration.ItemBlockDecorative;
import cr0s.warpdrive.data.EnumDecorativeType;
import cr0s.warpdrive.data.EnumTier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDecorative
extends BlockAbstractBase {
    public static final PropertyEnum<EnumDecorativeType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumDecorativeType.class);
    private static ItemStack[] itemStackCache;

    public BlockDecorative(String registryName, EnumTier enumTier) {
        super(registryName, enumTier, Material.field_151573_f);
        this.func_149713_g(0);
        this.func_149711_c(1.5f);
        this.func_149663_c("warpdrive.decoration.decorative.");
        this.func_180632_j(this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumDecorativeType.PLAIN)));
        itemStackCache = new ItemStack[EnumDecorativeType.length];
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    @Nonnull
    public IBlockState func_176203_a(int metadata) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumDecorativeType.byMetadata(metadata)));
    }

    public int func_176201_c(@Nonnull IBlockState blockState) {
        return ((EnumDecorativeType)((Object)blockState.func_177229_b(TYPE))).ordinal();
    }

    @Override
    @Nullable
    public ItemBlock createItemBlock() {
        return new ItemBlockDecorative(this);
    }

    public void func_149666_a(@Nonnull CreativeTabs creativeTab, @Nonnull NonNullList<ItemStack> list) {
        for (EnumDecorativeType enumDecorativeType : EnumDecorativeType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, enumDecorativeType.ordinal()));
        }
    }

    @Nonnull
    public Material func_149688_o(IBlockState blockState) {
        return blockState == null || blockState.func_177229_b(TYPE) != EnumDecorativeType.GLASS ? Material.field_151573_f : Material.field_151592_s;
    }

    public int func_149717_k(@Nonnull IBlockState blockState) {
        return blockState.func_177229_b(TYPE) != EnumDecorativeType.GLASS ? 255 : 0;
    }

    public boolean func_149662_c(@Nonnull IBlockState blockState) {
        return blockState.func_177229_b(TYPE) != EnumDecorativeType.GLASS;
    }

    public boolean func_149751_l(@Nonnull IBlockState blockState) {
        return blockState.func_177229_b(TYPE) == EnumDecorativeType.GLASS;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos, @Nonnull EnumFacing facing) {
        BlockPos blockPosSide = blockPos.func_177972_a(facing);
        IBlockState blockStateSide = blockAccess.func_180495_p(blockPosSide);
        if (blockStateSide.func_177230_c().isAir(blockStateSide, blockAccess, blockPosSide)) {
            return true;
        }
        if (blockStateSide.func_177230_c() instanceof BlockDecorative && blockState.func_177229_b(TYPE) == EnumDecorativeType.GLASS && blockStateSide.func_177229_b(TYPE) == EnumDecorativeType.GLASS) {
            return false;
        }
        boolean doesSideBlockRendering = blockAccess.func_180495_p(blockPosSide).doesSideBlockRendering(blockAccess, blockPosSide, facing.func_176734_d());
        return !doesSideBlockRendering;
    }

    public int func_180651_a(@Nonnull IBlockState blockState) {
        return blockState.func_177230_c().func_176201_c(blockState);
    }

    @Nonnull
    public static ItemStack getItemStack(EnumDecorativeType enumDecorativeType) {
        if (enumDecorativeType != null) {
            int damage = enumDecorativeType.ordinal();
            if (itemStackCache[damage] == null) {
                BlockDecorative.itemStackCache[damage] = new ItemStack(WarpDrive.blockDecorative, 1, damage);
            }
            return itemStackCache[damage];
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public static ItemStack getItemStackNoCache(@Nonnull EnumDecorativeType enumDecorativeType, int amount) {
        return new ItemStack(WarpDrive.blockDecorative, amount, enumDecorativeType.ordinal());
    }
}

