/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.detection;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.event.ChunkHandler;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

class CloakScanner {
    private final World world;
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int maxX;
    private final int maxY;
    private final int maxZ;
    private final boolean isFullyTransparent;
    private int x;
    private int y;
    private int z;
    private int xChunk;
    private int zChunk;
    private long indexChunk;
    private int volumeChunk;
    private final BlockPos.MutableBlockPos mutableBlockPos;
    public final HashMap<Long, Integer> chunkIndexVolume;

    CloakScanner(@Nonnull World world, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean isFullyTransparent, boolean doLoadChunks) {
        this.world = world;
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.isFullyTransparent = isFullyTransparent;
        int minChunkX = minX >> 4;
        int maxChunkX = maxX >> 4;
        int minChunkZ = minZ >> 4;
        int maxChunkZ = maxZ >> 4;
        this.chunkIndexVolume = new HashMap((maxChunkX - minChunkX + 1) * (maxChunkZ - minChunkZ + 1));
        this.xChunk = minChunkX;
        while (this.xChunk <= maxChunkX) {
            this.zChunk = minChunkZ;
            while (this.zChunk <= maxChunkZ) {
                if (doLoadChunks || ChunkHandler.isLoaded(world, this.xChunk, this.zChunk)) {
                    this.indexChunk = ChunkPos.func_77272_a((int)this.xChunk, (int)this.zChunk);
                    this.chunkIndexVolume.put(this.indexChunk, 0);
                }
                ++this.zChunk;
            }
            ++this.xChunk;
        }
        this.x = this.minX;
        this.y = this.minY;
        this.z = this.minZ;
        this.xChunk = this.x >> 4;
        this.zChunk = this.z >> 4;
        this.indexChunk = ChunkPos.func_77272_a((int)this.xChunk, (int)this.zChunk);
        this.volumeChunk = this.chunkIndexVolume.getOrDefault(this.indexChunk, -1);
        this.mutableBlockPos = new BlockPos.MutableBlockPos(this.x, this.y, this.z);
    }

    boolean tick() {
        int countBlocks = 0;
        try {
            while (countBlocks < WarpDriveConfig.CLOAKING_VOLUME_SCAN_BLOCKS_PER_TICK) {
                if (this.volumeChunk < 0) {
                    this.y = this.maxY;
                } else {
                    this.mutableBlockPos.func_181079_c(this.x, this.y, this.z);
                    IBlockState blockState = this.world.func_180495_p((BlockPos)this.mutableBlockPos);
                    ++countBlocks;
                    if (this.isFullyTransparent) {
                        if (blockState.func_177230_c() != Blocks.field_150350_a) {
                            ++this.volumeChunk;
                        }
                    } else if (!blockState.func_177230_c().isAir(blockState, (IBlockAccess)this.world, (BlockPos)this.mutableBlockPos)) {
                        ++this.volumeChunk;
                    }
                }
                ++this.y;
                if (this.y <= this.maxY) continue;
                this.y = this.minY;
                do {
                    ++this.z;
                    if (this.z > this.maxZ) {
                        this.z = this.minZ;
                        ++this.x;
                        if (this.x > this.maxX) {
                            return true;
                        }
                        this.xChunk = this.x >> 4;
                    }
                    this.zChunk = this.z >> 4;
                    long indexChunkNew = ChunkPos.func_77272_a((int)this.xChunk, (int)this.zChunk);
                    if (indexChunkNew == this.indexChunk) continue;
                    if (this.volumeChunk > 0) {
                        this.chunkIndexVolume.put(this.indexChunk, this.volumeChunk);
                    }
                    this.indexChunk = indexChunkNew;
                    this.volumeChunk = this.chunkIndexVolume.getOrDefault(this.indexChunk, -1);
                } while (this.volumeChunk < 0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(WarpDrive.printStreamError);
            WarpDrive.logger.error(String.format("Exception was encountered around %s", Commons.format(this.world, this.x, this.y, this.z)));
        }
        return false;
    }
}

