/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.detection;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.TileEntityAbstractMachine;
import cr0s.warpdrive.block.detection.BlockBiometricScanner;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.SoundEvents;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.network.PacketHandler;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.Optional;

public class TileEntityBiometricScanner
extends TileEntityAbstractMachine {
    private UUID uuidLastPlayer = null;
    private String nameLastPlayer = "";
    private int tickUpdate;
    private AxisAlignedBB aabbRange = null;
    private int tickScanning = -1;

    public TileEntityBiometricScanner() {
        this.peripheralName = "warpdriveBiometricScanner";
        this.addMethods(new String[]{"getScanResults"});
        this.CC_scripts = Collections.singletonList("scan");
    }

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (blockState.func_177230_c() instanceof BlockBiometricScanner) {
            EnumFacing enumFacing = (EnumFacing)blockState.func_177229_b((IProperty)BlockProperties.FACING);
            float radius = (float)WarpDriveConfig.BIOMETRIC_SCANNER_RANGE_BLOCKS / 2.0f;
            Vector3 v3Center = new Vector3((float)this.field_174879_c.func_177958_n() + 0.5f + (radius + 0.5f) * (float)enumFacing.func_82601_c(), (float)this.field_174879_c.func_177956_o() + 0.5f + (radius + 0.5f) * (float)enumFacing.func_96559_d(), (float)this.field_174879_c.func_177952_p() + 0.5f + (radius + 0.5f) * (float)enumFacing.func_82599_e());
            this.aabbRange = new AxisAlignedBB(v3Center.x - (double)radius, v3Center.y - (double)radius, v3Center.z - (double)radius, v3Center.x + (double)radius, v3Center.y + (double)radius, v3Center.z + (double)radius);
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        --this.tickUpdate;
        if (this.tickUpdate < 0) {
            this.tickUpdate = WarpDriveConfig.G_PARAMETERS_UPDATE_INTERVAL_TICKS;
            IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.updateBlockState(blockState, BlockProperties.ACTIVE, this.isEnabled);
        }
        if (this.isEnabled && this.tickScanning >= 0) {
            --this.tickScanning;
            List playersInRange = this.field_145850_b.func_175647_a(EntityPlayerMP.class, this.aabbRange, entityPlayerMP -> entityPlayerMP != null && entityPlayerMP.func_70089_S() && !entityPlayerMP.func_175149_v());
            boolean isJammed = false;
            boolean isPresent = false;
            for (EntityPlayerMP entityPlayerMP2 : playersInRange) {
                if (entityPlayerMP2.func_110124_au().equals(this.uuidLastPlayer)) {
                    isPresent = true;
                    continue;
                }
                isJammed = true;
                PacketHandler.sendSpawnParticlePacket(this.field_145850_b, "jammed", (byte)5, new Vector3(entityPlayerMP2.field_70165_t, entityPlayerMP2.field_70163_u, entityPlayerMP2.field_70161_v), new Vector3(0.0, 0.0, 0.0), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 32);
            }
            if (!isPresent || isJammed) {
                PacketHandler.sendSpawnParticlePacket(this.field_145850_b, "jammed", (byte)5, new Vector3((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5), new Vector3(0.0, 0.0, 0.0), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 32);
                this.tickScanning = -1;
                this.uuidLastPlayer = null;
                this.nameLastPlayer = "";
                this.sendEvent("biometricScanAborted", new Object[0]);
            } else if (this.tickScanning < 0) {
                this.sendEvent("biometricScanDone", this.uuidLastPlayer.toString(), this.nameLastPlayer);
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.DING, SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else if (this.tickScanning == WarpDriveConfig.BIOMETRIC_SCANNER_DURATION_TICKS - 1) {
                PacketHandler.sendScanningPacket(this.field_145850_b, (int)this.aabbRange.field_72340_a, (int)this.aabbRange.field_72338_b, (int)this.aabbRange.field_72339_c, (int)this.aabbRange.field_72336_d, (int)this.aabbRange.field_72337_e, (int)this.aabbRange.field_72334_f, 0.3f, 0.0f, 1.0f, WarpDriveConfig.BIOMETRIC_SCANNER_DURATION_TICKS);
            }
        }
    }

    public boolean startScanning(@Nonnull EntityPlayer entityPlayer, @Nonnull WarpDriveText textReason) {
        if (!this.isEnabled) {
            textReason.append(Commons.getStyleWarning(), "warpdrive.machine.is_enabled.get.disabled", (int)Math.ceil((float)this.tickScanning / 20.0f));
            return false;
        }
        if (this.tickScanning >= 0) {
            textReason.append(Commons.getStyleWarning(), "warpdrive.biometric_scanner.start_scanning.in_progress", (int)Math.ceil((float)this.tickScanning / 20.0f));
            return false;
        }
        this.uuidLastPlayer = entityPlayer.func_110124_au();
        this.nameLastPlayer = entityPlayer.func_70005_c_();
        this.tickScanning = WarpDriveConfig.BIOMETRIC_SCANNER_DURATION_TICKS;
        textReason.append(Commons.getStyleCorrect(), "warpdrive.biometric_scanner.start_scanning.started", new Object[0]);
        return true;
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (tagCompound.func_186855_b("uuidLastPlayer")) {
            this.uuidLastPlayer = tagCompound.func_186857_a("uuidLastPlayer");
            this.nameLastPlayer = tagCompound.func_74779_i("nameLastPlayer");
        } else {
            this.uuidLastPlayer = null;
            this.nameLastPlayer = "";
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        if (this.tickScanning < 0 && this.uuidLastPlayer != null && this.uuidLastPlayer.getMostSignificantBits() != 0L && this.uuidLastPlayer.getLeastSignificantBits() != 0L) {
            tagCompound.func_186854_a("uuidLastPlayer", this.uuidLastPlayer);
            tagCompound.func_74778_a("nameLastPlayer", this.nameLastPlayer);
        } else {
            tagCompound.func_82580_o("uuidLastPlayer");
            tagCompound.func_82580_o("nameLastPlayer");
        }
        return tagCompound;
    }

    @Nonnull
    private WarpDriveText getScanStatus() {
        if (this.tickScanning >= 0) {
            return new WarpDriveText(Commons.getStyleWarning(), "warpdrive.biometric_scanner.status_line.scan_in_progress", (int)Math.ceil((float)this.tickScanning / 20.0f));
        }
        if (this.uuidLastPlayer == null) {
            return new WarpDriveText(Commons.getStyleWarning(), "warpdrive.biometric_scanner.status_line.invalid", new Object[0]);
        }
        return new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.biometric_scanner.status_line.valid", this.nameLastPlayer, this.uuidLastPlayer);
    }

    @Override
    public WarpDriveText getStatus() {
        WarpDriveText textScanStatus = this.getScanStatus();
        if (textScanStatus.func_150260_c().isEmpty()) {
            return super.getStatus();
        }
        return super.getStatus().append((ITextComponent)textScanStatus);
    }

    public Object[] getScanResults() {
        if (this.tickScanning >= 0) {
            return new Object[]{false, "Scan is in progress..."};
        }
        if (this.uuidLastPlayer == null) {
            return new Object[]{false, "No results available."};
        }
        return new Object[]{true, this.uuidLastPlayer, this.nameLastPlayer};
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getScanResults(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getScanResults();
    }

    @Override
    @Optional.Method(modid="computercraft")
    protected Object[] CC_callMethod(@Nonnull String methodName, @Nonnull Object[] arguments) {
        switch (methodName) {
            case "getScanResults": {
                return this.getScanResults();
            }
        }
        return super.CC_callMethod(methodName, arguments);
    }
}

