/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.detection;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.TileEntityAbstractBase;
import cr0s.warpdrive.block.TileEntityAbstractEnergyCoreOrController;
import cr0s.warpdrive.block.detection.BlockCloakingCoil;
import cr0s.warpdrive.block.detection.CloakScanner;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.CloakedArea;
import cr0s.warpdrive.data.EnergyWrapper;
import cr0s.warpdrive.data.EnumComponentType;
import cr0s.warpdrive.data.SoundEvents;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.item.ItemComponent;
import cr0s.warpdrive.network.PacketHandler;
import gnu.trove.iterator.TLongIntIterator;
import gnu.trove.map.hash.TLongIntHashMap;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class TileEntityCloakingCore
extends TileEntityAbstractEnergyCoreOrController {
    private static final int CLOAKING_CORE_SOUND_UPDATE_TICKS = 40;
    private static final int DISTANCE_INNER_COILS_BLOCKS = 2;
    private static final int LASER_REFRESH_TICKS = 100;
    private static final int LASER_DURATION_TICKS = 110;
    private static final float[] innerCoilColor_r = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 0.75f, 0.25f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 1.0f};
    private static final float[] innerCoilColor_g = new float[]{0.0f, 0.25f, 0.75f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.5f, 0.25f, 0.0f, 0.0f};
    private static final float[] innerCoilColor_b = new float[]{0.25f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f, 1.0f, 0.75f};
    private static final TileEntityAbstractBase.UpgradeSlot upgradeSlotTransparency = new TileEntityAbstractBase.UpgradeSlot("cloaking.transparency", ItemComponent.getItemStackNoCache(EnumComponentType.DIAMOND_CRYSTAL, 6), 1);
    private final boolean[] isValidInnerCoils = new boolean[]{false, false, false, false, false, false};
    private final int[] distanceOuterCoils_blocks = new int[]{0, 0, 0, 0, 0, 0};
    private final TLongIntHashMap chunkIndexVolume = new TLongIntHashMap();
    private int minX = 0;
    private int minY = 0;
    private int minZ = 0;
    private int maxX = 0;
    private int maxY = 0;
    private int maxZ = 0;
    private AxisAlignedBB aabbArea = null;
    private boolean isFullyTransparent = false;
    private boolean isFullScanRequired = false;
    private boolean isCloaking = false;
    private long timeLastCloakScanDone = -1L;
    private CloakScanner cloakScanner = null;
    private int volume = 0;
    private int energyRequired = 0;
    private int updateRate_ticks = 1;
    private int updateTicks = 0;
    private int laserDrawingTicks = 0;
    private boolean soundPlayed = false;
    private int soundTicks = 0;

    public TileEntityCloakingCore() {
        this.peripheralName = "warpdriveCloakingCore";
        this.CC_scripts = Arrays.asList("enable", "disable");
        this.registerUpgradeSlot(upgradeSlotTransparency);
    }

    @Override
    protected void onConstructed() {
        super.onConstructed();
        this.energy_setParameters(WarpDriveConfig.CLOAKING_MAX_ENERGY_STORED, 16384, 0, "EV", 2, "HV", 0);
        this.isFullyTransparent = this.hasUpgrade(upgradeSlotTransparency);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        --this.soundTicks;
        if (this.soundTicks < 0) {
            this.soundTicks = 40;
            this.soundPlayed = false;
        }
        if (this.isFullScanRequired || this.timeLastCloakScanDone + (long)WarpDriveConfig.CLOAKING_VOLUME_SCAN_AGE_TOLERANCE_SECONDS * 20L < this.field_145850_b.func_82737_E()) {
            this.timeLastCloakScanDone = -1L;
        }
        if (this.timeLastCloakScanDone <= 0L) {
            this.timeLastCloakScanDone = this.field_145850_b.func_82737_E();
            if (this.minX != this.field_174879_c.func_177958_n() && this.maxX != this.field_174879_c.func_177958_n() && this.minY != this.field_174879_c.func_177956_o() && this.maxY != this.field_174879_c.func_177956_o() && this.minZ != this.field_174879_c.func_177952_p() && this.maxZ != this.field_174879_c.func_177952_p()) {
                this.cloakScanner = new CloakScanner(this.field_145850_b, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, this.isFullyTransparent, this.isFullScanRequired);
                this.isFullScanRequired = false;
                if (WarpDriveConfig.LOGGING_CLOAKING) {
                    WarpDrive.logger.info(String.format("%s scanning started", this));
                }
            }
        }
        if (this.cloakScanner != null && this.cloakScanner.tick()) {
            for (Map.Entry<Long, Integer> entryChunkIndexVolume : this.cloakScanner.chunkIndexVolume.entrySet()) {
                this.chunkIndexVolume.put(entryChunkIndexVolume.getKey().longValue(), entryChunkIndexVolume.getValue().intValue());
            }
            this.cloakScanner = null;
            if (WarpDriveConfig.LOGGING_CLOAKING) {
                WarpDrive.logger.info(String.format("%s scanning done", this));
            }
        }
        boolean isLaserRefreshNeeded = false;
        --this.updateTicks;
        if (this.updateTicks <= 0) {
            boolean shouldBeCloaking;
            this.updateTicks = this.updateRate_ticks;
            this.isCloaking = WarpDrive.cloaks.isAreaExists(this.field_145850_b, this.field_174879_c);
            boolean hasEnoughPower = this.energy_consume(this.energyRequired, !this.isAssemblyValid || !this.isEnabled);
            boolean isVolumeDefined = this.volume > 13;
            boolean bl = shouldBeCloaking = this.isAssemblyValid && isVolumeDefined && this.isEnabled && hasEnoughPower;
            if (!this.isCloaking) {
                if (shouldBeCloaking) {
                    this.updateCoils(true, true);
                    isLaserRefreshNeeded = true;
                    CloakedArea area = WarpDrive.cloaks.updateCloakedArea(this.field_145850_b, this.field_174879_c, this.isFullyTransparent, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
                    if (!this.soundPlayed) {
                        this.soundPlayed = true;
                        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.CLOAK, SoundCategory.BLOCKS, 4.0f, 1.0f);
                    }
                    area.sendCloakPacketToPlayersEx(false);
                }
            } else if (shouldBeCloaking) {
                CloakedArea area = WarpDrive.cloaks.getCloakedArea(this.field_145850_b, this.field_174879_c);
                if (area == null) {
                    WarpDrive.logger.error(String.format("Cloaked area lost %s", Commons.format(this.field_145850_b, this.field_174879_c)));
                } else {
                    area.sendCloakPacketToPlayersEx(false);
                }
            } else {
                if (WarpDriveConfig.LOGGING_CLOAKING) {
                    WarpDrive.logger.info(String.format("%s Disabled, cloak field going down...", this));
                }
                if (this.isEnabled) {
                    if (!this.isAssemblyValid) {
                        if (WarpDriveConfig.LOGGING_CLOAKING) {
                            WarpDrive.logger.info(String.format("%s Coil(s) lost, cloak field is collapsing...", this));
                        }
                        this.energy_consume(this.energy_getEnergyStored());
                    } else if (!hasEnoughPower && WarpDriveConfig.LOGGING_CLOAKING) {
                        WarpDrive.logger.info(String.format("%s Low power, cloak field is collapsing...", this));
                    }
                }
                this.updateCoils(true, false);
                this.disableCloakingField();
            }
        }
        --this.laserDrawingTicks;
        if (isLaserRefreshNeeded || this.laserDrawingTicks <= 0) {
            this.laserDrawingTicks = 100;
            if (this.isEnabled && this.isAssemblyValid) {
                this.drawLasers();
            }
        }
    }

    @Override
    public void onBlockBroken(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState) {
        this.setIsEnabled(false);
        this.updateCoils(false, false);
        this.disableCloakingField();
        super.onBlockBroken(world, blockPos, blockState);
    }

    @Override
    protected boolean doScanAssembly(boolean isDirty, WarpDriveText textReason) {
        boolean isValid = super.doScanAssembly(isDirty, textReason);
        int maxOuterCoilDistance = WarpDriveConfig.CLOAKING_MAX_FIELD_RADIUS - WarpDriveConfig.CLOAKING_COIL_CAPTURE_BLOCKS;
        boolean isRefreshNeeded = false;
        int countIntegrity = 1;
        StringBuilder messageInnerCoils = new StringBuilder();
        StringBuilder messageOuterCoils = new StringBuilder();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (EnumFacing direction : EnumFacing.values()) {
            int oldCoilDistance;
            mutableBlockPos.func_189533_g((Vec3i)this.field_174879_c).func_189534_c(direction, 2);
            IBlockState blockState = this.field_145850_b.func_180495_p((BlockPos)mutableBlockPos);
            boolean isInnerValid = blockState.func_177230_c() instanceof BlockCloakingCoil;
            if (isInnerValid) {
                BlockCloakingCoil.setBlockState(this.field_145850_b, (BlockPos)mutableBlockPos, blockState, true, this.isCloaking, false, direction);
            }
            if (isInnerValid != this.isValidInnerCoils[direction.ordinal()]) {
                isRefreshNeeded = true;
                this.isValidInnerCoils[direction.ordinal()] = isInnerValid;
            }
            if (this.isValidInnerCoils[direction.ordinal()]) {
                ++countIntegrity;
            } else {
                if (messageInnerCoils.length() != 0) {
                    messageInnerCoils.append(", ");
                }
                messageInnerCoils.append(direction.name());
            }
            mutableBlockPos.func_189533_g((Vec3i)this.field_174879_c).func_189534_c(direction, this.distanceOuterCoils_blocks[direction.ordinal()]);
            blockState = this.field_145850_b.func_180495_p((BlockPos)mutableBlockPos);
            boolean isActualOuterValid = blockState.func_177230_c() instanceof BlockCloakingCoil;
            if (isActualOuterValid) {
                BlockCloakingCoil.setBlockState(this.field_145850_b, (BlockPos)mutableBlockPos, blockState, true, this.isCloaking, true, direction);
                ++countIntegrity;
                continue;
            }
            int newCoilDistance = 0;
            for (int distance = 3; distance < maxOuterCoilDistance; ++distance) {
                mutableBlockPos.func_189533_g((Vec3i)this.field_174879_c).func_189534_c(direction, distance);
                blockState = this.field_145850_b.func_180495_p((BlockPos)mutableBlockPos);
                if (!(blockState.func_177230_c() instanceof BlockCloakingCoil)) continue;
                BlockCloakingCoil.setBlockState(this.field_145850_b, (BlockPos)mutableBlockPos, blockState, true, this.isCloaking, true, direction);
                newCoilDistance = distance;
                break;
            }
            if (newCoilDistance != (oldCoilDistance = this.distanceOuterCoils_blocks[direction.ordinal()])) {
                isRefreshNeeded = true;
                this.distanceOuterCoils_blocks[direction.ordinal()] = newCoilDistance;
            }
            if (newCoilDistance > 0) {
                ++countIntegrity;
                continue;
            }
            if (messageOuterCoils.length() != 0) {
                messageOuterCoils.append(", ");
            }
            messageOuterCoils.append(direction.name());
        }
        float integrity = (float)countIntegrity / 13.0f;
        if (messageInnerCoils.length() > 0 && messageOuterCoils.length() > 0) {
            textReason.append(Commons.getStyleWarning(), "warpdrive.cloaking_core.missing_channeling_and_projecting_coils", Math.round(100.0f * integrity), messageInnerCoils, messageOuterCoils);
        } else if (messageInnerCoils.length() > 0) {
            textReason.append(Commons.getStyleWarning(), "warpdrive.cloaking_core.missing_channeling_coils", Math.round(100.0f * integrity), messageInnerCoils);
        } else if (messageOuterCoils.length() > 0) {
            textReason.append(Commons.getStyleWarning(), "warpdrive.cloaking_core.missing_projecting_coils", Math.round(100.0f * integrity), messageOuterCoils);
        } else {
            textReason.append(Commons.getStyleCorrect(), "warpdrive.cloaking_core.valid", new Object[0]);
        }
        boolean isFullyTransparent_new = this.hasUpgrade(upgradeSlotTransparency);
        if (this.isFullyTransparent != isFullyTransparent_new) {
            isRefreshNeeded = true;
            this.isFullyTransparent = isFullyTransparent_new;
        }
        isValid = isValid && countIntegrity >= 13;
        this.minX = this.field_174879_c.func_177958_n() - this.distanceOuterCoils_blocks[4] - WarpDriveConfig.CLOAKING_COIL_CAPTURE_BLOCKS;
        this.maxX = this.field_174879_c.func_177958_n() + this.distanceOuterCoils_blocks[5] + WarpDriveConfig.CLOAKING_COIL_CAPTURE_BLOCKS;
        this.minY = Math.max(0, this.field_174879_c.func_177956_o() - this.distanceOuterCoils_blocks[0] - WarpDriveConfig.CLOAKING_COIL_CAPTURE_BLOCKS);
        this.maxY = Math.min(255, this.field_174879_c.func_177956_o() + this.distanceOuterCoils_blocks[1] + WarpDriveConfig.CLOAKING_COIL_CAPTURE_BLOCKS);
        this.minZ = this.field_174879_c.func_177952_p() - this.distanceOuterCoils_blocks[2] - WarpDriveConfig.CLOAKING_COIL_CAPTURE_BLOCKS;
        this.maxZ = this.field_174879_c.func_177952_p() + this.distanceOuterCoils_blocks[3] + WarpDriveConfig.CLOAKING_COIL_CAPTURE_BLOCKS;
        if (this.aabbArea == null || isRefreshNeeded) {
            this.aabbArea = new AxisAlignedBB((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
        }
        if (this.isCloaking && isRefreshNeeded) {
            this.disableCloakingField();
        }
        if (!isValid) {
            this.cloakScanner = null;
            this.chunkIndexVolume.clear();
        }
        if (isValid && isRefreshNeeded) {
            if (this.cloakScanner != null) {
                if (WarpDriveConfig.LOGGING_CLOAKING) {
                    WarpDrive.logger.info(String.format("%s Aborting current scan due to major changes detected.", this));
                }
                this.cloakScanner = null;
            }
            this.isFullScanRequired = true;
        }
        return isValid;
    }

    @Override
    protected void doUpdateParameters(boolean isDirty) {
        super.doUpdateParameters(isDirty);
        int minChunkX = this.minX >> 4;
        int maxChunkX = this.maxX >> 4;
        int minChunkZ = this.minZ >> 4;
        int maxChunkZ = this.maxZ >> 4;
        int volume_new = 0;
        TLongIntIterator longIntIterator = this.chunkIndexVolume.iterator();
        while (longIntIterator.hasNext()) {
            longIntIterator.advance();
            long chunkIndex = longIntIterator.key();
            int chunkX = (int)(chunkIndex & 0xFFFFFFFFL);
            int chunkZ = (int)(chunkIndex >> 32 & 0xFFFFFFFFL);
            if (chunkX < minChunkX || chunkX > maxChunkX || chunkZ < minChunkZ || chunkZ > maxChunkZ) {
                longIntIterator.remove();
                if (WarpDrive.isDev && WarpDriveConfig.LOGGING_CLOAKING) {
                    WarpDrive.logger.info(String.format("%s Chunk (%d %d) %s was removed from cache.", this, chunkX, chunkZ, Commons.format(this.field_145850_b, new ChunkPos(chunkX, chunkZ).func_180331_a(8, 128, 8))));
                }
            }
            if (WarpDrive.isDev && WarpDriveConfig.LOGGING_CLOAKING) {
                WarpDrive.logger.info(String.format("%s Chunk (%d %d) %s has a volume of %d blocks.", this, chunkX, chunkZ, Commons.format(this.field_145850_b, new ChunkPos(chunkX, chunkZ).func_180331_a(8, 128, 8)), longIntIterator.value()));
            }
            volume_new += longIntIterator.value();
        }
        this.volume = volume_new;
        if (this.isFullyTransparent) {
            this.energyRequired = this.volume * WarpDriveConfig.CLOAKING_TIER2_ENERGY_PER_BLOCK;
            this.updateRate_ticks = WarpDriveConfig.CLOAKING_TIER2_FIELD_REFRESH_INTERVAL_TICKS;
        } else {
            this.energyRequired = this.volume * WarpDriveConfig.CLOAKING_TIER1_ENERGY_PER_BLOCK;
            this.updateRate_ticks = WarpDriveConfig.CLOAKING_TIER1_FIELD_REFRESH_INTERVAL_TICKS;
        }
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(String.format("%s Requiring %d EU for %d blocks", this, this.energyRequired, this.volume));
        }
    }

    private void updateCoils(boolean isConnected, boolean isActive) {
        if (isConnected) {
            this.updateBlockState((IBlockState)null, BlockProperties.ACTIVE, isActive);
        }
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            if (this.isValidInnerCoils[direction.ordinal()]) {
                this.updateCoil(isConnected, isActive, direction, 2);
            }
            if (this.distanceOuterCoils_blocks[direction.ordinal()] <= 0) continue;
            this.updateCoil(isConnected, isActive, direction, this.distanceOuterCoils_blocks[direction.ordinal()]);
        }
    }

    private void updateCoil(boolean isConnected, boolean isActive, EnumFacing direction, int distance) {
        BlockPos blockPos = this.field_174879_c.func_177967_a(direction, distance);
        IBlockState blockState = this.field_145850_b.func_180495_p(blockPos);
        if (blockState.func_177230_c() instanceof BlockCloakingCoil) {
            if (isConnected) {
                if (distance == 2) {
                    BlockCloakingCoil.setBlockState(this.field_145850_b, blockPos, blockState, true, isActive, false, EnumFacing.DOWN);
                } else {
                    BlockCloakingCoil.setBlockState(this.field_145850_b, blockPos, blockState, true, isActive, true, direction);
                }
            } else {
                BlockCloakingCoil.setBlockState(this.field_145850_b, blockPos, blockState, false, false, true, EnumFacing.DOWN);
            }
        }
    }

    private void drawLasers() {
        float b;
        float g;
        float r;
        if (!this.isCloaking) {
            r = 0.75f;
            g = 0.5f;
            b = 0.5f;
        } else if (!this.isFullyTransparent) {
            r = 0.0f;
            g = 1.0f;
            b = 0.25f;
        } else {
            r = 0.0f;
            g = 0.25f;
            b = 1.0f;
        }
        for (EnumFacing direction : EnumFacing.values()) {
            if (!this.isValidInnerCoils[direction.ordinal()] || this.distanceOuterCoils_blocks[direction.ordinal()] <= 0) continue;
            PacketHandler.sendBeamPacketToPlayersInArea(this.field_145850_b, new Vector3((double)this.field_174879_c.func_177958_n() + 0.5 + 2.3 * (double)direction.func_82601_c(), (double)this.field_174879_c.func_177956_o() + 0.5 + 2.3 * (double)direction.func_96559_d(), (double)this.field_174879_c.func_177952_p() + 0.5 + 2.3 * (double)direction.func_82599_e()), new Vector3((double)this.field_174879_c.func_177958_n() + 0.5 + (double)(this.distanceOuterCoils_blocks[direction.ordinal()] * direction.func_82601_c()), (double)this.field_174879_c.func_177956_o() + 0.5 + (double)(this.distanceOuterCoils_blocks[direction.ordinal()] * direction.func_96559_d()), (double)this.field_174879_c.func_177952_p() + 0.5 + (double)(this.distanceOuterCoils_blocks[direction.ordinal()] * direction.func_82599_e())), r, g, b, 110, this.aabbArea);
        }
        for (int i = 0; i < 5; ++i) {
            EnumFacing start = EnumFacing.field_82609_l[i];
            for (int j = i + 1; j < 6; ++j) {
                EnumFacing stop = EnumFacing.field_82609_l[j];
                if (start.func_176734_d() == stop) continue;
                int mapIndex = this.field_145850_b.field_73012_v.nextInt(innerCoilColor_b.length);
                r = innerCoilColor_r[mapIndex];
                g = innerCoilColor_g[mapIndex];
                b = innerCoilColor_b[mapIndex];
                PacketHandler.sendBeamPacketToPlayersInArea(this.field_145850_b, new Vector3((double)this.field_174879_c.func_177958_n() + 0.5 + 2.3 * (double)start.func_82601_c() + 0.2 * (double)stop.func_82601_c(), (double)this.field_174879_c.func_177956_o() + 0.5 + 2.3 * (double)start.func_96559_d() + 0.2 * (double)stop.func_96559_d(), (double)this.field_174879_c.func_177952_p() + 0.5 + 2.3 * (double)start.func_82599_e() + 0.2 * (double)stop.func_82599_e()), new Vector3((double)this.field_174879_c.func_177958_n() + 0.5 + 2.3 * (double)stop.func_82601_c() + 0.2 * (double)start.func_82601_c(), (double)this.field_174879_c.func_177956_o() + 0.5 + 2.3 * (double)stop.func_96559_d() + 0.2 * (double)start.func_96559_d(), (double)this.field_174879_c.func_177952_p() + 0.5 + 2.3 * (double)stop.func_82599_e() + 0.2 * (double)start.func_82599_e()), r, g, b, 110, this.aabbArea);
            }
        }
    }

    public void disableCloakingField() {
        if (WarpDrive.cloaks.isAreaExists(this.field_145850_b, this.field_174879_c)) {
            WarpDrive.cloaks.removeCloakedArea(this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c);
            if (!this.soundPlayed) {
                this.soundPlayed = true;
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.DECLOAK, SoundCategory.BLOCKS, 4.0f, 1.0f);
            }
        }
    }

    @Override
    public WarpDriveText getStatusHeader() {
        if (this.field_145850_b == null) {
            return super.getStatusHeader();
        }
        WarpDriveText textStatus = !this.isAssemblyValid ? this.textValidityIssues : (!this.isEnabled ? new WarpDriveText(Commons.getStyleNormal(), "warpdrive.cloaking_core.disabled", this.isFullyTransparent ? 2 : 1, this.volume) : (!this.isCloaking ? new WarpDriveText(Commons.getStyleWarning(), "warpdrive.cloaking_core.low_power", this.isFullyTransparent ? 2 : 1, this.volume) : new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.cloaking_core.cloaking", this.isFullyTransparent ? 2 : 1, this.volume)));
        return super.getStatusHeader().append((ITextComponent)textStatus);
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        byte[] isValidInnerCoilsAsBytes = tagCompound.func_74770_j("isValidInnerCoils");
        byte[] distanceOuterCoilsAsBytes = tagCompound.func_74770_j("distanceOuterCoils");
        if (isValidInnerCoilsAsBytes.length == 6 && distanceOuterCoilsAsBytes.length == 6) {
            for (int index = 0; index < 6; ++index) {
                this.isValidInnerCoils[index] = isValidInnerCoilsAsBytes[index] != 0;
                this.distanceOuterCoils_blocks[index] = distanceOuterCoilsAsBytes[index];
            }
        }
        NBTTagList tagList = tagCompound.func_150295_c("chunks", 10);
        this.chunkIndexVolume.clear();
        for (NBTBase tagBaseEntry : tagList) {
            NBTTagCompound tagCompoundEntry = (NBTTagCompound)tagBaseEntry;
            long chunkIndex = tagCompoundEntry.func_74763_f("index");
            int chunkVolume = tagCompoundEntry.func_74762_e("volume");
            this.chunkIndexVolume.put(chunkIndex, chunkVolume);
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        byte[] isValidInnerCoilsAsBytes = new byte[6];
        byte[] distanceOuterCoilsAsBytes = new byte[6];
        for (int index = 0; index < 6; ++index) {
            isValidInnerCoilsAsBytes[index] = this.isValidInnerCoils[index] ? (byte)1 : 0;
            distanceOuterCoilsAsBytes[index] = (byte)this.distanceOuterCoils_blocks[index];
        }
        tagCompound.func_74773_a("isValidInnerCoils", isValidInnerCoilsAsBytes);
        tagCompound.func_74773_a("distanceOuterCoils", distanceOuterCoilsAsBytes);
        NBTTagList tagList = new NBTTagList();
        this.chunkIndexVolume.forEachEntry((chunkIndex, chunkVolume) -> {
            NBTTagCompound tagCompoundEntry = new NBTTagCompound();
            tagCompoundEntry.func_74772_a("index", chunkIndex);
            tagCompoundEntry.func_74768_a("volume", chunkVolume);
            tagList.func_74742_a((NBTBase)tagCompoundEntry);
            return true;
        });
        tagCompound.func_74782_a("chunks", (NBTBase)tagList);
        return tagCompound;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tagCompound = super.func_189517_E_();
        tagCompound.func_82580_o("chunks");
        return tagCompound;
    }

    @Override
    public void onDataPacket(@Nonnull NetworkManager networkManager, @Nonnull SPacketUpdateTileEntity packet) {
        super.onDataPacket(networkManager, packet);
    }

    @Override
    public Object[] getEnergyRequired() {
        String units = this.energy_getDisplayUnits();
        double energyRate = (double)this.energyRequired / (double)this.updateRate_ticks;
        return new Object[]{true, EnergyWrapper.convert((long)Math.ceil(energyRate), units)};
    }

    @Override
    public boolean energy_canInput(EnumFacing from) {
        return true;
    }
}

