/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.detection;

import cr0s.warpdrive.block.TileEntityAbstractMachine;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.StateAir;
import cr0s.warpdrive.event.ChunkHandler;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.Optional;

public class TileEntityEnvironmentalSensor
extends TileEntityAbstractMachine {
    private int tickUpdate;
    private int airConcentration;

    public TileEntityEnvironmentalSensor() {
        this.peripheralName = "warpdriveEnvironmentalSensor";
        this.addMethods(new String[]{"getAtmosphere", "getBiome", "getHumidity", "getTemperature", "getWeather", "getWorldTime"});
        this.CC_scripts = Collections.singletonList("clock");
    }

    @Override
    public void func_73660_a() {
        StateAir stateAir;
        boolean hasAtmosphere;
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        --this.tickUpdate;
        if (this.tickUpdate >= 0) {
            return;
        }
        this.tickUpdate = WarpDriveConfig.G_PARAMETERS_UPDATE_INTERVAL_TICKS;
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.updateBlockState(blockState, BlockProperties.ACTIVE, this.isEnabled);
        CelestialObject celestialObject = CelestialObjectManager.get(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p());
        boolean bl = hasAtmosphere = celestialObject != null && celestialObject.hasAtmosphere();
        this.airConcentration = hasAtmosphere ? 32 : (int)((stateAir = ChunkHandler.getStateAir(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p())) == null ? (byte)0 : stateAir.concentration);
    }

    public Object[] getAtmosphere() {
        if (!this.isEnabled) {
            return new Object[]{false, "Sensor is disabled."};
        }
        return new Object[]{true, this.airConcentration > 0, this.airConcentration};
    }

    public Object[] getBiome() {
        if (!this.isEnabled) {
            return new Object[]{false, "Sensor is disabled."};
        }
        Biome biome = this.field_145850_b.func_180494_b(this.field_174879_c);
        Set types = BiomeDictionary.getTypes((Biome)biome);
        Object[] result = new Object[2 + types.size()];
        result[0] = true;
        result[1] = biome.field_76791_y;
        int index = 2;
        for (BiomeDictionary.Type type : types) {
            result[index] = type.getName();
            ++index;
        }
        return result;
    }

    public Object[] getHumidity() {
        if (!this.isEnabled) {
            return new Object[]{false, "Sensor is disabled."};
        }
        Biome biome = this.field_145850_b.func_180494_b(this.field_174879_c);
        float rainfall = biome.func_76727_i();
        return new Object[]{true, rainfall > 0.85f ? "WET" : (rainfall < 0.15f ? "DRY" : "MEDIUM"), Float.valueOf(rainfall)};
    }

    public Object[] getTemperature() {
        if (!this.isEnabled) {
            return new Object[]{false, "Sensor is disabled."};
        }
        Biome biome = this.field_145850_b.func_180494_b(this.field_174879_c);
        return new Object[]{true, biome.func_150561_m().name(), Float.valueOf(biome.func_180626_a(this.field_174879_c))};
    }

    private boolean isSnowNotRain() {
        Biome biome = this.field_145850_b.func_180494_b(this.field_174879_c);
        if (biome.func_76746_c()) {
            return true;
        }
        int precipitationHeight = this.field_145850_b.func_175725_q(this.field_174879_c).func_177956_o();
        float rawTemperature = biome.func_180626_a(this.field_174879_c);
        float correctedTemperature = this.field_145850_b.func_72959_q().func_76939_a(rawTemperature, precipitationHeight);
        return correctedTemperature < 0.15f;
    }

    public Object[] getWeather() {
        if (!this.isEnabled) {
            return new Object[]{false, "Sensor is disabled."};
        }
        if (this.field_145850_b.func_72911_I()) {
            if (this.isSnowNotRain()) {
                return new Object[]{true, "BLIZZARD", this.field_145850_b.func_72912_H().func_76071_n() / 20};
            }
            return new Object[]{true, "THUNDER", this.field_145850_b.func_72912_H().func_76071_n() / 20};
        }
        if (this.field_145850_b.func_72896_J()) {
            if (this.isSnowNotRain()) {
                return new Object[]{true, "SNOW", this.field_145850_b.func_72912_H().func_76083_p() / 20};
            }
            return new Object[]{true, "RAIN", this.field_145850_b.func_72912_H().func_76083_p() / 20};
        }
        return new Object[]{true, "CLEAR", this.field_145850_b.func_72912_H().func_176133_A() / 20};
    }

    public Object[] getWorldTime() {
        if (!this.isEnabled) {
            return new Object[]{false, "Sensor is disabled."};
        }
        int day = (int)((6000L + this.field_145850_b.func_72820_D()) / 24000L);
        int dayTime = 2400 * (int)((6000L + this.field_145850_b.func_72820_D()) % 24000L) / 24000;
        return new Object[]{true, day, dayTime / 100, dayTime % 100 * 60 / 100, this.field_145850_b.func_82737_E() / 20L};
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getAtmosphere(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getAtmosphere();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getBiome(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getBiome();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getHumidity(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getHumidity();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getTemperature(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getTemperature();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getWeather(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getWeather();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getWorldTime(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getWorldTime();
    }

    @Override
    @Optional.Method(modid="computercraft")
    protected Object[] CC_callMethod(@Nonnull String methodName, @Nonnull Object[] arguments) {
        switch (methodName) {
            case "getAtmosphere": {
                return this.getAtmosphere();
            }
            case "getBiome": {
                return this.getBiome();
            }
            case "getHumidity": {
                return this.getHumidity();
            }
            case "getTemperature": {
                return this.getTemperature();
            }
            case "getWeather": {
                return this.getWeather();
            }
            case "getWorldTime": {
                return this.getWorldTime();
            }
        }
        return super.CC_callMethod(methodName, arguments);
    }
}

