/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.detection;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityAbstractEnergyConsumer;
import cr0s.warpdrive.block.detection.BlockRadar;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.EnergyWrapper;
import cr0s.warpdrive.data.EnumRadarMode;
import cr0s.warpdrive.data.GlobalRegionManager;
import cr0s.warpdrive.data.RadarEcho;
import cr0s.warpdrive.data.Vector3;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Optional;

public class TileEntityRadar
extends TileEntityAbstractEnergyConsumer {
    private ArrayList<RadarEcho> results;
    private int radius = 0;
    private boolean isScanning = false;
    private int scanning_radius = 0;
    private int scanning_countdown_ticks = 0;

    public TileEntityRadar() {
        this.peripheralName = "warpdriveRadar";
        this.addMethods(new String[]{"getGlobalPosition", "radius", "start", "getScanDuration", "getResults", "getResultsCount", "getResult"});
        this.CC_scripts = Arrays.asList("scan", "ping");
    }

    @Override
    protected void onConstructed() {
        super.onConstructed();
        this.energy_setParameters(WarpDriveConfig.RADAR_MAX_ENERGY_STORED, 65536, 0, "EV", 2, "EV", 0);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!this.isScanning) {
            if (this.computer_isConnected()) {
                this.updateBlockState(blockState, BlockRadar.MODE, EnumRadarMode.ACTIVE);
            } else {
                this.updateBlockState(blockState, BlockRadar.MODE, EnumRadarMode.INACTIVE);
            }
        } else {
            this.updateBlockState(blockState, BlockRadar.MODE, EnumRadarMode.SCANNING);
            try {
                --this.scanning_countdown_ticks;
                if (this.scanning_countdown_ticks <= 0) {
                    this.results = GlobalRegionManager.getRadarEchos(this, this.scanning_radius);
                    this.isScanning = false;
                    if (WarpDriveConfig.LOGGING_RADAR) {
                        WarpDrive.logger.info(String.format("%s Scan found %d results in %d radius...", this, this.results.size(), this.scanning_radius));
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(WarpDrive.printStreamError);
            }
        }
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.radius = tagCompound.func_74762_e("radius");
        this.isScanning = tagCompound.func_74767_n("isScanning");
        this.scanning_radius = tagCompound.func_74762_e("scanning_radius");
        this.scanning_countdown_ticks = tagCompound.func_74762_e("scanning_countdown");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("radius", this.radius);
        tagCompound.func_74757_a("isScanning", this.isScanning);
        tagCompound.func_74768_a("scanning_radius", this.scanning_radius);
        tagCompound.func_74768_a("scanning_countdown", this.scanning_countdown_ticks);
        return tagCompound;
    }

    private long calculateEnergyRequired(int parRadius) {
        return Math.round(Math.max((double)WarpDriveConfig.RADAR_SCAN_MIN_ENERGY_COST, WarpDriveConfig.RADAR_SCAN_ENERGY_COST_FACTORS[0] + WarpDriveConfig.RADAR_SCAN_ENERGY_COST_FACTORS[1] * (double)parRadius + WarpDriveConfig.RADAR_SCAN_ENERGY_COST_FACTORS[2] * (double)parRadius * (double)parRadius + WarpDriveConfig.RADAR_SCAN_ENERGY_COST_FACTORS[3] * (double)parRadius * (double)parRadius * (double)parRadius));
    }

    private int calculateScanDuration(int parRadius) {
        return (int)Math.round(20.0 * Math.max((double)WarpDriveConfig.RADAR_SCAN_MIN_DELAY_SECONDS, WarpDriveConfig.RADAR_SCAN_DELAY_FACTORS_SECONDS[0] + WarpDriveConfig.RADAR_SCAN_DELAY_FACTORS_SECONDS[1] * (double)parRadius + WarpDriveConfig.RADAR_SCAN_DELAY_FACTORS_SECONDS[2] * (double)parRadius * (double)parRadius + WarpDriveConfig.RADAR_SCAN_DELAY_FACTORS_SECONDS[3] * (double)parRadius * (double)parRadius * (double)parRadius));
    }

    public Object[] getGlobalPosition() {
        CelestialObject celestialObject = CelestialObjectManager.get(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p());
        if (celestialObject == null) {
            return new Object[]{false, GlobalRegionManager.GALAXY_UNDEFINED, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), Commons.format(this.field_145850_b)};
        }
        String galaxyName = GlobalRegionManager.getGalaxyName(celestialObject, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        Vector3 vec3Position = GlobalRegionManager.getUniversalCoordinates(celestialObject, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        return new Object[]{true, galaxyName, vec3Position.x, vec3Position.y, vec3Position.z, celestialObject.getDisplayName()};
    }

    private Object[] radius(Object[] arguments) {
        if (arguments.length == 1 && !this.isScanning) {
            int newRadius;
            try {
                newRadius = Commons.toInt(arguments[0]);
            }
            catch (Exception exception) {
                return new Integer[]{this.radius};
            }
            this.radius = Commons.clamp(0, 10000, newRadius);
        }
        return new Integer[]{this.radius};
    }

    @Override
    public Object[] getEnergyRequired() {
        String units = this.energy_getDisplayUnits();
        return new Object[]{true, EnergyWrapper.convert(this.calculateEnergyRequired(this.radius), units)};
    }

    private Object[] getScanDuration() {
        return new Object[]{0.05 * (double)this.calculateScanDuration(this.radius)};
    }

    private Object[] start() {
        if (this.isScanning) {
            return new Object[]{false, String.format("Already scanning, %.3f seconds to go", Float.valueOf((float)this.scanning_countdown_ticks / 20.0f))};
        }
        this.results = null;
        if (this.radius <= 0 || this.radius > 10000) {
            this.radius = 0;
            return new Object[]{false, "Invalid radius"};
        }
        long energyRequired = this.calculateEnergyRequired(this.radius);
        if (!this.energy_consume(energyRequired, false)) {
            return new Object[]{false, "Insufficient energy"};
        }
        this.scanning_radius = this.radius;
        this.scanning_countdown_ticks = this.calculateScanDuration(this.radius);
        this.isScanning = true;
        if (WarpDriveConfig.LOGGING_RADAR) {
            WarpDrive.logger.info(String.format("%s Starting scan over radius %d for %s %s, results expected in %s ticks", this, this.scanning_radius, EnergyWrapper.format(energyRequired, null), WarpDriveConfig.ENERGY_DISPLAY_UNITS, this.scanning_countdown_ticks));
        }
        return new Object[]{true, String.format("Scanning started, %.3f seconds to go", Float.valueOf((float)this.scanning_countdown_ticks / 20.0f))};
    }

    private Object[] getResults() {
        if (this.results == null) {
            return null;
        }
        Object[] objectResults = new Object[this.results.size()];
        int index = 0;
        for (RadarEcho radarEcho : this.results) {
            objectResults[index++] = new Object[]{radarEcho.type, radarEcho.name == null ? "" : radarEcho.name, radarEcho.x, radarEcho.y, radarEcho.z, radarEcho.mass};
        }
        return objectResults;
    }

    private Object[] getResultsCount() {
        if (this.results != null) {
            return new Integer[]{this.results.size()};
        }
        return new Integer[]{-1};
    }

    private Object[] getResult(Object[] arguments) {
        if (arguments.length == 1 && this.results != null) {
            RadarEcho radarEcho;
            int index;
            try {
                index = Commons.toInt(arguments[0]);
            }
            catch (Exception exception) {
                return new Object[]{false, "!ERROR!", null, 0, 0, 0};
            }
            if (index >= 0 && index < this.results.size() && (radarEcho = this.results.get(index)) != null) {
                return new Object[]{true, radarEcho.type, radarEcho.name == null ? "" : radarEcho.name, radarEcho.x, radarEcho.y, radarEcho.z, radarEcho.mass};
            }
        }
        return new Object[]{false, "!ERROR!", null, 0, 0, 0};
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getGlobalPosition(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getGlobalPosition();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] radius(Context context, Arguments arguments) {
        return this.radius(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getScanDuration(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getScanDuration();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] start(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.start();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getResults(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getResults();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getResultsCount(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getResultsCount();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getResult(Context context, Arguments arguments) {
        return this.getResult(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Override
    @Optional.Method(modid="computercraft")
    protected Object[] CC_callMethod(@Nonnull String methodName, @Nonnull Object[] arguments) {
        switch (methodName) {
            case "getGlobalPosition": {
                return this.getGlobalPosition();
            }
            case "radius": {
                return this.radius(arguments);
            }
            case "getScanDuration": {
                return this.getScanDuration();
            }
            case "start": {
                return this.start();
            }
            case "getResults": {
                return this.getResults();
            }
            case "getResultsCount": {
                return this.getResultsCount();
            }
            case "getResult": {
                return this.getResult(arguments);
            }
        }
        return super.CC_callMethod(methodName, arguments);
    }

    @Override
    public boolean energy_canInput(EnumFacing from) {
        return true;
    }
}

