/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.detection;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IGlobalRegionProvider;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.TileEntityAbstractBase;
import cr0s.warpdrive.block.TileEntityAbstractEnergyCoreOrController;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.EnergyWrapper;
import cr0s.warpdrive.data.EnumComponentType;
import cr0s.warpdrive.data.EnumGlobalRegionType;
import cr0s.warpdrive.data.GlobalRegion;
import cr0s.warpdrive.data.GlobalRegionManager;
import cr0s.warpdrive.item.ItemComponent;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.Optional;

public class TileEntityVirtualAssistant
extends TileEntityAbstractEnergyCoreOrController
implements IGlobalRegionProvider {
    private static final TileEntityAbstractBase.UpgradeSlot upgradeSlotSecurity = new TileEntityAbstractBase.UpgradeSlot("virtual_assistant.security", ItemComponent.getItemStackNoCache(EnumComponentType.DIAMOND_CRYSTAL, 1), 1);
    private String lastCommand = "";
    private AxisAlignedBB aabbArea = null;
    private int tickUpdate;

    public TileEntityVirtualAssistant() {
        this.peripheralName = "warpdriveVirtualAssistant";
        this.addMethods(new String[]{"getLastCommand", "pullLastCommand"});
        this.registerUpgradeSlot(upgradeSlotSecurity);
    }

    @Override
    public boolean energy_canInput(EnumFacing from) {
        return true;
    }

    @Override
    protected void onConstructed() {
        super.onConstructed();
        this.energy_setParameters(WarpDriveConfig.VIRTUAL_ASSISTANT_MAX_ENERGY_STORED_BY_TIER[this.enumTier.getIndex()], 512, 0, "LV", 2, "LV", 0);
    }

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
        float range = WarpDriveConfig.VIRTUAL_ASSISTANT_RANGE_BLOCKS_BY_TIER[this.enumTier.getIndex()];
        this.aabbArea = new AxisAlignedBB((double)((float)this.field_174879_c.func_177958_n() - range), (double)((float)this.field_174879_c.func_177956_o() - range), (double)((float)this.field_174879_c.func_177952_p() - range), (double)((float)this.field_174879_c.func_177958_n() + range) + 1.0, (double)((float)this.field_174879_c.func_177956_o() + range) + 1.0, (double)((float)this.field_174879_c.func_177952_p() + range) + 1.0);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        --this.tickUpdate;
        if (this.tickUpdate < 0) {
            this.tickUpdate = WarpDriveConfig.G_PARAMETERS_UPDATE_INTERVAL_TICKS;
            IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.updateBlockState(blockState, BlockProperties.ACTIVE, this.isEnabled);
        }
    }

    @Override
    protected void doUpdateParameters(boolean isDirty) {
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.lastCommand = tagCompound.func_74779_i("lastCommand");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        tagCompound.func_74778_a("lastCommand", this.lastCommand);
        return tagCompound;
    }

    @Override
    public Object[] getEnergyRequired() {
        String units = this.energy_getDisplayUnits();
        return new Object[]{true, EnergyWrapper.convert(WarpDriveConfig.VIRTUAL_ASSISTANT_ENERGY_PER_TICK_BY_TIER[this.enumTier.getIndex()], units)};
    }

    public boolean onChatReceived(@Nonnull EntityPlayer entityPlayer, @Nonnull String message) {
        String command;
        if (!this.isEnabled) {
            return false;
        }
        if (!this.aabbArea.func_72318_a(entityPlayer.func_174791_d())) {
            return false;
        }
        if (this.name.length() < 3 || this.name.contains("/") || this.name.contains("!")) {
            return false;
        }
        if (!message.toLowerCase().startsWith(this.name.toLowerCase())) {
            return false;
        }
        if (this.getUpgradeCount(upgradeSlotSecurity) > 0) {
            ArrayList<GlobalRegion> globalRegions = GlobalRegionManager.getContainers(EnumGlobalRegionType.SHIP, this.field_145850_b, this.field_174879_c);
            for (GlobalRegion globalRegion : globalRegions) {
                TileEntity tileEntity = this.field_145850_b.func_175625_s(globalRegion.getBlockPos());
                if (!(tileEntity instanceof TileEntityShipCore)) {
                    if (Commons.throttleMe("onChatReceived-InvalidInstance")) {
                        WarpDrive.logger.error(String.format("Unable to assist player due to invalid tile entity for global region, expecting TileEntityShipCore, got %s", tileEntity));
                    }
                    return false;
                }
                TileEntityShipCore tileEntityShipCore = (TileEntityShipCore)tileEntity;
                if (!tileEntityShipCore.isAssemblyValid()) {
                    if (Commons.throttleMe("onChatReceived-InvalidAssembly")) {
                        WarpDrive.logger.error(String.format("Unable to assist player due to invalid ship assembly for %s", tileEntity));
                    }
                    return false;
                }
                if (tileEntityShipCore.isCrewMember(entityPlayer)) continue;
                return false;
            }
        }
        this.lastCommand = command = message.substring(this.name.length()).trim();
        this.sendEvent("virtualAssistantCommand", command);
        return true;
    }

    private WarpDriveText getCommandStatus() {
        if (this.lastCommand == null || this.lastCommand.isEmpty()) {
            return new WarpDriveText(Commons.getStyleWarning(), "warpdrive.virtual_assistant.status_line.none", new Object[0]);
        }
        return new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.virtual_assistant.status_line.last_command", this.lastCommand);
    }

    @Override
    public WarpDriveText getStatus() {
        WarpDriveText textCommandStatus = this.getCommandStatus();
        if (textCommandStatus.func_150260_c().isEmpty()) {
            return super.getStatus();
        }
        return super.getStatus().append((ITextComponent)textCommandStatus);
    }

    @Override
    public EnumGlobalRegionType getGlobalRegionType() {
        return EnumGlobalRegionType.VIRTUAL_ASSISTANT;
    }

    @Override
    public AxisAlignedBB getGlobalRegionArea() {
        return this.aabbArea;
    }

    @Override
    public int getMass() {
        return 0;
    }

    @Override
    public double getIsolationRate() {
        return 0.0;
    }

    @Override
    public boolean onBlockUpdatingInArea(@Nullable Entity entity, BlockPos blockPos, IBlockState blockState) {
        return true;
    }

    public Object[] getLastCommand() {
        if (this.lastCommand == null || this.lastCommand.isEmpty()) {
            return new Object[]{false, "No command received."};
        }
        return new Object[]{true, this.lastCommand};
    }

    public Object[] pullLastCommand() {
        if (this.lastCommand == null || this.lastCommand.isEmpty()) {
            return new Object[]{false, "No command received."};
        }
        String lastCommandSaved = this.lastCommand;
        this.lastCommand = "";
        return new Object[]{true, lastCommandSaved};
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getLastCommand(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getLastCommand();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] pullLastCommand(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.pullLastCommand();
    }

    @Override
    @Optional.Method(modid="computercraft")
    protected Object[] CC_callMethod(@Nonnull String methodName, @Nonnull Object[] arguments) {
        switch (methodName) {
            case "getLastCommand": {
                return this.getLastCommand();
            }
            case "pullLastCommand": {
                return this.pullLastCommand();
            }
        }
        return super.CC_callMethod(methodName, arguments);
    }
}

