/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.energy;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IGlobalRegionProvider;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.energy.BlockEnanReactorCore;
import cr0s.warpdrive.block.energy.TileEntityEnanReactorController;
import cr0s.warpdrive.block.energy.TileEntityEnanReactorLaser;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnergyWrapper;
import cr0s.warpdrive.data.EnumGlobalRegionType;
import cr0s.warpdrive.data.EnumReactorOutputMode;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.data.ReactorFace;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.network.PacketHandler;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityEnanReactorCore
extends TileEntityEnanReactorController
implements IGlobalRegionProvider {
    private static final double INSTABILITY_MIN = 0.004;
    private static final double INSTABILITY_MAX = 0.06;
    private static final double PR_MAX_LASER_ENERGY = 200000.0;
    private static final double PR_MAX_LASER_EFFECT = 3.6363636363636362;
    private static final float MATTER_SURFACE_MIN = 0.25f;
    private static final float MATTER_SURFACE_FACTOR = 1.15f;
    private EnumReactorOutputMode enumReactorOutputMode = EnumReactorOutputMode.OFF;
    private int outputThreshold = 0;
    private double instabilityTarget = 50.0;
    private int stabilizerEnergy = 10000;
    private int containedEnergy = 0;
    private final double[] instabilityValues = new double[ReactorFace.maxInstabilities];
    private boolean hold = true;
    private AxisAlignedBB aabbRender = null;
    private Vector3 vCenter = null;
    private AxisAlignedBB cache_aabbArea;
    private boolean isFirstException = true;
    private int energyStored_max;
    private int generation_offset;
    private int generation_range;
    private int updateTicks = 0;
    private float lasersReceived = 0.0f;
    private int lastGenerationRate = 0;
    private int releasedThisTick = 0;
    private long releasedThisCycle = 0L;
    private long energyReleasedLastCycle = 0L;
    public float client_yCore = 0.0f;
    public float client_yCoreSpeed_mPerTick = 0.0f;
    public float client_rotationCore_deg = 0.0f;
    public float client_rotationSpeedCore_degPerTick = 2.0f;
    public float client_rotationMatter_deg = 0.0f;
    public float client_rotationSpeedMatter_degPerTick = 2.0f;
    public float client_rotationSurface_deg = 0.0f;
    public float client_rotationSpeedSurface_degPerTick = 2.0f;
    public float client_radiusMatter_m = 0.0f;
    public float client_radiusSpeedMatter_mPerTick = 0.0f;
    public float client_radiusShield_m = 0.0f;
    public float client_radiusSpeedShield_mPerTick = 0.0f;
    private final WeakReference<TileEntityEnanReactorLaser>[] weakTileEntityLasers = (WeakReference[])Array.newInstance(WeakReference.class, ReactorFace.maxInstabilities);

    public TileEntityEnanReactorCore() {
        this.peripheralName = "warpdriveEnanReactorCore";
        this.isEnabled = false;
    }

    @Override
    public void onConstructed() {
        super.onConstructed();
        this.energyStored_max = WarpDriveConfig.ENAN_REACTOR_MAX_ENERGY_STORED_BY_TIER[this.enumTier.getIndex()];
        this.generation_offset = WarpDriveConfig.ENAN_REACTOR_GENERATION_MIN_RF_BY_TIER[this.enumTier.getIndex()];
        this.generation_range = WarpDriveConfig.ENAN_REACTOR_GENERATION_MAX_RF_BY_TIER[this.enumTier.getIndex()] - this.generation_offset;
        this.energy_setParameters(EnergyWrapper.convertRFtoInternal_floor(this.energyStored_max), 262144, 262144, "HV", 0, "LuV", 2);
        this.vCenter = new Vector3(this).translate(0.5);
        switch (this.enumTier) {
            default: {
                break;
            }
            case ADVANCED: {
                this.vCenter.y += 3.0;
                break;
            }
            case SUPERIOR: {
                this.vCenter.y += 4.0;
            }
        }
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.aabbRender == null) {
            double radiusMatterMax = this.isFirstTick() ? 3.0 : this.vCenter.y - (double)this.field_174879_c.func_177956_o();
            this.aabbRender = new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - radiusMatterMax, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() - radiusMatterMax, (double)this.field_174879_c.func_177958_n() + radiusMatterMax + 1.0, (double)this.field_174879_c.func_177956_o() + 2.0 * radiusMatterMax, (double)this.field_174879_c.func_177952_p() + radiusMatterMax + 1.0);
        }
        return this.aabbRender;
    }

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
        this.client_yCore = this.containedEnergy == 0 ? 0.5f : (float)this.vCenter.y - (float)this.field_174879_c.func_177956_o();
        this.client_yCoreSpeed_mPerTick = 0.0f;
        this.client_rotationCore_deg = this.field_145850_b.field_73012_v.nextFloat() * 360.0f;
        this.client_rotationSpeedCore_degPerTick = 0.05f * (float)this.instabilityValues[0];
        this.client_rotationMatter_deg = this.field_145850_b.field_73012_v.nextFloat() * 360.0f;
        this.client_rotationSpeedMatter_degPerTick = this.client_rotationSpeedCore_degPerTick * 0.98f;
        this.client_rotationSurface_deg = this.field_145850_b.field_73012_v.nextFloat() * 360.0f;
        this.client_rotationSpeedSurface_degPerTick = this.client_rotationSpeedMatter_degPerTick;
        this.client_radiusMatter_m = 0.0f;
        this.client_radiusSpeedMatter_mPerTick = 0.0f;
        this.client_radiusShield_m = this.containedEnergy <= 10000 ? 0.0f : (float)(this.vCenter.y - (double)this.field_174879_c.func_177956_o() - 1.0);
        this.client_radiusSpeedShield_mPerTick = 0.0f;
        this.aabbRender = null;
    }

    private void client_update() {
        ReactorFace[] reactorFaces;
        float instabilityAverage = 0.0f;
        for (ReactorFace reactorFace : reactorFaces = ReactorFace.getLasers(this.enumTier)) {
            instabilityAverage += (float)this.instabilityValues[reactorFace.indexStability];
        }
        float radiusArea = (float)(this.vCenter.y - (double)this.field_174879_c.func_177956_o() - 1.0);
        float yCoreTarget = this.containedEnergy == 0 ? 1.0f : radiusArea + 1.0f;
        float rotationSpeedTarget_degPerTick = 0.05f * (instabilityAverage /= (float)reactorFaces.length);
        float radiusMatterMax = radiusArea - 0.1f;
        float radiusMatterTarget = this.containedEnergy <= 10000 ? 0.0f : 0.25f + (radiusMatterMax - 0.25f) / 1.15f * (float)Math.pow((float)this.containedEnergy / (float)this.energyStored_max, 0.3333);
        float radiusShieldTarget = this.containedEnergy <= 1000 ? 0.0f : Math.min(radiusArea - 0.05f, (float)Math.ceil(radiusMatterTarget * 3.0f + 0.8f) / 3.0f);
        this.client_radiusShield_m += this.client_radiusSpeedShield_mPerTick;
        float radiusShieldDelta = radiusShieldTarget - this.client_radiusShield_m;
        this.client_radiusSpeedShield_mPerTick = Math.signum(radiusShieldDelta) * Math.min(0.015f, Math.abs(radiusShieldDelta));
        this.client_rotationCore_deg = (this.client_rotationCore_deg + this.client_rotationSpeedCore_degPerTick) % 360.0f;
        this.client_rotationSpeedCore_degPerTick = 0.975f * this.client_rotationSpeedCore_degPerTick + 0.025f * rotationSpeedTarget_degPerTick;
        this.client_rotationMatter_deg = (this.client_rotationMatter_deg + this.client_rotationSpeedMatter_degPerTick) % 360.0f;
        this.client_rotationSpeedMatter_degPerTick = 0.985f * this.client_rotationSpeedMatter_degPerTick + 0.015f * rotationSpeedTarget_degPerTick;
        this.client_rotationSurface_deg = (this.client_rotationSurface_deg + this.client_rotationSpeedSurface_degPerTick) % 360.0f;
        this.client_rotationSpeedSurface_degPerTick = 0.99f * this.client_rotationSpeedSurface_degPerTick + 0.01f * rotationSpeedTarget_degPerTick;
        this.client_radiusMatter_m += this.client_radiusSpeedMatter_mPerTick;
        float radiusMatterDelta = radiusMatterTarget - this.client_radiusMatter_m;
        this.client_radiusSpeedMatter_mPerTick = Math.signum(radiusMatterDelta) * Math.min(0.05f, Math.abs(radiusMatterDelta));
        this.client_yCore += this.client_yCoreSpeed_mPerTick;
        float yDelta = yCoreTarget - this.client_yCore;
        this.client_yCoreSpeed_mPerTick = Math.signum(yDelta) * Math.min(0.05f, Math.abs(yDelta));
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            this.client_update();
            return;
        }
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(String.format("updateTicks %d releasedThisTick %6d lasersReceived %.5f releasedThisCycle %6d containedEnergy %8d", this.updateTicks, this.releasedThisTick, Float.valueOf(this.lasersReceived), this.releasedThisCycle, this.containedEnergy));
        }
        this.releasedThisTick = 0;
        this.lasersReceived = Math.max(0.0f, this.lasersReceived - 0.05f);
        --this.updateTicks;
        if (this.updateTicks > 0) {
            return;
        }
        this.updateTicks = 5;
        this.energyReleasedLastCycle = this.releasedThisCycle;
        this.releasedThisCycle = 0L;
        this.refreshBlockState();
        if (!this.hold) {
            if (this.shouldExplode()) {
                this.explode();
            }
            this.increaseInstability();
            this.generateEnergy();
            this.runControlLoop();
        }
        this.sendEvent("reactorPulse", this.lastGenerationRate);
    }

    private void increaseInstability() {
        for (ReactorFace reactorFace : ReactorFace.getLasers(this.enumTier)) {
            int indexStability = reactorFace.indexStability;
            if (this.containedEnergy > 2000) {
                double amountToIncrease = 5.0 * Math.max(0.004, 0.06 * Math.pow(this.field_145850_b.field_73012_v.nextDouble() * (double)this.containedEnergy / (double)this.energyStored_max, 0.1));
                if (WarpDriveConfig.LOGGING_ENERGY) {
                    WarpDrive.logger.info(String.format("increaseInstability %.5f", amountToIncrease));
                }
                int n = indexStability;
                this.instabilityValues[n] = this.instabilityValues[n] + amountToIncrease;
                continue;
            }
            double amountToDecrease = 5.0 * Math.max(0.004, this.instabilityValues[indexStability] * 0.02);
            this.instabilityValues[indexStability] = Math.max(0.0, this.instabilityValues[indexStability] - amountToDecrease);
        }
    }

    void decreaseInstability(@Nonnull ReactorFace reactorFace, int energy) {
        if (reactorFace.indexStability < 0) {
            return;
        }
        int amount = EnergyWrapper.convertInternalToRF_floor(energy);
        if (amount <= 1) {
            return;
        }
        this.lasersReceived = Math.min(10.0f, this.lasersReceived + 1.0f / (float)WarpDriveConfig.ENAN_REACTOR_MAX_LASERS_PER_SECOND[this.enumTier.getIndex()]);
        double nospamFactor = 1.0;
        if (this.lasersReceived > 1.0f) {
            nospamFactor = 0.5;
            this.field_145850_b.func_72885_a(null, (double)(this.field_174879_c.func_177958_n() + reactorFace.x - reactorFace.facingLaserProperty.func_82601_c()), (double)(this.field_174879_c.func_177956_o() + reactorFace.y - reactorFace.facingLaserProperty.func_96559_d()), (double)(this.field_174879_c.func_177952_p() + reactorFace.z - reactorFace.facingLaserProperty.func_82599_e()), 1.0f, false, false);
        }
        double normalisedAmount = Math.min(1.0, Math.max(0.0, (double)amount / 200000.0));
        double baseLaserEffect = 0.5 + 0.5 * Math.cos(Math.PI * Math.log10(0.1 + 0.9 * normalisedAmount));
        double randomVariation = 0.8 + 0.4 * this.field_145850_b.field_73012_v.nextDouble();
        double amountToRemove = 3.6363636363636362 * baseLaserEffect * randomVariation * nospamFactor;
        int indexStability = reactorFace.indexStability;
        if (WarpDriveConfig.LOGGING_ENERGY && indexStability == 3) {
            WarpDrive.logger.info(String.format("Instability on %s decreased by %.1f/%.1f after consuming %d/%.1f laserReceived is %.1f hence nospamFactor is %.3f", reactorFace, amountToRemove, 3.6363636363636362, amount, 200000.0, Float.valueOf(this.lasersReceived), nospamFactor));
        }
        this.instabilityValues[indexStability] = Math.max(0.0, this.instabilityValues[indexStability] - amountToRemove);
    }

    private void generateEnergy() {
        double stabilityOffset = 0.5;
        for (ReactorFace reactorFace : ReactorFace.getLasers(this.enumTier)) {
            stabilityOffset *= Math.max(0.01, this.instabilityValues[reactorFace.indexStability] / 100.0);
        }
        if (this.isEnabled) {
            int amountToGenerate = (int)Math.ceil(5.0 * (0.5 + stabilityOffset) * ((double)this.generation_offset + (double)this.generation_range * Math.pow((double)this.containedEnergy / (double)this.energyStored_max, 0.6)));
            this.containedEnergy = Math.min(this.containedEnergy + amountToGenerate, this.energyStored_max);
            this.lastGenerationRate = amountToGenerate / 5;
            if (WarpDriveConfig.LOGGING_ENERGY) {
                WarpDrive.logger.info(String.format("Generated %d", amountToGenerate));
            }
        } else {
            int amountToDecay = (int)(5.0 * (1.0 - stabilityOffset) * ((double)this.generation_offset + (double)this.containedEnergy * 0.01));
            this.containedEnergy = Math.max(0, this.containedEnergy - amountToDecay);
            this.lastGenerationRate = 0;
            if (WarpDriveConfig.LOGGING_ENERGY) {
                WarpDrive.logger.info(String.format("Decayed %d", amountToDecay));
            }
        }
    }

    private void runControlLoop() {
        for (ReactorFace reactorFace : ReactorFace.getLasers(this.enumTier)) {
            TileEntityEnanReactorLaser tileEntityEnanReactorLaser;
            if (!(this.instabilityValues[reactorFace.indexStability] > this.instabilityTarget) || (tileEntityEnanReactorLaser = this.getLaser(reactorFace)) == null || tileEntityEnanReactorLaser.stabilize(this.stabilizerEnergy) != -this.stabilizerEnergy) continue;
            this.hold = true;
            if (!Commons.throttleMe(String.format("Reactor simulation hold %s", Commons.format(this.field_145850_b, this.field_174879_c)))) continue;
            WarpDrive.logger.warn(String.format("Reactor %s simulation is now on hold for %d ticks due to partial loading of laser %s", Commons.format(this.field_145850_b, this.field_174879_c), this.updateTicks, Commons.format(this.field_145850_b, tileEntityEnanReactorLaser.func_174877_v())));
        }
        if (this.hold) {
            this.updateTicks = Math.max(this.updateTicks, 40);
            this.markDirtyAssembly();
            for (ReactorFace reactorFace : ReactorFace.getLasers(this.enumTier)) {
                if (!(this.instabilityValues[reactorFace.indexStability] > this.instabilityTarget)) continue;
                this.instabilityValues[reactorFace.indexStability] = this.instabilityTarget;
            }
        }
    }

    @Nullable
    private TileEntityEnanReactorLaser getLaser(@Nonnull ReactorFace reactorFace) {
        TileEntityEnanReactorLaser tileEntityEnanReactorLaser;
        WeakReference<TileEntityEnanReactorLaser> weakTileEntityLaser = this.weakTileEntityLasers[reactorFace.indexStability];
        if (weakTileEntityLaser != null && (tileEntityEnanReactorLaser = (TileEntityEnanReactorLaser)weakTileEntityLaser.get()) != null && !tileEntityEnanReactorLaser.func_145837_r()) {
            return tileEntityEnanReactorLaser;
        }
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(reactorFace.x, reactorFace.y, reactorFace.z));
        if (tileEntity instanceof TileEntityEnanReactorLaser) {
            tileEntityEnanReactorLaser = (TileEntityEnanReactorLaser)tileEntity;
            this.weakTileEntityLasers[reactorFace.indexStability] = new WeakReference<TileEntityEnanReactorLaser>(tileEntityEnanReactorLaser);
            return tileEntityEnanReactorLaser;
        }
        return null;
    }

    Vector3 getCenter() {
        this.finishConstruction();
        return this.vCenter;
    }

    private boolean shouldExplode() {
        boolean exploding = false;
        for (ReactorFace reactorFace : ReactorFace.getLasers(this.enumTier)) {
            exploding = exploding || this.instabilityValues[reactorFace.indexStability] >= 100.0;
        }
        if (exploding &= this.field_145850_b.field_73012_v.nextInt(4) == 2) {
            StringBuilder statusLasers = new StringBuilder();
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (ReactorFace reactorFace : ReactorFace.getLasers(this.enumTier)) {
                long energyStored = -1L;
                int countLaserMediums = 0;
                mutableBlockPos.func_181079_c(this.field_174879_c.func_177958_n() + reactorFace.x, this.field_174879_c.func_177956_o() + reactorFace.y, this.field_174879_c.func_177952_p() + reactorFace.z);
                TileEntity tileEntity = this.field_145850_b.func_175625_s((BlockPos)mutableBlockPos);
                if (tileEntity instanceof TileEntityEnanReactorLaser) {
                    try {
                        energyStored = ((TileEntityEnanReactorLaser)tileEntity).laserMedium_getEnergyStored(true);
                        countLaserMediums = ((TileEntityEnanReactorLaser)tileEntity).laserMedium_getCount();
                    }
                    catch (Exception exception) {
                        if (this.isFirstException) {
                            exception.printStackTrace(WarpDrive.printStreamError);
                            this.isFirstException = false;
                        }
                        WarpDrive.logger.error(String.format("%s tileEntity is %s", this, tileEntity));
                    }
                    statusLasers.append(String.format("\n- face %s has reached instability %.2f while laser %s has %d energy available with %d laser medium(s)", reactorFace.name, this.instabilityValues[reactorFace.indexStability], Commons.format(this.field_145850_b, (BlockPos)mutableBlockPos), energyStored, countLaserMediums));
                    continue;
                }
                statusLasers.append(String.format("\n- face %s has reached instability %.2f while laser is missing in action", reactorFace.name, this.instabilityValues[reactorFace.indexStability]));
            }
            WarpDrive.logger.info(String.format("%s Explosion triggered\nEnergy stored is %d, Laser received is %.2f, Reactor is %s\nOutput mode %s %d, Stability target %.1f, Laser amount %d%s", new Object[]{this, this.containedEnergy, Float.valueOf(this.lasersReceived), this.isEnabled ? "ENABLED" : "DISABLED", this.enumReactorOutputMode, this.outputThreshold, 100.0 - this.instabilityTarget, this.stabilizerEnergy, statusLasers.toString()}));
            this.isEnabled = false;
        }
        return exploding;
    }

    private void explode() {
        double normalizedEnergy = (double)this.containedEnergy / (double)this.energyStored_max;
        double factorEnergy = Math.pow(normalizedEnergy, 0.125);
        int radius = (int)Math.round((double)WarpDriveConfig.ENAN_REACTOR_EXPLOSION_MAX_RADIUS_BY_TIER[this.enumTier.getIndex()] * factorEnergy);
        double chanceOfRemoval = WarpDriveConfig.ENAN_REACTOR_EXPLOSION_MAX_REMOVAL_CHANCE_BY_TIER[this.enumTier.getIndex()] * factorEnergy;
        WarpDrive.logger.info(String.format("%s Explosion radius is %d, Chance of removal is %.3f", this, radius, chanceOfRemoval));
        if (radius > 1) {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(this.field_174879_c);
            Explosion explosion = new Explosion(this.field_145850_b, null, this.vCenter.x, this.vCenter.y, this.vCenter.z, (float)radius, true, true);
            float explosionResistanceThreshold = Blocks.field_150343_Z.getExplosionResistance(this.field_145850_b, (BlockPos)mutableBlockPos, null, explosion);
            for (int x = this.field_174879_c.func_177958_n() - radius; x <= this.field_174879_c.func_177958_n() + radius; ++x) {
                for (int y = this.field_174879_c.func_177956_o() - radius; y <= this.field_174879_c.func_177956_o() + radius; ++y) {
                    for (int z = this.field_174879_c.func_177952_p() - radius; z <= this.field_174879_c.func_177952_p() + radius; ++z) {
                        if (z == this.field_174879_c.func_177952_p() && y == this.field_174879_c.func_177956_o() && x == this.field_174879_c.func_177958_n() || !(this.field_145850_b.field_73012_v.nextDouble() < chanceOfRemoval)) continue;
                        mutableBlockPos.func_181079_c(x, y, z);
                        IBlockState blockState = this.field_145850_b.func_180495_p((BlockPos)mutableBlockPos);
                        float explosionResistanceActual = blockState.func_177230_c().getExplosionResistance(this.field_145850_b, (BlockPos)mutableBlockPos, null, explosion);
                        if (!(explosionResistanceActual >= explosionResistanceThreshold)) continue;
                        WarpDrive.logger.debug(String.format("%s De-materializing %s %s", this, blockState, Commons.format(this.field_145850_b, (BlockPos)mutableBlockPos)));
                        this.field_145850_b.func_175698_g((BlockPos)mutableBlockPos);
                    }
                }
            }
        }
        this.field_145850_b.func_175698_g(this.field_174879_c);
        int countExplosions = WarpDriveConfig.ENAN_REACTOR_EXPLOSION_COUNT_BY_TIER[this.enumTier.getIndex()];
        float strengthMin = WarpDriveConfig.ENAN_REACTOR_EXPLOSION_STRENGTH_MIN_BY_TIER[this.enumTier.getIndex()];
        int strengthRange = (int)Math.ceil(WarpDriveConfig.ENAN_REACTOR_EXPLOSION_STRENGTH_MAX_BY_TIER[this.enumTier.getIndex()] - strengthMin);
        for (int i = 0; i < countExplosions; ++i) {
            this.field_145850_b.func_72885_a(null, (double)(this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextInt(3)) - 1.5, (double)(this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextInt(3)) - 0.5, (double)(this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextInt(3)) - 1.5, strengthMin + (float)this.field_145850_b.field_73012_v.nextInt(strengthRange), true, true);
        }
    }

    private void refreshBlockState() {
        double maxInstability = 0.0;
        double[] dArray = this.instabilityValues;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double instability = dArray[i];
            if (!(instability > maxInstability)) continue;
            maxInstability = instability;
        }
        int instabilityNibble = (int)Math.max(0L, Math.min(3L, Math.round(maxInstability / 25.0)));
        int energyNibble = (int)Math.max(0L, Math.min(3L, Math.round(4.0 * (double)this.containedEnergy / (double)this.energyStored_max)));
        IBlockState blockStateNew = this.func_145838_q().func_176223_P().func_177226_a((IProperty)BlockEnanReactorCore.ENERGY, (Comparable)Integer.valueOf(energyNibble)).func_177226_a((IProperty)BlockEnanReactorCore.INSTABILITY, (Comparable)Integer.valueOf(instabilityNibble));
        this.updateBlockState(null, blockStateNew);
        this.field_145850_b.func_184138_a(this.field_174879_c, blockStateNew, blockStateNew, 3);
    }

    @Override
    public void onBlockBroken(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (ReactorFace reactorFace : ReactorFace.getLasers(this.enumTier)) {
            if (reactorFace.indexStability < 0) continue;
            mutableBlockPos.func_181079_c(blockPos.func_177958_n() + reactorFace.x, blockPos.func_177956_o() + reactorFace.y, blockPos.func_177952_p() + reactorFace.z);
            TileEntity tileEntity = world.func_175625_s((BlockPos)mutableBlockPos);
            if (!(tileEntity instanceof TileEntityEnanReactorLaser) || ((TileEntityEnanReactorLaser)tileEntity).getReactorFace() != reactorFace) continue;
            ((TileEntityEnanReactorLaser)tileEntity).setReactorFace(ReactorFace.UNKNOWN, null);
        }
        super.onBlockBroken(world, blockPos, blockState);
    }

    @Override
    protected boolean doScanAssembly(boolean isDirty, WarpDriveText textReason) {
        boolean isValid = super.doScanAssembly(isDirty, textReason);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (ReactorFace reactorFace : ReactorFace.get(this.enumTier)) {
            assert (reactorFace.enumTier == this.enumTier);
            if (reactorFace.indexStability >= 0) continue;
            mutableBlockPos.func_181079_c(this.field_174879_c.func_177958_n() + reactorFace.x, this.field_174879_c.func_177956_o() + reactorFace.y, this.field_174879_c.func_177952_p() + reactorFace.z);
            IBlockState blockState = this.field_145850_b.func_180495_p((BlockPos)mutableBlockPos);
            boolean isAir = blockState.func_177230_c().isAir(blockState, (IBlockAccess)this.field_145850_b, (BlockPos)mutableBlockPos);
            if (isAir) continue;
            textReason.append(Commons.getStyleWarning(), "warpdrive.enan_reactor.status_line.non_air_block", Commons.format(this.field_145850_b, (BlockPos)mutableBlockPos));
            isValid = false;
            PacketHandler.sendSpawnParticlePacket(this.field_145850_b, "jammed", (byte)5, new Vector3((double)mutableBlockPos.func_177958_n() + 0.5, (double)mutableBlockPos.func_177956_o() + 0.5, (double)mutableBlockPos.func_177952_p() + 0.5), new Vector3(0.0, 0.0, 0.0), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 32);
        }
        for (ReactorFace reactorFace : ReactorFace.getLasers(this.enumTier)) {
            mutableBlockPos.func_181079_c(this.field_174879_c.func_177958_n() + reactorFace.x, this.field_174879_c.func_177956_o() + reactorFace.y, this.field_174879_c.func_177952_p() + reactorFace.z);
            TileEntity tileEntity = this.field_145850_b.func_175625_s((BlockPos)mutableBlockPos);
            if (tileEntity instanceof TileEntityEnanReactorLaser) {
                ((TileEntityEnanReactorLaser)tileEntity).setReactorFace(reactorFace, this);
                continue;
            }
            textReason.append(Commons.getStyleWarning(), "warpdrive.enan_reactor.status_line.missing_stabilization_laser", Commons.format(this.field_145850_b, (BlockPos)mutableBlockPos));
            isValid = false;
            PacketHandler.sendSpawnParticlePacket(this.field_145850_b, "jammed", (byte)5, new Vector3((double)mutableBlockPos.func_177958_n() + 0.5, (double)mutableBlockPos.func_177956_o() + 0.5, (double)mutableBlockPos.func_177952_p() + 0.5), new Vector3(0.0, 0.0, 0.0), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 32);
        }
        return isValid;
    }

    @Override
    public EnumGlobalRegionType getGlobalRegionType() {
        return EnumGlobalRegionType.REACTOR;
    }

    @Override
    public AxisAlignedBB getGlobalRegionArea() {
        if (this.cache_aabbArea == null) {
            int minX = 0;
            int minY = 0;
            int minZ = 0;
            int maxX = 0;
            int maxY = 0;
            int maxZ = 0;
            for (ReactorFace reactorFace : ReactorFace.getLasers(EnumTier.get(this.getTierIndex()))) {
                minX = Math.min(minX, reactorFace.x);
                minY = Math.min(minY, reactorFace.y);
                minZ = Math.min(minZ, reactorFace.z);
                maxX = Math.max(maxX, reactorFace.x);
                maxY = Math.max(maxY, reactorFace.y);
                maxZ = Math.max(maxZ, reactorFace.z);
            }
            this.cache_aabbArea = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() + minX), (double)(this.field_174879_c.func_177956_o() + minY), (double)(this.field_174879_c.func_177952_p() + minZ), (double)(this.field_174879_c.func_177958_n() + maxX) + 1.0, (double)(this.field_174879_c.func_177956_o() + maxY) + 1.0, (double)(this.field_174879_c.func_177952_p() + maxZ) + 1.0);
        }
        return this.cache_aabbArea;
    }

    @Override
    public int getMass() {
        return ReactorFace.getLasers(EnumTier.get(this.getTierIndex())).length;
    }

    @Override
    public double getIsolationRate() {
        return 1.0;
    }

    @Override
    public boolean onBlockUpdatingInArea(@Nullable Entity entity, BlockPos blockPos, IBlockState blockState) {
        this.finishConstruction();
        for (ReactorFace reactorFace : ReactorFace.get(this.enumTier)) {
            if (blockPos.func_177958_n() != this.field_174879_c.func_177958_n() + reactorFace.x || blockPos.func_177956_o() != this.field_174879_c.func_177956_o() + reactorFace.y || blockPos.func_177952_p() != this.field_174879_c.func_177952_p() + reactorFace.z) continue;
            this.markDirtyAssembly();
            break;
        }
        return true;
    }

    @Override
    public Object[] getEnergyStatus() {
        String units = this.energy_getDisplayUnits();
        return new Object[]{EnergyWrapper.convert(this.containedEnergy, units), EnergyWrapper.convert(this.energyStored_max, units), this.energy_getDisplayUnits(), 0, EnergyWrapper.convert(this.energyReleasedLastCycle, units) / 5L};
    }

    @Override
    public Double[] getInstabilities() {
        this.hold = false;
        ReactorFace[] lasers = ReactorFace.getLasers(this.enumTier);
        Double[] result = new Double[lasers.length];
        for (ReactorFace reactorFace : lasers) {
            double value = this.instabilityValues[reactorFace.indexStability];
            result[reactorFace.indexStability] = value;
        }
        return result;
    }

    @Override
    public Double[] instabilityTarget(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            double instabilityTargetRequested;
            try {
                instabilityTargetRequested = Commons.toDouble(arguments[0]);
            }
            catch (Exception exception) {
                if (WarpDriveConfig.LOGGING_LUA) {
                    WarpDrive.logger.error(String.format("%s LUA error on instabilityTarget(): Double expected for 1st argument %s", this, arguments[0]));
                }
                return new Double[]{this.instabilityTarget};
            }
            this.instabilityTarget = Commons.clamp(0.0, 100.0, instabilityTargetRequested);
        }
        return new Double[]{this.instabilityTarget};
    }

    @Override
    public Object[] outputMode(Object[] arguments) {
        if (arguments.length == 2 && arguments[0] != null) {
            int outputThresholdRequested;
            EnumReactorOutputMode enumReactorOutputModeRequested;
            try {
                enumReactorOutputModeRequested = EnumReactorOutputMode.byName(arguments[0].toString());
                if (enumReactorOutputModeRequested == null) {
                    throw new NullPointerException();
                }
            }
            catch (Exception exception) {
                String message = String.format("%s LUA error on outputMode(): enum(%s) expected for 1st argument %s", this, Arrays.toString((Object[])EnumReactorOutputMode.values()), arguments[0]);
                if (WarpDriveConfig.LOGGING_LUA) {
                    WarpDrive.logger.error(message);
                }
                return new Object[]{this.enumReactorOutputMode.func_176610_l(), this.outputThreshold};
            }
            try {
                outputThresholdRequested = Commons.toInt(arguments[1]);
            }
            catch (Exception exception) {
                if (WarpDriveConfig.LOGGING_LUA) {
                    WarpDrive.logger.error(String.format("%s LUA error on outputMode(): integer expected for 2nd argument %s", this, arguments[0]));
                }
                return new Object[]{this.enumReactorOutputMode.func_176610_l(), this.outputThreshold};
            }
            this.enumReactorOutputMode = enumReactorOutputModeRequested;
            this.outputThreshold = outputThresholdRequested;
        }
        return new Object[]{this.enumReactorOutputMode.func_176610_l(), this.outputThreshold};
    }

    @Override
    public Object[] stabilizerEnergy(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            int stabilizerEnergyRequested;
            try {
                stabilizerEnergyRequested = Commons.toInt(arguments[0]);
            }
            catch (Exception exception) {
                if (WarpDriveConfig.LOGGING_LUA) {
                    WarpDrive.logger.error(String.format("%s LUA error on stabilizerEnergy(): Integer expected for 1st argument %s", this, arguments[0]));
                }
                return new Object[]{this.stabilizerEnergy};
            }
            this.stabilizerEnergy = Commons.clamp(0, Integer.MAX_VALUE, stabilizerEnergyRequested);
        }
        return new Object[]{this.stabilizerEnergy};
    }

    @Override
    public Object[] state() {
        String status = this.getStatusHeaderInPureText();
        return new Object[]{status, this.isEnabled, this.containedEnergy, this.enumReactorOutputMode.func_176610_l(), this.outputThreshold};
    }

    @Override
    public int energy_getPotentialOutput() {
        if (this.hold) {
            return 0;
        }
        int capacity = Math.max(0, 2 * this.lastGenerationRate - this.releasedThisTick);
        int result = 0;
        if (this.enumReactorOutputMode == EnumReactorOutputMode.UNLIMITED) {
            result = Math.min(Math.max(0, this.containedEnergy), capacity);
            if (WarpDriveConfig.LOGGING_ENERGY) {
                WarpDrive.logger.info(String.format("PotentialOutput Manual %d RF (%d internal) capacity %d", result, EnergyWrapper.convertRFtoInternal_floor(result), capacity));
            }
        } else if (this.enumReactorOutputMode == EnumReactorOutputMode.ABOVE) {
            result = Math.min(Math.max(0, this.lastGenerationRate - this.outputThreshold), capacity);
            if (WarpDriveConfig.LOGGING_ENERGY) {
                WarpDrive.logger.info(String.format("PotentialOutput Above %d RF (%d internal) capacity %d", result, EnergyWrapper.convertRFtoInternal_floor(result), capacity));
            }
        } else if (this.enumReactorOutputMode == EnumReactorOutputMode.AT_RATE) {
            int remainingRate = Math.max(0, this.outputThreshold - this.releasedThisTick);
            result = Math.min(Math.max(0, this.containedEnergy), Math.min(remainingRate, capacity));
            if (WarpDriveConfig.LOGGING_ENERGY) {
                WarpDrive.logger.info(String.format("PotentialOutput Rated %d RF (%d internal) remainingRate %d RF/t capacity %d", result, EnergyWrapper.convertRFtoInternal_floor(result), remainingRate, capacity));
            }
        }
        return (int)EnergyWrapper.convertRFtoInternal_floor(result);
    }

    @Override
    public boolean energy_canOutput(EnumFacing from) {
        if (this.enumTier == EnumTier.BASIC) {
            return from == null || from.equals((Object)EnumFacing.UP) || from.equals((Object)EnumFacing.DOWN);
        }
        return from == null || !from.equals((Object)EnumFacing.UP);
    }

    @Override
    protected void energy_outputDone(long energyOutput_internal) {
        long energyOutput_RF = EnergyWrapper.convertInternalToRF_ceil(energyOutput_internal);
        this.containedEnergy = (int)((long)this.containedEnergy - energyOutput_RF);
        if (this.containedEnergy < 0) {
            this.containedEnergy = 0;
        }
        this.releasedThisTick = (int)((long)this.releasedThisTick + energyOutput_RF);
        this.releasedThisCycle += energyOutput_RF;
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(String.format("OutputDone %d (%d RF)", energyOutput_internal, energyOutput_RF));
        }
    }

    @Override
    public long energy_getEnergyStored() {
        return Commons.clamp(0L, this.energy_getMaxStorage(), EnergyWrapper.convertRFtoInternal_floor(this.containedEnergy));
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        tagCompound.func_74778_a("outputMode", this.enumReactorOutputMode.func_176610_l());
        tagCompound.func_74768_a("outputThreshold", this.outputThreshold);
        tagCompound.func_74780_a("instabilityTarget", this.instabilityTarget);
        tagCompound.func_74768_a("stabilizerEnergy", this.stabilizerEnergy);
        tagCompound.func_74768_a("energy", this.containedEnergy);
        NBTTagCompound tagCompoundInstability = new NBTTagCompound();
        for (ReactorFace reactorFace : ReactorFace.getLasers(this.enumTier)) {
            tagCompoundInstability.func_74780_a(reactorFace.name, this.instabilityValues[reactorFace.indexStability]);
        }
        tagCompound.func_74782_a("instability", (NBTBase)tagCompoundInstability);
        return tagCompound;
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (!(this.field_145850_b != null && this.field_145850_b.field_72995_K || tagCompound.func_74764_b("outputMode"))) {
            return;
        }
        this.enumReactorOutputMode = EnumReactorOutputMode.byName(tagCompound.func_74779_i("outputMode"));
        if (this.enumReactorOutputMode == null) {
            this.enumReactorOutputMode = EnumReactorOutputMode.OFF;
        }
        this.outputThreshold = tagCompound.func_74762_e("outputThreshold");
        this.instabilityTarget = tagCompound.func_74769_h("instabilityTarget");
        this.stabilizerEnergy = tagCompound.func_74762_e("stabilizerEnergy");
        this.containedEnergy = tagCompound.func_74762_e("energy");
        NBTTagCompound tagCompoundInstability = tagCompound.func_74775_l("instability");
        for (ReactorFace reactorFace : ReactorFace.getLasers()) {
            if (reactorFace.indexStability < 0 || !tagCompoundInstability.func_74764_b(reactorFace.name)) continue;
            this.instabilityValues[reactorFace.indexStability] = tagCompoundInstability.func_74769_h(reactorFace.name);
        }
    }

    @Override
    public NBTTagCompound writeItemDropNBT(NBTTagCompound tagCompound) {
        tagCompound = super.writeItemDropNBT(tagCompound);
        tagCompound.func_82580_o("outputMode");
        tagCompound.func_82580_o("outputThreshold");
        tagCompound.func_82580_o("instabilityTarget");
        tagCompound.func_82580_o("stabilizerEnergy");
        tagCompound.func_82580_o("energy");
        tagCompound.func_82580_o("instability");
        return tagCompound;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tagCompound = super.func_189517_E_();
        tagCompound.func_82580_o("outputMode");
        tagCompound.func_82580_o("outputThreshold");
        tagCompound.func_82580_o("instabilityTarget");
        tagCompound.func_82580_o("stabilizerEnergy");
        return tagCompound;
    }

    @Override
    public void setDebugValues() {
        super.setDebugValues();
        this.containedEnergy = this.energyStored_max;
        for (ReactorFace reactorFace : ReactorFace.getLasers(this.enumTier)) {
            this.instabilityValues[reactorFace.indexStability] = 50.0;
        }
    }
}

