/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.forcefield;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IDamageReceiver;
import cr0s.warpdrive.block.ItemBlockAbstractBase;
import cr0s.warpdrive.block.forcefield.BlockAbstractForceField;
import cr0s.warpdrive.block.forcefield.TileEntityForceField;
import cr0s.warpdrive.block.forcefield.TileEntityForceFieldProjector;
import cr0s.warpdrive.block.hull.BlockHullGlass;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.EnumPermissionNode;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.data.ForceFieldSetup;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.event.ModelBakeEventHandler;
import cr0s.warpdrive.render.BakedModelCamouflage;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockForceField
extends BlockAbstractForceField
implements IDamageReceiver {
    private static final float BOUNDING_TOLERANCE = 0.05f;
    private static final AxisAlignedBB AABB_FORCEFIELD = new AxisAlignedBB((double)0.05f, (double)0.05f, (double)0.05f, (double)0.95f, (double)0.95f, (double)0.95f);
    public static final PropertyInteger FREQUENCY = PropertyInteger.func_177719_a((String)"frequency", (int)0, (int)15);
    private int previous_exploderId = -1;
    private long previous_tickWorld = -1L;
    private int previous_idDimension = Integer.MAX_VALUE;
    private Vec3d previous_vExplosion = new Vec3d(0.0, -1.0, 0.0);

    public BlockForceField(String registryName, EnumTier enumTier) {
        super(registryName, enumTier, Material.field_151592_s);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149663_c("warpdrive.force_field.block." + enumTier.func_176610_l());
        this.func_149722_s();
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FREQUENCY, (Comparable)Integer.valueOf(0)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{FREQUENCY}, new IUnlistedProperty[]{BlockProperties.CAMOUFLAGE});
    }

    @Nonnull
    public MapColor func_180659_g(IBlockState blockState, IBlockAccess blockAccess, BlockPos blockPos) {
        block3: {
            IExtendedBlockState blockStateExtended = (IExtendedBlockState)this.getExtendedState(blockState, blockAccess, blockPos);
            IBlockState blockStateCamouflage = (IBlockState)blockStateExtended.getValue((IUnlistedProperty)BlockProperties.CAMOUFLAGE);
            if (blockStateCamouflage != Blocks.field_150350_a) {
                try {
                    return blockStateCamouflage.func_185909_g(blockAccess, blockPos);
                }
                catch (Exception exception) {
                    if (Dictionary.BLOCKS_NOCAMOUFLAGE.contains(blockStateCamouflage.func_177230_c())) break block3;
                    exception.printStackTrace(WarpDrive.printStreamError);
                    WarpDrive.logger.error(String.format("Exception trying to get MapColor for %s", blockStateCamouflage));
                    Dictionary.BLOCKS_NOCAMOUFLAGE.add(blockStateCamouflage.func_177230_c());
                }
            }
        }
        return MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)((Integer)blockState.func_177229_b((IProperty)FREQUENCY))));
    }

    @Nonnull
    public IBlockState func_176203_a(int metadata) {
        return this.func_176223_P().func_177226_a((IProperty)FREQUENCY, (Comparable)Integer.valueOf(metadata));
    }

    public int func_176201_c(@Nonnull IBlockState blockState) {
        return (Integer)blockState.func_177229_b((IProperty)FREQUENCY);
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState blockState, IBlockAccess blockAccess, BlockPos blockPos) {
        if (!(blockState instanceof IExtendedBlockState)) {
            return blockState;
        }
        TileEntity tileEntity = blockAccess.func_175625_s(blockPos);
        if (!(tileEntity instanceof TileEntityForceField)) {
            return blockState;
        }
        TileEntityForceField tileEntityForceField = (TileEntityForceField)tileEntity;
        IBlockState blockStateCamouflage = tileEntityForceField.cache_blockStateCamouflage;
        if (!Commons.isValidCamouflage(blockStateCamouflage)) {
            blockStateCamouflage = Blocks.field_150350_a.func_176223_P();
        }
        return ((IExtendedBlockState)blockState).withProperty((IUnlistedProperty)BlockProperties.CAMOUFLAGE, (Object)blockStateCamouflage);
    }

    @Override
    @Nullable
    public ItemBlock createItemBlock() {
        return new ItemBlockAbstractBase((Block)this, true, true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(@Nonnull CreativeTabs creativeTab, @Nonnull NonNullList<ItemStack> list) {
    }

    @Nonnull
    public TileEntity func_149915_a(@Nonnull World world, int metadata) {
        return new TileEntityForceField();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void modelInitialisation() {
        super.modelInitialisation();
        for (Integer integer : FREQUENCY.func_177700_c()) {
            ResourceLocation registryName = this.getRegistryName();
            assert (registryName != null);
            String variant = String.format("%s=%d", FREQUENCY.func_177701_a(), integer);
            ModelBakeEventHandler.registerBakedModel(new ModelResourceLocation(registryName, variant), BakedModelCamouflage.class);
        }
    }

    public boolean func_176214_u(@Nonnull IBlockState blockState) {
        return false;
    }

    public boolean func_149662_c(@Nonnull IBlockState blockState) {
        return false;
    }

    public boolean func_149730_j(@Nonnull IBlockState blockState) {
        return false;
    }

    @Override
    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState blockState, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos blockPos, EntityPlayer entityPlayer) {
        return new ItemStack(Blocks.field_150350_a);
    }

    public int func_149745_a(@Nonnull Random random) {
        return 0;
    }

    @Override
    @Nonnull
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState blockState) {
        return EnumBlockRenderType.MODEL;
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos, @Nonnull EnumFacing facing) {
        BlockPos blockPosSide = blockPos.func_177972_a(facing);
        if (blockAccess.func_175623_d(blockPosSide)) {
            return true;
        }
        EnumFacing opposite = facing.func_176734_d();
        IBlockState blockStateSide = blockAccess.func_180495_p(blockPosSide);
        if (blockStateSide.func_177230_c() instanceof BlockGlass || blockStateSide.func_177230_c() instanceof BlockHullGlass || blockStateSide.func_177230_c() instanceof BlockForceField) {
            return blockState.func_177230_c().func_176201_c(blockState) != blockStateSide.func_177230_c().func_176201_c(blockStateSide);
        }
        return !blockStateSide.doesSideBlockRendering(blockAccess, blockPosSide, opposite);
    }

    protected TileEntityForceFieldProjector getProjector(@Nonnull World world, @Nonnull BlockPos blockPos, @Nullable TileEntityForceFieldProjector tileEntityForceFieldProjectorCandidate) {
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof TileEntityForceField) {
            return ((TileEntityForceField)tileEntity).getProjector(tileEntityForceFieldProjectorCandidate);
        }
        return null;
    }

    @Nullable
    private ForceFieldSetup getForceFieldSetup(@Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos) {
        block3: {
            TileEntity tileEntity = blockAccess.func_175625_s(blockPos);
            if (tileEntity instanceof TileEntityForceField) {
                try {
                    return ((TileEntityForceField)tileEntity).getForceFieldSetup();
                }
                catch (Exception exception) {
                    if (!Commons.throttleMe("BlockForceField.getForceFieldSetup")) break block3;
                    WarpDrive.logger.error(String.format("Exception trying to get force field setup %s", Commons.format(blockAccess, blockPos)));
                    exception.printStackTrace(WarpDrive.printStreamError);
                }
            }
        }
        return null;
    }

    public void func_180649_a(World world, BlockPos blockPos, EntityPlayer entityPlayer) {
        if (world.field_72995_K) {
            return;
        }
        ForceFieldSetup forceFieldSetup = this.getForceFieldSetup((IBlockAccess)world, blockPos);
        if (forceFieldSetup != null) {
            forceFieldSetup.onEntityEffect(world, blockPos, (Entity)entityPlayer);
        }
    }

    private boolean isAccessGranted(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull ForceFieldSetup forceFieldSetup) {
        boolean isAccessGranted = false;
        List entities = world.func_175647_a(EntityPlayer.class, new AxisAlignedBB((double)blockPos.func_177958_n() - 1.0, (double)blockPos.func_177956_o() - 1.0, (double)blockPos.func_177952_p() - 1.0, (double)blockPos.func_177958_n() + 2.0, (double)blockPos.func_177956_o() + 2.0, (double)blockPos.func_177952_p() + 2.0), null);
        for (EntityPlayer entityPlayer : entities) {
            if (entityPlayer == null || !entityPlayer.func_184812_l_() && !entityPlayer.func_175149_v() && !forceFieldSetup.isAccessGranted(entityPlayer, EnumPermissionNode.SNEAK_THROUGH)) continue;
            isAccessGranted = true;
            break;
        }
        return isAccessGranted;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos) {
        ForceFieldSetup forceFieldSetup = this.getForceFieldSetup(blockAccess, blockPos);
        if (forceFieldSetup != null && blockAccess instanceof World && this.isAccessGranted((World)blockAccess, blockPos, forceFieldSetup)) {
            return field_185506_k;
        }
        return AABB_FORCEFIELD;
    }

    @Nullable
    public Boolean isEntityInsideMaterial(IBlockAccess blockAccess, BlockPos blockPos, IBlockState iblockstate, Entity entity, double yToTest, Material materialIn, boolean testingHead) {
        if (blockAccess instanceof World) {
            this.doEntityCollision((World)blockAccess, blockPos, entity);
        }
        return super.isEntityInsideMaterial(blockAccess, blockPos, iblockstate, entity, yToTest, materialIn, testingHead);
    }

    public void func_180634_a(World world, BlockPos blockPos, IBlockState blockState, Entity entity) {
        super.func_180634_a(world, blockPos, blockState, entity);
        this.doEntityCollision(world, blockPos, entity);
    }

    private void doEntityCollision(World world, BlockPos blockPos, Entity entity) {
        if (world.field_72995_K) {
            return;
        }
        ForceFieldSetup forceFieldSetup = this.getForceFieldSetup((IBlockAccess)world, blockPos);
        if (forceFieldSetup != null) {
            forceFieldSetup.onEntityEffect(world, blockPos, entity);
            if (entity instanceof EntityLivingBase && entity.func_70089_S()) {
                Vector3 vCenter = new Vector3(blockPos).translate(0.5);
                AxisAlignedBB aabbEntity = entity.func_174813_aQ();
                RayTraceResult rayTraceResult = aabbEntity.func_72327_a(vCenter.toVec3d(), entity.func_174791_d());
                if (rayTraceResult != null) {
                    double distanceToCollision = rayTraceResult.field_72307_f.func_72438_d(vCenter.toVec3d());
                    double distanceToCenter = Math.sqrt(vCenter.distanceTo_square(entity));
                    double distanceMin = Math.min(distanceToCenter, distanceToCollision);
                    if (distanceMin > 1.0) {
                        ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 10, 0));
                        return;
                    }
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 20, 1));
                    boolean isAccessGranted = this.isAccessGranted(world, blockPos, forceFieldSetup);
                    if (!isAccessGranted) {
                        if (distanceMin < 0.44999999925494194) {
                            if (Commons.throttleMe("ForceFieldEntry" + entity.func_145782_y())) {
                                WarpDrive.logger.info(String.format("ForceField entry detected at %.3f m for %s %s", distanceMin, entity, Commons.format(world, blockPos)));
                            }
                            entity.func_70097_a(DamageSource.field_76380_i, 6666.0f);
                        } else {
                            if (entity instanceof EntityPlayer && Commons.throttleMe("ForceFieldProximity" + entity.func_145782_y())) {
                                WarpDrive.logger.info(String.format("ForceField proximity detected at %.3f m for %s %s", distanceMin, entity, Commons.format(world, blockPos)));
                            }
                            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76431_k, 80, 3));
                        }
                    }
                }
            }
        }
    }

    public int getLightValue(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos) {
        TileEntity tileEntity = blockAccess.func_175625_s(blockPos);
        if (tileEntity instanceof TileEntityForceField) {
            return ((TileEntityForceField)tileEntity).cache_lightCamouflage;
        }
        return 0;
    }

    private void downgrade(World world, BlockPos blockPos) {
        if (this.enumTier.getIndex() > 1) {
            TileEntity tileEntity;
            TileEntityForceFieldProjector tileEntityForceFieldProjector = this.getProjector(world, blockPos, null);
            IBlockState blockState = world.func_180495_p(blockPos);
            int frequency = blockState.func_177230_c() == this ? (Integer)blockState.func_177229_b((IProperty)FREQUENCY) : 0;
            world.func_180501_a(blockPos, WarpDrive.blockForceFields[this.enumTier.getIndex() - 1].func_176223_P().func_177226_a((IProperty)FREQUENCY, (Comparable)Integer.valueOf((frequency + 1) % 16)), 2);
            if (tileEntityForceFieldProjector != null && (tileEntity = world.func_175625_s(blockPos)) instanceof TileEntityForceField) {
                ((TileEntityForceField)tileEntity).setProjector(tileEntityForceFieldProjector.func_174877_v());
            }
        } else {
            world.func_175698_g(blockPos);
        }
    }

    public float func_149638_a(@Nullable Entity exploder) {
        int exploderId;
        int n = exploderId = exploder == null ? -1 : exploder.func_145782_y();
        if (exploderId != this.previous_exploderId && Commons.isServerThread()) {
            if (Commons.throttleMe("getExplosionResistance")) {
                new RuntimeException(String.format("Invalid call to deprecated getExplosionResistance(%s)", exploder)).printStackTrace(WarpDrive.printStreamError);
            }
            return Float.MAX_VALUE;
        }
        return super.func_149638_a(exploder);
    }

    public float getExplosionResistance(@Nonnull World world, @Nonnull BlockPos blockPos, @Nullable Entity exploder, @Nonnull Explosion explosion) {
        ForceFieldSetup forceFieldSetup;
        Vector3 vDirection;
        double magnitude;
        boolean isFirstHit;
        this.previous_exploderId = exploder == null ? -1 : exploder.func_145782_y();
        long tickWorld = world.func_82737_E();
        Vec3d vExplosion = explosion.getPosition();
        boolean bl = isFirstHit = Math.abs(tickWorld - this.previous_tickWorld) > 100L || this.previous_idDimension != world.field_73011_w.getDimension() || Math.abs(this.previous_vExplosion.field_72450_a - vExplosion.field_72450_a) > 5.0 || Math.abs(this.previous_vExplosion.field_72448_b - vExplosion.field_72448_b) > 5.0 || Math.abs(this.previous_vExplosion.field_72449_c - vExplosion.field_72449_c) > 5.0;
        if (isFirstHit) {
            this.previous_tickWorld = tickWorld;
            this.previous_idDimension = world.field_73011_w.getDimension();
            this.previous_vExplosion = new Vec3d(vExplosion.field_72450_a, vExplosion.field_72448_b, vExplosion.field_72449_c);
            WarpDrive.logger.info(String.format("Force field %s %s: explosion check of size %.3f from exploder %s %s %s explosion %s", new Object[]{this.enumTier, Commons.format(world, blockPos), Float.valueOf(explosion.field_77280_f), exploder != null ? EntityList.func_191301_a((Entity)exploder) : "-", exploder != null ? exploder.getClass().toString() : "-", exploder, explosion}));
        }
        if (!Commons.isSafeThread()) {
            if (isFirstHit) {
                new ConcurrentModificationException(String.format("Bad multithreading detected %s from exploder %s explosion %s", Commons.format(world, blockPos), exploder, explosion)).printStackTrace(WarpDrive.printStreamError);
            } else {
                return Float.MAX_VALUE;
            }
        }
        if (exploder == null && vExplosion.field_72450_a == Math.rint(vExplosion.field_72450_a) && vExplosion.field_72448_b == Math.rint(vExplosion.field_72448_b) && vExplosion.field_72449_c == Math.rint(vExplosion.field_72449_c)) {
            BlockPos blockPosExplosion = new BlockPos((int)vExplosion.field_72450_a, (int)vExplosion.field_72448_b, (int)vExplosion.field_72449_c);
            IBlockState blockState = world.func_180495_p(blockPosExplosion);
            TileEntity tileEntity = world.func_175625_s(blockPosExplosion);
            if (isFirstHit) {
                WarpDrive.logger.info(String.format("Force field %s %s: explosion from %s %s with tileEntity %s", new Object[]{this.enumTier, Commons.format(world, blockPos), blockState.func_177230_c(), blockState.func_177230_c().getRegistryName(), tileEntity}));
            }
            return Float.MAX_VALUE;
        }
        double strength = explosion.field_77280_f;
        float factorResistance = 1.0f;
        if (explosion.getClass().equals(Explosion.class) && strength > WarpDriveConfig.FORCE_FIELD_EXPLOSION_STRENGTH_VANILLA_CAP) {
            factorResistance = (float)(strength / WarpDriveConfig.FORCE_FIELD_EXPLOSION_STRENGTH_VANILLA_CAP);
            strength = Math.min(WarpDriveConfig.FORCE_FIELD_EXPLOSION_STRENGTH_VANILLA_CAP, strength);
        }
        if (strength == 0.0) {
            String nameExplosion;
            switch (nameExplosion = explosion.getClass().toString()) {
                case "class icbm.classic.content.explosive.blast.threaded.BlastNuclear": {
                    strength = 15.0;
                    break;
                }
                default: {
                    if (isFirstHit) {
                        WarpDrive.logger.error(String.format("Blocking invalid explosion instance %s %s %s", vExplosion, nameExplosion, explosion));
                    }
                    return Float.MAX_VALUE;
                }
            }
        }
        if ((magnitude = Math.max(1.0, (vDirection = new Vector3((double)blockPos.func_177958_n() + 0.5 - vExplosion.field_72450_a, (double)blockPos.func_177956_o() + 0.5 - vExplosion.field_72448_b, (double)blockPos.func_177952_p() + 0.5 - vExplosion.field_72449_c)).getMagnitude())) > strength) {
            if (isFirstHit) {
                WarpDrive.logger.error(String.format("Blocking out of range explosion instance %s %s at %.1f m", vExplosion, explosion, magnitude));
            }
            return Float.MAX_VALUE;
        }
        if (magnitude != 0.0) {
            vDirection.scale(1.0 / magnitude);
        }
        double damageLevel = strength / (magnitude * magnitude) * 1.0;
        double damageLeft = 0.0;
        ForceFieldSetup forceFieldSetup2 = forceFieldSetup = Commons.isSafeThread() ? this.getForceFieldSetup((IBlockAccess)world, blockPos) : null;
        if (forceFieldSetup != null) {
            damageLeft = forceFieldSetup.applyDamage(world, DamageSource.func_94539_a((Explosion)explosion), damageLevel);
        }
        assert (damageLeft >= 0.0);
        if (isFirstHit && WarpDriveConfig.LOGGING_FORCE_FIELD) {
            WarpDrive.logger.info(String.format("Force field %s %s: explosion from %s strength %.3f magnitude %.3f damageLevel %.3f damageLeft %.3f", new Object[]{this.enumTier, Commons.format(world, blockPos), vExplosion, strength, magnitude, damageLevel, damageLeft}));
        }
        return factorResistance * super.getExplosionResistance(world, blockPos, exploder, explosion);
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess blockAccess, BlockPos blockPos, Entity entity) {
        return false;
    }

    public void onBlockExploded(World world, @Nonnull BlockPos blockPos, @Nonnull Explosion explosion) {
        if (WarpDriveConfig.LOGGING_WEAPON) {
            WarpDrive.logger.warn(String.format("Force field %s %s has exploded in explosion %s at %s", new Object[]{this.enumTier, Commons.format(world, blockPos), explosion, explosion.getPosition()}));
        }
        this.downgrade(world, blockPos);
        super.onBlockExploded(world, blockPos, explosion);
    }

    @Override
    public void onEMP(@Nonnull World world, @Nonnull BlockPos blockPos, float efficiency) {
        if (efficiency * (1.0f - 0.2f * (float)(this.enumTier.getIndex() - 1)) > world.field_73012_v.nextFloat()) {
            this.downgrade(world, blockPos);
        }
    }

    public void func_180652_a(World world, BlockPos blockPos, Explosion explosion) {
        this.downgrade(world, blockPos);
        super.func_180652_a(world, blockPos, explosion);
    }

    @Override
    public float getBlockHardness(IBlockState blockState, World world, BlockPos blockPos, DamageSource damageSource, int damageParameter, Vector3 damageDirection, int damageLevel) {
        return WarpDriveConfig.HULL_HARDNESS[this.enumTier.getIndex()];
    }

    @Override
    public int applyDamage(IBlockState blockState, World world, BlockPos blockPos, DamageSource damageSource, int damageParameter, Vector3 damageDirection, int damageLevel) {
        ForceFieldSetup forceFieldSetup = this.getForceFieldSetup((IBlockAccess)world, blockPos);
        if (forceFieldSetup != null) {
            return (int)Math.round(forceFieldSetup.applyDamage(world, damageSource, damageLevel));
        }
        return damageLevel;
    }

    public float func_176195_g(IBlockState blockState, World world, BlockPos blockPos) {
        String name = Thread.currentThread().getName();
        if (name.startsWith("ICBM")) {
            return WarpDriveConfig.HULL_HARDNESS[this.enumTier.getIndex()];
        }
        return super.func_176195_g(blockState, world, blockPos);
    }
}

